/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nvdl;

import com.thaiopensource.resolver.xml.sax.SAXResolver;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Uri;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.OptionArgumentPresenceException;
import com.thaiopensource.validate.ResolverFactory;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.nvdl.ActionSet;
import com.thaiopensource.validate.nvdl.AllowAction;
import com.thaiopensource.validate.nvdl.AttachAction;
import com.thaiopensource.validate.nvdl.AttachPlaceholderAction;
import com.thaiopensource.validate.nvdl.AttributeActionSet;
import com.thaiopensource.validate.nvdl.ElementsOrAttributes;
import com.thaiopensource.validate.nvdl.Hashset;
import com.thaiopensource.validate.nvdl.Mode;
import com.thaiopensource.validate.nvdl.ModeUsage;
import com.thaiopensource.validate.nvdl.NamespaceSpecification;
import com.thaiopensource.validate.nvdl.Path;
import com.thaiopensource.validate.nvdl.RejectAction;
import com.thaiopensource.validate.nvdl.SchemaReceiverImpl;
import com.thaiopensource.validate.nvdl.Trigger;
import com.thaiopensource.validate.nvdl.UnwrapAction;
import com.thaiopensource.validate.nvdl.ValidateAction;
import com.thaiopensource.validate.nvdl.ValidatorImpl;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    private static final String IMPLICIT_MODE_NAME = "#implicit";
    private static final String WRAPPER_MODE_NAME = "#wrapper";
    static final String NVDL_URI = "http://purl.oclc.org/dsdl/nvdl/ns/structure/1.0";
    private final Hashtable modeMap = new Hashtable();
    private final List triggers = new ArrayList();
    private Mode startMode;
    private final Mode defaultBaseMode;
    private final boolean attributesSchema;

    SchemaImpl(PropertyMap propertyMap) {
        super(propertyMap);
        this.attributesSchema = propertyMap.contains(WrapProperty.ATTRIBUTE_OWNER);
        this.makeBuiltinMode("#allow", AllowAction.class);
        this.makeBuiltinMode("#attach", AttachAction.class);
        this.makeBuiltinMode("#unwrap", UnwrapAction.class);
        this.defaultBaseMode = this.makeBuiltinMode("#reject", RejectAction.class);
    }

    private Mode makeBuiltinMode(String string, Class clazz) {
        Mode mode = this.lookupCreateMode(string);
        ActionSet actionSet = new ActionSet();
        ModeUsage modeUsage = new ModeUsage(Mode.CURRENT, mode);
        if (clazz == AttachAction.class) {
            actionSet.setResultAction(new AttachAction(modeUsage));
        } else if (clazz == AllowAction.class) {
            actionSet.addNoResultAction(new AllowAction(modeUsage));
        } else if (clazz == UnwrapAction.class) {
            actionSet.setResultAction(new UnwrapAction(modeUsage));
        } else {
            actionSet.addNoResultAction(new RejectAction(modeUsage));
        }
        mode.bindElement("##any", NamespaceSpecification.DEFAULT_WILDCARD, actionSet);
        mode.noteDefined(null);
        AttributeActionSet attributeActionSet = new AttributeActionSet();
        if (this.attributesSchema) {
            attributeActionSet.setReject(true);
        } else {
            attributeActionSet.setAttach(true);
        }
        mode.bindAttribute("##any", NamespaceSpecification.DEFAULT_WILDCARD, attributeActionSet);
        return mode;
    }

    SchemaFuture installHandlers(XMLReader xMLReader, SchemaReceiverImpl schemaReceiverImpl) {
        Handler handler = new Handler(schemaReceiverImpl);
        xMLReader.setContentHandler(handler);
        return handler;
    }

    @Override
    public Validator createValidator(PropertyMap propertyMap) {
        return new ValidatorImpl(this.startMode, this.triggers, propertyMap);
    }

    private Mode getModeAttribute(Attributes attributes, String string) {
        return this.lookupCreateMode(attributes.getValue("", string));
    }

    private Mode lookupCreateMode(String string) {
        if (string == null) {
            return null;
        }
        Mode mode = (Mode)this.modeMap.get(string = string.trim());
        if (mode == null) {
            mode = new Mode(string, this.defaultBaseMode);
            this.modeMap.put(string, mode);
        }
        return mode;
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final SAXResolver resolver;
        private final Localizer localizer = new Localizer(SchemaImpl.class);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private String defaultSchemaType;
        private Validator validator;
        ModeData md = new ModeData();
        private Stack modeDataStack = new Stack();
        private Stack nvdlStack = new Stack();

        Handler(SchemaReceiverImpl schemaReceiverImpl) {
            this.sr = schemaReceiverImpl;
            this.eh = schemaReceiverImpl.getProperties().get(ValidateProperty.ERROR_HANDLER);
            this.ceh = new CountingErrorHandler(this.eh);
            this.resolver = ResolverFactory.createResolver(schemaReceiverImpl.getProperties());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(this.sr.getProperties());
                propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this.ceh);
                this.validator = this.sr.getNvdlSchema().createValidator(propertyMapBuilder.toPropertyMap());
            }
            catch (IOException iOException) {
                throw new WrappedIOException(iOException);
            }
            catch (IncorrectSchemaException incorrectSchemaException) {
                throw new RuntimeException("internal error in RNG schema for NVDL");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        @Override
        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Hashset hashset = new Hashset();
            Hashset hashset2 = new Hashset();
            Enumeration enumeration = SchemaImpl.this.modeMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(string);
                if (!mode.isDefined()) {
                    this.error("undefined_mode", string, mode.getWhereUsed());
                }
                for (Mode mode2 = mode; mode2 != null && !hashset2.contains(mode2); mode2 = mode2.getBaseMode()) {
                    if (hashset.contains(mode2)) {
                        this.error("mode_cycle", mode2.getName(), mode2.getWhereDefined());
                        break;
                    }
                    hashset.add(mode2);
                }
                hashset2.addAll(hashset);
                hashset.clear();
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        @Override
        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (runtimeException instanceof WrappedIOException) {
                throw ((WrappedIOException)runtimeException).getException();
            }
            return runtimeException;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            super.startElement(string, string2, string3, attributes);
            this.xmlBaseHandler.startElement();
            String string4 = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (string4 != null) {
                this.xmlBaseHandler.xmlBaseAttribute(string4);
            }
            if (!SchemaImpl.NVDL_URI.equals(string) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (string2.equals("rules")) {
                this.parseRules(attributes);
            } else if (string2.equals("mode")) {
                String string5 = (String)this.nvdlStack.peek();
                if ("rules".equals(string5)) {
                    this.parseMode(attributes);
                } else if ("mode".equals(string5)) {
                    this.parseIncludedMode(attributes);
                } else {
                    this.parseNestedMode(attributes);
                }
            } else if (string2.equals("namespace")) {
                this.parseNamespace(attributes);
            } else if (string2.equals("anyNamespace")) {
                this.parseAnyNamespace(attributes);
            } else if (string2.equals("validate")) {
                this.parseValidate(attributes);
            } else if (string2.equals("reject")) {
                this.parseReject(attributes);
            } else if (string2.equals("attach")) {
                this.parseAttach(attributes);
            } else if (string2.equals("unwrap")) {
                this.parseUnwrap(attributes);
            } else if (string2.equals("attachPlaceholder")) {
                this.parseAttachPlaceholder(attributes);
            } else if (string2.equals("allow")) {
                this.parseAllow(attributes);
            } else if (string2.equals("context")) {
                this.parseContext(attributes);
            } else if (string2.equals("option")) {
                this.parseOption(attributes);
            } else if (string2.equals("trigger")) {
                this.parseTrigger(attributes);
            } else if (string2.equals("schema")) {
                this.error("embedded_schemas");
            } else if (string2.equals("cancelNestedActions")) {
                this.parseCancelNestedActions(attributes);
            } else if (!string2.equals("message")) {
                throw new RuntimeException("unexpected element \"" + string2 + "\"");
            }
            this.nvdlStack.push(string2);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            super.endElement(string, string2, string3);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            this.nvdlStack.pop();
            if (string2.equals("validate")) {
                this.finishValidate();
            } else if (string2.equals("mode")) {
                String string4 = (String)this.nvdlStack.peek();
                if ("rules".equals(string4)) {
                    this.finishMode();
                } else if ("mode".equals(string4)) {
                    this.finishIncludedMode();
                } else {
                    this.finishNestedMode();
                }
            }
        }

        private void parseRules(Attributes attributes) {
            SchemaImpl.this.startMode = SchemaImpl.this.getModeAttribute(attributes, "startMode");
            if (SchemaImpl.this.startMode == null) {
                SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(SchemaImpl.IMPLICIT_MODE_NAME);
                this.md.currentMode = SchemaImpl.this.startMode;
                SchemaImpl.this.startMode.noteDefined(null);
            }
            SchemaImpl.this.startMode.noteUsed(this.locator);
            if (SchemaImpl.this.attributesSchema) {
                Mode mode = SchemaImpl.this.lookupCreateMode(SchemaImpl.WRAPPER_MODE_NAME);
                ActionSet actionSet = new ActionSet();
                actionSet.addNoResultAction(new AllowAction(new ModeUsage(SchemaImpl.this.startMode, SchemaImpl.this.startMode)));
                mode.bindElement("##any", NamespaceSpecification.DEFAULT_WILDCARD, actionSet);
                mode.noteDefined(null);
                SchemaImpl.this.startMode = mode;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
        }

        private void parseMode(Attributes attributes) throws SAXException {
            this.md.currentMode = SchemaImpl.this.getModeAttribute(attributes, "name");
            if (this.md.currentMode.isDefined()) {
                this.error("duplicate_mode", this.md.currentMode.getName());
                this.error("first_mode", this.md.currentMode.getName(), this.md.currentMode.getWhereDefined());
            } else {
                Mode mode = SchemaImpl.this.getModeAttribute(attributes, "extends");
                if (mode != null) {
                    this.md.currentMode.setBaseMode(mode);
                }
                this.md.currentMode.noteDefined(this.locator);
            }
        }

        private void parseIncludedMode(Attributes attributes) throws SAXException {
            Mode mode = this.md.currentMode;
            this.modeDataStack.push(this.md);
            this.md = new ModeData();
            this.md.currentMode = new Mode(SchemaImpl.this.defaultBaseMode);
            this.md.currentMode.noteDefined(this.locator);
            mode.addIncludedMode(this.md.currentMode);
        }

        private void parseNestedMode(Attributes attributes) throws SAXException {
            ModeData modeData = this.md;
            this.modeDataStack.push(this.md);
            this.md = new ModeData();
            this.md.currentMode = modeData.lastMode;
            if (this.md.currentMode.isDefined()) {
                this.error("duplicate_mode", this.md.currentMode.getName());
                this.error("first_mode", this.md.currentMode.getName(), this.md.currentMode.getWhereDefined());
            } else {
                this.md.currentMode.noteDefined(this.locator);
            }
        }

        private void parseNamespace(Attributes attributes) throws SAXException {
            this.md.anyNamespace = false;
            this.parseRule(this.getNs(attributes), attributes);
        }

        private void parseAnyNamespace(Attributes attributes) throws SAXException {
            this.md.anyNamespace = true;
            this.parseRule("##any", attributes);
        }

        private void parseRule(String string, Attributes attributes) throws SAXException {
            this.md.match = this.toElementsOrAttributes(attributes.getValue("", "match"), ElementsOrAttributes.ELEMENTS);
            String string2 = attributes.getValue("", "wildCard");
            if (string2 == null) {
                string2 = NamespaceSpecification.DEFAULT_WILDCARD;
            }
            if (this.md.match.containsAttributes()) {
                this.md.attributeActions = new AttributeActionSet();
                if (!this.md.currentMode.bindAttribute(string, string2, this.md.attributeActions)) {
                    if (string.equals("##any")) {
                        this.error("duplicate_attribute_action_any_namespace");
                    } else {
                        this.error("duplicate_attribute_action", string);
                    }
                }
            } else {
                this.md.attributeActions = null;
            }
            if (this.md.match.containsElements()) {
                this.md.actions = new ActionSet();
                if (!this.md.currentMode.bindElement(string, string2, this.md.actions)) {
                    if (string.equals("##any")) {
                        this.error("duplicate_element_action_any_namespace");
                    } else {
                        this.error("duplicate_element_action", string);
                    }
                }
            } else {
                this.md.actions = null;
            }
        }

        private void parseValidate(Attributes attributes) throws SAXException {
            this.md.schemaUriRef = this.getSchema(attributes);
            this.md.schemaUriBase = this.xmlBaseHandler.getBaseUri();
            this.md.schemaType = this.getSchemaType(attributes);
            if (this.md.schemaType == null) {
                this.md.schemaType = this.defaultSchemaType;
            }
            if ("application/x-rnc".equals(this.md.schemaType)) {
                this.warning("legacy_rnc_media_type", this.locator);
            }
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
            } else {
                this.md.modeUsage = null;
            }
            this.md.options = new PropertyMapBuilder();
            this.md.mustSupportOptions.clear();
        }

        private void finishValidate() throws SAXException {
            if (this.md.schemaUriRef != null) {
                try {
                    Schema schema;
                    if (this.md.attributeActions != null) {
                        schema = this.createSubSchema(true);
                        this.md.attributeActions.addSchema(schema);
                    }
                    if (this.md.actions != null) {
                        schema = this.createSubSchema(false);
                        this.md.actions.addNoResultAction(new ValidateAction(this.md.modeUsage, schema));
                    }
                }
                catch (IncorrectSchemaException incorrectSchemaException) {
                    this.hadError = true;
                }
                catch (IOException iOException) {
                    throw new WrappedIOException(iOException);
                }
            }
        }

        private void finishMode() throws SAXException {
        }

        private void finishIncludedMode() throws SAXException {
            this.md = (ModeData)this.modeDataStack.pop();
        }

        private void finishNestedMode() throws SAXException {
            this.md = (ModeData)this.modeDataStack.pop();
        }

        private Schema createSubSchema(boolean bl) throws IOException, IncorrectSchemaException, SAXException {
            PropertyMap propertyMap = this.md.options.toPropertyMap();
            Schema schema = this.sr.createChildSchema(this.resolver.resolve(this.md.schemaUriRef, this.md.schemaUriBase), this.md.schemaType, propertyMap, bl);
            PropertyMap propertyMap2 = schema.getProperties();
            Enumeration enumeration = this.md.mustSupportOptions.elements();
            while (enumeration.hasMoreElements()) {
                MustSupportOption mustSupportOption = (MustSupportOption)enumeration.nextElement();
                Object t = propertyMap2.get(mustSupportOption.pid);
                if (t == null) {
                    this.error("unsupported_option", mustSupportOption.name, mustSupportOption.locator);
                    continue;
                }
                if (t.equals(propertyMap.get(mustSupportOption.pid))) continue;
                this.error("unsupported_option_arg", mustSupportOption.name, mustSupportOption.locator);
            }
            return schema;
        }

        private void parseOption(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "mustSupport");
            boolean bl = string != null ? (string = string.trim()).equals("1") || string.equals("true") : false;
            String string2 = Uri.resolve(SchemaImpl.NVDL_URI, attributes.getValue("", "name"));
            Option option = this.sr.getOption(string2);
            if (option == null) {
                if (bl) {
                    this.error("unknown_option", string2);
                }
            } else {
                String string3 = attributes.getValue("", "arg");
                try {
                    PropertyId<?> propertyId = option.getPropertyId();
                    Object object = option.valueOf(string3);
                    Object obj = this.md.options.get(propertyId);
                    if (obj != null) {
                        if ((object = option.combine(new Object[]{obj, object})) == null) {
                            this.error("duplicate_option", string2);
                        } else {
                            this.md.options.put(propertyId, object);
                        }
                    } else {
                        this.md.options.put(propertyId, object);
                        this.md.mustSupportOptions.addElement(new MustSupportOption(string2, propertyId, this.locator == null ? null : new LocatorImpl(this.locator)));
                    }
                }
                catch (OptionArgumentPresenceException optionArgumentPresenceException) {
                    this.error(string3 == null ? "option_requires_argument" : "option_unexpected_argument", string2);
                }
                catch (OptionArgumentException optionArgumentException) {
                    if (string3 == null) {
                        this.error("option_requires_argument", string2);
                    }
                    this.error("option_bad_argument", string2, string3);
                }
            }
        }

        private void parseTrigger(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "ns");
            String string2 = attributes.getValue("", "nameList");
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            HashSet<String> hashSet = new HashSet<String>(stringTokenizer.countTokens());
            while (stringTokenizer.hasMoreTokens()) {
                hashSet.add(stringTokenizer.nextToken());
            }
            SchemaImpl.this.triggers.add(new Trigger(string, hashSet));
        }

        private void parseAttach(Attributes attributes) {
            if (this.md.attributeActions != null) {
                this.md.attributeActions.setAttach(true);
            }
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.setResultAction(new AttachAction(this.md.modeUsage));
            } else {
                this.md.modeUsage = null;
            }
        }

        private void parseUnwrap(Attributes attributes) {
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.setResultAction(new UnwrapAction(this.md.modeUsage));
            } else {
                this.md.modeUsage = null;
            }
        }

        private void parseAttachPlaceholder(Attributes attributes) {
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.setResultAction(new AttachPlaceholderAction(this.md.modeUsage));
            } else {
                this.md.modeUsage = null;
            }
        }

        private void parseAllow(Attributes attributes) {
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.addNoResultAction(new AllowAction(this.md.modeUsage));
            } else {
                this.md.modeUsage = null;
            }
        }

        private void parseReject(Attributes attributes) {
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.addNoResultAction(new RejectAction(this.md.modeUsage));
            } else {
                this.md.modeUsage = null;
            }
            if (this.md.attributeActions != null) {
                this.md.attributeActions.setReject(true);
            }
        }

        private void parseCancelNestedActions(Attributes attributes) {
            if (this.md.actions != null) {
                this.md.modeUsage = this.getModeUsage(attributes);
                this.md.actions.setCancelNestedActions(true);
            } else {
                this.md.modeUsage = null;
            }
            if (this.md.attributeActions != null) {
                this.md.attributeActions.setCancelNestedActions(true);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            Mode mode = this.getUseMode(attributes);
            this.md.lastMode = mode;
            try {
                Vector vector = Path.parse(attributes.getValue("", "path"));
                if (this.md.modeUsage != null) {
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        Path path = (Path)vector.elementAt(i);
                        if (this.md.modeUsage.addContext(path.isRoot(), path.getNames(), mode)) continue;
                        this.error("duplicate_path", path.toString());
                    }
                }
            }
            catch (Path.ParseException parseException) {
                this.error(parseException.getMessageKey());
            }
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "schema");
            if ("".equals(string)) {
                this.error("no_schema");
                string = null;
            }
            if (string != null) {
                if (Uri.hasFragmentId(string)) {
                    this.error("schema_fragment_id");
                }
                return string;
            }
            return null;
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes toElementsOrAttributes(String string, ElementsOrAttributes elementsOrAttributes) {
            if (string == null) {
                return elementsOrAttributes;
            }
            ElementsOrAttributes elementsOrAttributes2 = ElementsOrAttributes.NEITHER;
            if (string.indexOf("elements") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addElements();
            }
            if (string.indexOf("attributes") >= 0) {
                elementsOrAttributes2 = elementsOrAttributes2.addAttributes();
            }
            return elementsOrAttributes2;
        }

        private ModeUsage getModeUsage(Attributes attributes) {
            this.md.lastMode = this.getUseMode(attributes);
            return new ModeUsage(this.md.lastMode, this.md.currentMode);
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode = SchemaImpl.this.getModeAttribute(attributes, "useMode");
            if (mode == null) {
                return new Mode(SchemaImpl.this.defaultBaseMode);
            }
            mode.noteUsed(this.locator);
            return mode;
        }

        private String getNs(Attributes attributes) throws SAXException {
            String string = attributes.getValue("", "ns");
            if (string != null && !Uri.isAbsolute(string) && !string.equals("")) {
                this.error("ns_absolute");
            }
            return string;
        }

        void error(String string) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string), this.locator));
        }

        void error(String string, String string2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), this.locator));
        }

        void error(String string, String string2, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2), locator));
        }

        void error(String string, String string2, String string3) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(string, string2, string3), this.locator));
        }

        void warning(String string, Locator locator) throws SAXException {
            if (this.eh == null) {
                return;
            }
            this.eh.warning(new SAXParseException(this.localizer.message(string), locator));
        }

        class ModeData {
            private Mode currentMode = null;
            private ElementsOrAttributes match;
            private ActionSet actions;
            private AttributeActionSet attributeActions;
            private String schemaUriRef;
            private String schemaUriBase;
            private String schemaType;
            private PropertyMapBuilder options;
            private final Vector mustSupportOptions = new Vector();
            private ModeUsage modeUsage;
            private boolean anyNamespace;
            private Mode lastMode;

            ModeData() {
            }
        }
    }

    private static class MustSupportOption {
        private final String name;
        private final PropertyId pid;
        private final Locator locator;

        MustSupportOption(String string, PropertyId propertyId, Locator locator) {
            this.name = string;
            this.pid = propertyId;
            this.locator = locator;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException iOException) {
            this.exception = iOException;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

