/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedMap;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.history.changes.ChangeDetectorVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.execution.steps.AfterExecutionResult;
import org.gradle.internal.execution.steps.PreviousExecutionContext;
import org.gradle.internal.execution.steps.Step;
import org.gradle.internal.execution.steps.WorkspaceContext;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class StoreExecutionStateStep<C extends PreviousExecutionContext, R extends AfterExecutionResult>
implements Step<C, R> {
    private final Step<? super C, ? extends R> delegate;

    public StoreExecutionStateStep(Step<? super C, ? extends R> delegate) {
        this.delegate = delegate;
    }

    @Override
    public R execute(UnitOfWork work, C context) {
        AfterExecutionResult result = (AfterExecutionResult)this.delegate.execute(work, context);
        ((WorkspaceContext)context).getHistory().ifPresent(history -> result.getAfterExecutionState().ifPresent(afterExecutionState -> {
            boolean shouldStore;
            boolean bl = shouldStore = result.getExecution().isSuccessful() || context.getPreviousExecutionState().map(previewExecutionState -> StoreExecutionStateStep.didOutputsChange(previewExecutionState.getOutputFilesProducedByWork(), afterExecutionState.getOutputFilesProducedByWork())).orElse(true) != false;
            if (shouldStore) {
                history.store(context.getIdentity().getUniqueId(), result.getExecution().isSuccessful(), (AfterExecutionState)afterExecutionState);
            }
        }));
        return (R)result;
    }

    private static boolean didOutputsChange(ImmutableSortedMap<String, FileSystemSnapshot> previous, ImmutableSortedMap<String, FileSystemSnapshot> current) {
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges((SortedMap<String, FileSystemSnapshot>)previous, (SortedMap<String, FileSystemSnapshot>)current);
        changes.accept(visitor);
        return visitor.hasAnyChanges();
    }
}

