/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.component.LibraryComponentSelector;
import org.gradle.platform.base.Binary;
import org.gradle.platform.base.VariantComponent;

public class LibraryResolutionResult {
    public static final Function<String, String> QUOTE_TRANSFORMER = new Function<String, String>(){

        public String apply(String input) {
            return "'" + input + "'";
        }
    };
    private final Map<String, VariantComponent> libsMatchingRequirements;
    private final Map<String, VariantComponent> libsNotMatchingRequirements;
    private final Class<? extends Binary> binaryType;
    private boolean projectNotFound;
    private VariantComponent selectedLibrary;
    private VariantComponent nonMatchingLibrary;

    private LibraryResolutionResult(Class<? extends Binary> binaryType) {
        this.binaryType = binaryType;
        this.libsMatchingRequirements = Maps.newHashMap();
        this.libsNotMatchingRequirements = Maps.newHashMap();
    }

    private VariantComponent getSingleMatchingLibrary() {
        if (this.libsMatchingRequirements.size() == 1) {
            return this.libsMatchingRequirements.values().iterator().next();
        }
        return null;
    }

    private void resolve(String libraryName) {
        if (libraryName == null) {
            VariantComponent singleMatchingLibrary = this.getSingleMatchingLibrary();
            if (singleMatchingLibrary == null) {
                return;
            }
            libraryName = singleMatchingLibrary.getName();
        }
        this.selectedLibrary = this.libsMatchingRequirements.get(libraryName);
        this.nonMatchingLibrary = this.libsNotMatchingRequirements.get(libraryName);
    }

    public boolean isProjectNotFound() {
        return this.projectNotFound;
    }

    public boolean hasLibraries() {
        return !this.libsMatchingRequirements.isEmpty() || !this.libsNotMatchingRequirements.isEmpty();
    }

    public VariantComponent getSelectedLibrary() {
        return this.selectedLibrary;
    }

    public VariantComponent getNonMatchingLibrary() {
        return this.nonMatchingLibrary;
    }

    public List<String> getCandidateLibraries() {
        return Lists.newArrayList(this.libsMatchingRequirements.keySet());
    }

    public String toResolutionErrorMessage(LibraryComponentSelector selector) {
        List<String> candidateLibraries = LibraryResolutionResult.formatLibraryNames(this.getCandidateLibraries());
        String projectPath = selector.getProjectPath();
        String libraryName = selector.getLibraryName();
        StringBuilder sb = new StringBuilder("Project '").append(projectPath).append("'");
        if (libraryName == null || !this.hasLibraries()) {
            if (this.isProjectNotFound()) {
                sb.append(" not found.");
            } else if (!this.hasLibraries()) {
                sb.append(" doesn't define any library.");
            } else {
                sb.append(" contains more than one library. Please select one of ");
                Joiner.on((String)", ").appendTo(sb, candidateLibraries);
            }
        } else {
            VariantComponent notMatchingRequirements = this.getNonMatchingLibrary();
            if (notMatchingRequirements != null) {
                sb.append(" contains a library named '").append(libraryName).append("' but it doesn't have any binary of type ").append(this.binaryType.getSimpleName());
            } else {
                sb.append(" does not contain library '").append(libraryName).append("'. Did you want to use ");
                if (candidateLibraries.size() == 1) {
                    sb.append(candidateLibraries.get(0));
                } else {
                    sb.append("one of ");
                    Joiner.on((String)", ").appendTo(sb, candidateLibraries);
                }
                sb.append("?");
            }
        }
        return sb.toString();
    }

    public static LibraryResolutionResult of(Class<? extends Binary> binaryType, Collection<? extends VariantComponent> libraries, String libraryName, Predicate<? super VariantComponent> libraryFilter) {
        LibraryResolutionResult result = new LibraryResolutionResult(binaryType);
        for (VariantComponent variantComponent : libraries) {
            if (libraryFilter.apply((Object)variantComponent)) {
                result.libsMatchingRequirements.put(variantComponent.getName(), variantComponent);
                continue;
            }
            result.libsNotMatchingRequirements.put(variantComponent.getName(), variantComponent);
        }
        result.resolve(libraryName);
        return result;
    }

    public static LibraryResolutionResult projectNotFound(Class<? extends Binary> binaryType) {
        LibraryResolutionResult projectNotFoundResult = new LibraryResolutionResult(binaryType);
        projectNotFoundResult.projectNotFound = true;
        return projectNotFoundResult;
    }

    public static LibraryResolutionResult emptyResolutionResult(Class<? extends Binary> binaryType) {
        return new LibraryResolutionResult(binaryType);
    }

    private static List<String> formatLibraryNames(List<String> libs) {
        List list = Lists.transform(libs, QUOTE_TRANSFORMER);
        return Ordering.natural().sortedCopy((Iterable)list);
    }
}

