/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.KeysAndCert;
import net.i2p.data.Lease;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.TunnelId;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class LeaseSet
extends DatabaseEntry {
    protected Destination _destination;
    protected PublicKey _encryptionKey;
    protected SigningPublicKey _signingKey;
    protected final List<Lease> _leases = new ArrayList<Lease>(2);
    private long _firstExpiration = Long.MAX_VALUE;
    protected long _lastExpiration;
    private List<Lease> _decryptedLeases;
    private boolean _decrypted;
    protected boolean _checked;
    protected volatile byte[] _byteified;
    public static final int MAX_LEASES = 16;
    private static final int OLD_MAX_LEASES = 6;
    private static final int DATA_LEN = 36;
    private static final int IV_LEN = 16;

    @Override
    public long getDate() {
        return this.getEarliestLeaseDate();
    }

    @Override
    public KeysAndCert getKeysAndCert() {
        return this._destination;
    }

    @Override
    public int getType() {
        return 1;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination dest) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._destination = dest;
    }

    public PublicKey getEncryptionKey() {
        return this._encryptionKey;
    }

    public PublicKey getEncryptionKey(Set<EncType> supported) {
        if (supported.contains((Object)EncType.ELGAMAL_2048)) {
            return this._encryptionKey;
        }
        return null;
    }

    public void setEncryptionKey(PublicKey encryptionKey) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._encryptionKey = encryptionKey;
    }

    public SigningPublicKey getSigningKey() {
        return this._signingKey;
    }

    public void setSigningKey(SigningPublicKey key) {
        if (key != null && this._destination != null && key.getType() != this._destination.getSigningPublicKey().getType()) {
            throw new IllegalArgumentException("Signing key type mismatch");
        }
        this._signingKey = key;
    }

    @Override
    public void setReceivedBy(Hash localClient) {
        super.setReceivedBy(localClient);
        super.setReceivedAsReply();
    }

    public void addLease(Lease lease) {
        if (lease == null) {
            throw new IllegalArgumentException("erm, null lease");
        }
        if (lease.getGateway() == null) {
            throw new IllegalArgumentException("erm, lease has no gateway");
        }
        if (this.getType() != 7 && lease.getTunnelId() == null) {
            throw new IllegalArgumentException("erm, lease has no tunnel");
        }
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        if (this._leases.size() >= 16) {
            throw new IllegalArgumentException("Too many leases - max is 16");
        }
        this._leases.add(lease);
        long expire = lease.getEndTime();
        if (expire < this._firstExpiration) {
            this._firstExpiration = expire;
        }
        if (expire > this._lastExpiration) {
            this._lastExpiration = expire;
        }
    }

    public int getLeaseCount() {
        if (this.isEncrypted()) {
            return this._leases.size() - 1;
        }
        return this._leases.size();
    }

    public Lease getLease(int index) {
        if (this.isEncrypted()) {
            return this._decryptedLeases.get(index);
        }
        return this._leases.get(index);
    }

    public long getEarliestLeaseDate() {
        if (this._leases.isEmpty()) {
            return -1L;
        }
        return this._firstExpiration;
    }

    public long getLatestLeaseDate() {
        return this._lastExpiration;
    }

    @Override
    public boolean verifySignature() {
        return super.verifySignature();
    }

    @Deprecated
    public boolean verifySignature(SigningPublicKey signingKey) {
        return super.verifySignature();
    }

    public boolean isCurrent(long fudge) {
        long now = Clock.getInstance().now();
        return this._lastExpiration > now - fudge;
    }

    @Override
    protected byte[] getBytes() {
        if (this._byteified != null) {
            return this._byteified;
        }
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null) {
            return null;
        }
        int len = this.size();
        ByteArrayStream out = new ByteArrayStream(len);
        try {
            this._destination.writeBytes(out);
            this._encryptionKey.writeBytes(out);
            this._signingKey.writeBytes(out);
            out.write((byte)this._leases.size());
            for (Lease lease : this._leases) {
                lease.writeBytes(out);
            }
        }
        catch (IOException ioe) {
            return null;
        }
        catch (DataFormatException dfe) {
            return null;
        }
        byte[] rv = out.toByteArray();
        if (this.getReceivedAsPublished()) {
            this._byteified = rv;
        }
        return rv;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._destination != null) {
            throw new IllegalStateException();
        }
        this._destination = Destination.create(in);
        this._encryptionKey = PublicKey.create(in);
        SigType type = this._destination.getSigningPublicKey().getType();
        if (type == null) {
            throw new DataFormatException("unknown sig type");
        }
        this._signingKey = new SigningPublicKey(type);
        this._signingKey.readBytes(in);
        int numLeases = in.read();
        if (numLeases > 16) {
            throw new DataFormatException("Too many leases - max is 16");
        }
        for (int i = 0; i < numLeases; ++i) {
            Lease lease = new Lease();
            lease.readBytes(in);
            this.addLease(lease);
        }
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._encryptionKey == null || this._signingKey == null || this._signature == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this._destination.writeBytes(out);
        this._encryptionKey.writeBytes(out);
        this._signingKey.writeBytes(out);
        out.write((byte)this._leases.size());
        for (Lease lease : this._leases) {
            lease.writeBytes(out);
        }
        this._signature.writeBytes(out);
    }

    public int size() {
        return this._destination.size() + PublicKey.KEYSIZE_BYTES + this._signingKey.length() + 1 + this._leases.size() * 44;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeaseSet)) {
            return false;
        }
        LeaseSet ls = (LeaseSet)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this.getEncryptionKey(), ls.getEncryptionKey()) && DataHelper.eq(this._signingKey, ls.getSigningKey()) && DataHelper.eq(this._destination, ls.getDestination());
    }

    public int hashCode() {
        if (this._destination == null) {
            return 0;
        }
        return this._destination.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("[LeaseSet: ");
        if (this._destination != null) {
            buf.append("\n\tDestination: ").append(this._destination);
            buf.append("\n\tB32: ").append(this._destination.toBase32());
        }
        if (this._encryptionKey != null) {
            buf.append("\n\tEncryptionKey: ").append(this._encryptionKey);
        }
        if (this._signingKey != null) {
            buf.append("\n\tSigningKey: ").append(this._signingKey);
        }
        if (this._signature != null) {
            buf.append("\n\tSignature: ").append(this._signature);
        }
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (int i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\t").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public void encrypt(SessionKey key) {
        try {
            this.encryp(key);
        }
        catch (DataFormatException dfe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(LeaseSet.class);
            log.error("Error encrypting lease: " + this._destination.calculateHash(), dfe);
        }
        catch (IOException ioe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(LeaseSet.class);
            log.error("Error encrypting lease: " + this._destination.calculateHash(), ioe);
        }
    }

    private void encryp(SessionKey key) throws DataFormatException, IOException {
        int size = this._leases.size();
        if (size < 1 || size > 15) {
            throw new IllegalArgumentException("Bad number of leases for encryption");
        }
        int datalen = (36 * size / 16 + 1) * 16;
        ByteArrayStream baos = new ByteArrayStream(datalen);
        for (int i = 0; i < size; ++i) {
            this._leases.get(i).getGateway().writeBytes(baos);
            this._leases.get(i).getTunnelId().writeBytes(baos);
        }
        int padlen = datalen - 36 * size;
        byte[] pad = new byte[padlen];
        RandomSource.getInstance().nextBytes(pad);
        baos.write(pad);
        byte[] iv = new byte[16];
        System.arraycopy(this._destination.getPublicKey().getData(), 0, iv, 0, 16);
        byte[] enc = new byte[36 * (size + 1)];
        I2PAppContext.getGlobalContext().aes().encrypt(baos.toByteArray(), 0, enc, 0, key, iv, datalen);
        padlen = enc.length - datalen;
        RandomSource.getInstance().nextBytes(enc, datalen, padlen);
        Lease padLease = new Lease();
        padLease.setEndDate(this._leases.get(0).getEndTime());
        this._leases.add(padLease);
        ByteArrayInputStream bais = new ByteArrayInputStream(enc);
        for (int i = 0; i < size + 1; ++i) {
            Hash h = new Hash();
            h.readBytes(bais);
            this._leases.get(i).setGateway(h);
            TunnelId t = new TunnelId();
            t.readBytes(bais);
            this._leases.get(i).setTunnelId(t);
        }
    }

    private void decrypt(SessionKey key) throws DataFormatException, IOException {
        int size = this._leases.size();
        if (size < 2) {
            throw new DataFormatException("Bad number of leases decrypting " + this._destination.toBase32() + " - is this destination encrypted?");
        }
        int datalen = 36 * size;
        ByteArrayStream baos = new ByteArrayStream(datalen);
        for (int i = 0; i < size; ++i) {
            this._leases.get(i).getGateway().writeBytes(baos);
            this._leases.get(i).getTunnelId().writeBytes(baos);
        }
        byte[] iv = new byte[16];
        System.arraycopy(this._destination.getPublicKey().getData(), 0, iv, 0, 16);
        int enclen = (36 * (size - 1) / 16 + 1) * 16;
        byte[] enc = new byte[enclen];
        System.arraycopy(baos.toByteArray(), 0, enc, 0, enclen);
        byte[] dec = new byte[enclen];
        I2PAppContext.getGlobalContext().aes().decrypt(enc, 0, dec, 0, key, iv, enclen);
        ByteArrayInputStream bais = new ByteArrayInputStream(dec);
        this._decryptedLeases = new ArrayList<Lease>(size - 1);
        for (int i = 0; i < size - 1; ++i) {
            Lease l = new Lease();
            Hash h = new Hash();
            h.readBytes(bais);
            l.setGateway(h);
            TunnelId t = new TunnelId();
            t.readBytes(bais);
            l.setTunnelId(t);
            l.setEndDate(this._leases.get(i).getEndTime());
            this._decryptedLeases.add(l);
        }
    }

    private synchronized boolean isEncrypted() {
        if (this._decrypted) {
            return true;
        }
        if (this._checked || this._encryptionKey == null || this._destination == null) {
            return false;
        }
        SessionKey key = (SessionKey)I2PAppContext.getGlobalContext().keyRing().get(this._destination.calculateHash());
        if (key != null) {
            try {
                this.decrypt(key);
                this._decrypted = true;
            }
            catch (DataFormatException dfe) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(LeaseSet.class);
                log.error("Error decrypting " + this._destination.toBase32() + " - is this destination encrypted?", dfe);
            }
            catch (IOException ioe) {
                Log log = I2PAppContext.getGlobalContext().logManager().getLog(LeaseSet.class);
                log.error("Error decrypting " + this._destination.toBase32() + " - is this destination encrypted?", ioe);
            }
        }
        this._checked = true;
        return this._decrypted;
    }
}

