/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.ui.components.JBPanel;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.VcsLogUiHolder;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/log/ui/VcsLogPanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/vcs/log/ui/VcsLogUiHolder;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "manager", "Lcom/intellij/vcs/log/impl/VcsLogManager;", "vcsLogUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "(Lcom/intellij/vcs/log/impl/VcsLogManager;Lcom/intellij/vcs/log/ui/VcsLogUiEx;)V", "getVcsLogUi", "()Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "getData", "", "dataId", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogPanel.kt\ncom/intellij/vcs/log/ui/VcsLogPanel\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n37#2,2:76\n37#2,2:82\n37#2,2:88\n1549#3:78\n1620#3,3:79\n1549#3:84\n1620#3,3:85\n*S KotlinDebug\n*F\n+ 1 VcsLogPanel.kt\ncom/intellij/vcs/log/ui/VcsLogPanel\n*L\n61#1:76,2\n66#1:82,2\n71#1:88,2\n66#1:78\n66#1:79,3\n71#1:84\n71#1:85,3\n*E\n"})
public final class VcsLogPanel
extends JBPanel<VcsLogPanel>
implements VcsLogUiHolder,
DataProvider {
    @NotNull
    private final VcsLogManager manager;
    @NotNull
    private final VcsLogUiEx vcsLogUi;

    public VcsLogPanel(@NotNull VcsLogManager manager, @NotNull VcsLogUiEx vcsLogUi) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)vcsLogUi, (String)"vcsLogUi");
        super((LayoutManager)new BorderLayout());
        this.manager = manager;
        this.vcsLogUi = vcsLogUi;
        this.add(this.getVcsLogUi().getMainComponent(), "Center");
    }

    @Override
    @NotNull
    public VcsLogUiEx getVcsLogUi() {
        return this.vcsLogUi;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (VcsLogInternalDataKeys.LOG_MANAGER.is(dataId)) {
            return this.manager;
        }
        if (VcsLogDataKeys.VCS_LOG.is(dataId)) {
            return this.getVcsLogUi().getVcsLog();
        }
        if (VcsLogDataKeys.VCS_LOG_UI.is(dataId)) {
            return this.getVcsLogUi();
        }
        if (VcsLogDataKeys.VCS_LOG_DATA_PROVIDER.is(dataId) || VcsLogInternalDataKeys.LOG_DATA.is(dataId)) {
            return this.manager.getDataManager();
        }
        if (VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION.is(dataId)) {
            return this.getVcsLogUi().getTable().getSelection();
        }
        if (VcsDataKeys.VCS_REVISION_NUMBER.is(dataId)) {
            List hashes2 = this.getVcsLogUi().getTable().getSelection().getCommits();
            if (hashes2.isEmpty()) {
                return null;
            }
            return VcsLogUtil.convertToRevisionNumber(((CommitId)CollectionsKt.first((List)hashes2)).getHash());
        }
        if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            List hashes3 = this.getVcsLogUi().getTable().getSelection().getCommits();
            if (hashes3.size() > 1000) {
                return null;
            }
            Collection $this$toTypedArray$iv = hashes3;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new CommitId[0]);
        }
        if (VcsDataKeys.VCS_REVISION_NUMBERS.is(dataId)) {
            void $this$mapTo$iv$iv;
            List hashes4 = this.getVcsLogUi().getTable().getSelection().getCommits();
            if (hashes4.size() > 1000) {
                return null;
            }
            Iterable $this$map$iv = hashes4;
            boolean $i$f$map = false;
            Iterable thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CommitId commitId2 = (CommitId)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(VcsLogUtil.convertToRevisionNumber(it.getHash()));
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new VcsRevisionNumber[0]);
        }
        if (VcsDataKeys.VCS_COMMIT_SUBJECTS.is(dataId)) {
            void $this$mapTo$iv$iv;
            List metadata = this.getVcsLogUi().getTable().getSelection().getCachedMetadata();
            if (metadata.size() > 1000) {
                return null;
            }
            Iterable $this$map$iv = metadata;
            boolean $i$f$map = false;
            Iterable thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                VcsCommitMetadata it = (VcsCommitMetadata)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSubject());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }
        return null;
    }
}

