/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.completion.spec.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.completion.ShellRuntimeContextProvider;
import com.intellij.terminal.completion.spec.ShellRuntimeContext;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.completion.TerminalCompletionUtil;
import org.jetbrains.plugins.terminal.block.completion.spec.ShellRuntimeContextExtensionsKt;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellCachingGeneratorCommandsRunner;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellGeneratorCommandsRunner;
import org.jetbrains.plugins.terminal.block.completion.spec.impl.ShellRuntimeContextImpl;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellRuntimeContextProviderImpl;", "Lcom/intellij/terminal/completion/ShellRuntimeContextProvider;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;)V", "curDirectory", "", "generatorCommandsRunner", "Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellGeneratorCommandsRunner;", "getContext", "Lcom/intellij/terminal/completion/spec/ShellRuntimeContext;", "typedPrefix", "Companion", "intellij.terminal"})
public final class ShellRuntimeContextProviderImpl
implements ShellRuntimeContextProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final ShellGeneratorCommandsRunner generatorCommandsRunner;
    @NotNull
    private volatile String curDirectory;
    @NotNull
    private static final Key<ShellRuntimeContextProviderImpl> KEY;

    public ShellRuntimeContextProviderImpl(@NotNull Project project, @NotNull BlockTerminalSession session2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.project = project;
        this.session = session2;
        this.generatorCommandsRunner = new ShellCachingGeneratorCommandsRunner(this.session);
        this.curDirectory = "";
        BlockTerminalSession.addCommandListener$default(this.session, new ShellCommandListener(){

            @Override
            public void promptStateUpdated(@NotNull TerminalPromptState newState) {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                String string = PathUtil.toSystemIndependentName((String)newState.getCurrentDirectory());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
                curDirectory = string;
            }
        }, null, 2, null);
    }

    @Override
    @NotNull
    public ShellRuntimeContext getContext(@NotNull String typedPrefix) {
        ShellRuntimeContextImpl shellRuntimeContextImpl;
        Intrinsics.checkNotNullParameter((Object)typedPrefix, (String)"typedPrefix");
        ShellRuntimeContextImpl $this$getContext_u24lambda_u240 = shellRuntimeContextImpl = new ShellRuntimeContextImpl(this.curDirectory, typedPrefix, TerminalCompletionUtil.INSTANCE.toShellName-b9zvSdw(this.session.getShellIntegration().getShellType()), this.generatorCommandsRunner, null);
        boolean bl = false;
        $this$getContext_u24lambda_u240.putUserData(ShellRuntimeContextExtensionsKt.getPROJECT_KEY(), this.project);
        return shellRuntimeContextImpl;
    }

    static {
        Key key = Key.create((String)"IJShellRuntimeContextProvider");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellRuntimeContextProviderImpl$Companion;", "", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/plugins/terminal/block/completion/spec/impl/ShellRuntimeContextProviderImpl;", "getKEY", "()Lcom/intellij/openapi/util/Key;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<ShellRuntimeContextProviderImpl> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

