/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ConfigurationErrorEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.ReportLocationEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXPPXmlView;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public final class GradleTestsExecutionConsoleOutputProcessor {
    private static final Logger LOG = Logger.getInstance(GradleTestsExecutionConsoleOutputProcessor.class);
    private static final String LOG_EOL = "<ijLogEol/>";
    private static final String LOG_START = "<ijLog>";
    private static final String LOG_END = "</ijLog>";

    public static void onOutput(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull String text, @NotNull Key<?> processOutputType) {
        String eventMessage;
        if (executionConsole == null) {
            GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(0);
        }
        if (text == null) {
            GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(1);
        }
        if (processOutputType == null) {
            GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(2);
        }
        if ((eventMessage = GradleTestsExecutionConsoleOutputProcessor.getEventMessage(executionConsole, text, processOutputType)) == null) {
            return;
        }
        try {
            TestEventXPPXmlView xml = new TestEventXPPXmlView(eventMessage);
            TestEventType eventType = TestEventType.fromValue(xml.getTestEventType());
            TestEventProcessor testEventProcessor = GradleTestsExecutionConsoleOutputProcessor.createTestEventProcessor(eventType, executionConsole);
            if (testEventProcessor != null) {
                testEventProcessor.process(xml);
            }
        }
        catch (NumberFormatException | TestEventXmlView.XmlParserException e) {
            LOG.error("Gradle test events parser error", (Throwable)e);
        }
    }

    @Nullable
    private static TestEventProcessor createTestEventProcessor(@NotNull TestEventType eventType, @NotNull GradleTestsExecutionConsole executionConsole) {
        if (eventType == null) {
            GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(3);
        }
        if (executionConsole == null) {
            GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(4);
        }
        return switch (eventType) {
            case TestEventType.CONFIGURATION_ERROR -> new ConfigurationErrorEventProcessor(executionConsole);
            case TestEventType.REPORT_LOCATION -> new ReportLocationEventProcessor(executionConsole);
            case TestEventType.BEFORE_TEST -> new BeforeTestEventProcessor(executionConsole);
            case TestEventType.ON_OUTPUT -> new OnOutputEventProcessor(executionConsole);
            case TestEventType.AFTER_TEST -> new AfterTestEventProcessor(executionConsole);
            case TestEventType.BEFORE_SUITE -> new BeforeSuiteEventProcessor(executionConsole);
            case TestEventType.AFTER_SUITE -> new AfterSuiteEventProcessor(executionConsole);
            default -> null;
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static String getEventMessage(@NotNull GradleTestsExecutionConsole executionConsole, @NotNull String text, @NotNull Key<?> processOutputType) {
        StringBuilder consoleBuffer;
        String eventMessage;
        block11: {
            if (executionConsole == null) {
                GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(5);
            }
            if (text == null) {
                GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(6);
            }
            if (processOutputType == null) {
                GradleTestsExecutionConsoleOutputProcessor.$$$reportNull$$$0(7);
            }
            eventMessage = null;
            consoleBuffer = executionConsole.getBuffer();
            String trimmedText = text.trim();
            if (StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_EOL)) {
                consoleBuffer.append(StringUtil.trimEnd((String)trimmedText, (String)LOG_EOL));
                return null;
            }
            if (consoleBuffer.isEmpty()) {
                if (StringUtil.startsWith((CharSequence)trimmedText, (CharSequence)LOG_START) && StringUtil.endsWith((CharSequence)trimmedText, (CharSequence)LOG_END)) {
                    eventMessage = text;
                    break block11;
                } else {
                    executionConsole.print(text, ConsoleViewContentType.getConsoleViewType(processOutputType));
                    return null;
                }
            }
            consoleBuffer.append(text);
            if (trimmedText.isEmpty()) {
                return null;
            }
        }
        if (eventMessage == null) {
            String bufferText = consoleBuffer.toString().trim();
            consoleBuffer.setLength(0);
            if (!StringUtil.startsWith((CharSequence)bufferText, (CharSequence)LOG_START) || !StringUtil.endsWith((CharSequence)bufferText, (CharSequence)LOG_END)) {
                executionConsole.print(bufferText, ConsoleViewContentType.getConsoleViewType(processOutputType));
                return null;
            }
            eventMessage = bufferText;
        }
        assert (consoleBuffer.isEmpty());
        return eventMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionConsole";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processOutputType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/GradleTestsExecutionConsoleOutputProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onOutput";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createTestEventProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getEventMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

