/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemMessageEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEventProcessor;
import org.jetbrains.plugins.gradle.execution.test.runner.events.GradleXmlTestEventConverter;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;

public class OnOutputEventProcessor
extends AbstractTestEventProcessor {
    public OnOutputEventProcessor(GradleTestsExecutionConsole executionConsole) {
        super(executionConsole);
    }

    @Override
    public void process(@NotNull TestEventXmlView eventXml) throws TestEventXmlView.XmlParserException {
        if (eventXml == null) {
            OnOutputEventProcessor.$$$reportNull$$$0(0);
        }
        String testId = eventXml.getTestId();
        String output = GradleXmlTestEventConverter.decode(eventXml.getTestEventTest());
        boolean isStdOut = "StdOut".equals(eventXml.getTestEventTestDescription());
        this.doProcess(testId, output, isStdOut);
    }

    @Override
    public void process(@NotNull ExternalSystemProgressEvent<? extends TestOperationDescriptor> testEvent) {
        if (testEvent == null) {
            OnOutputEventProcessor.$$$reportNull$$$0(1);
        }
        ExternalSystemMessageEvent messageEvent = (ExternalSystemMessageEvent)testEvent;
        String parentTestId = messageEvent.getParentEventId();
        boolean isStdOut = messageEvent.isStdOut();
        String message = StringUtil.notNullize((String)messageEvent.getMessage());
        this.doProcess(parentTestId, message, isStdOut);
    }

    private void doProcess(@Nullable String parentTestId, @NotNull String message, boolean isStdOut) {
        if (message == null) {
            OnOutputEventProcessor.$$$reportNull$$$0(2);
        }
        SMTestProxy testProxy = this.findParentTestProxy(parentTestId);
        String name = testProxy.getName();
        TestOutputEvent event = new TestOutputEvent(name, message, isStdOut);
        Key destination = isStdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
        testProxy.addOutput(message, destination);
        this.getExecutionConsole().getEventPublisher().onTestOutput(testProxy, event);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventXml";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testEvent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/test/runner/events/OnOutputEventProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

