/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.SingleAbstractMethodLowering;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0010H\u0016R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsSingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/lower/SingleAbstractMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getWrapperVisibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "scopes", "", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "needEqualsHashCodeMethods", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getNeedEqualsHashCodeMethods", "(Lorg/jetbrains/kotlin/ir/types/IrType;)Z", "enclosingBodyContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "currentScopeSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getSuperTypeForWrapper", "typeOperand", "backend.js"})
public final class JsSingleAbstractMethodLowering
extends SingleAbstractMethodLowering
implements BodyLoweringPass {
    @Nullable
    private IrDeclaration enclosingBodyContainer;

    public JsSingleAbstractMethodLowering(@NotNull CommonBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    @NotNull
    public DescriptorVisibility getWrapperVisibility(@NotNull IrTypeOperatorCall expression2, @NotNull List<? extends ScopeWithIr> scopes) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"LOCAL");
        return descriptorVisibility;
    }

    public boolean getNeedEqualsHashCodeMethods(@NotNull IrType $this$needEqualsHashCodeMethods) {
        Intrinsics.checkNotNullParameter((Object)$this$needEqualsHashCodeMethods, (String)"<this>");
        return true;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        super.lower(irFile);
    }

    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter((Object)irBody, (String)"irBody");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.getCachedImplementations().clear();
        this.getInlineCachedImplementations().clear();
        IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)container);
        this.setEnclosingContainer(irClass != null ? (IrDeclarationContainer)irClass : (IrDeclarationContainer)IrUtilsKt.getFile((IrDeclaration)container));
        this.enclosingBodyContainer = container;
        this.transformChildrenVoid((IrElement)irBody);
        for (IrClass wrapper : CollectionsKt.plus(this.getCachedImplementations().values(), (Iterable)this.getInlineCachedImplementations().values())) {
            IrDeclarationParent irDeclarationParent = wrapper.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer");
            IrDeclarationContainer parentClass = (IrDeclarationContainer)irDeclarationParent;
            ((Collection)parentClass.getDeclarations()).add(wrapper);
        }
    }

    @Nullable
    protected IrSymbol currentScopeSymbol() {
        Object object = super.currentScopeSymbol();
        if (object == null) {
            IrDeclaration irDeclaration = this.enclosingBodyContainer;
            IrSymbolOwner irSymbolOwner = irDeclaration instanceof IrSymbolOwner ? (IrSymbolOwner)irDeclaration : null;
            object = irSymbolOwner != null ? irSymbolOwner.getSymbol() : null;
        }
        return object;
    }

    @NotNull
    public IrType getSuperTypeForWrapper(@NotNull IrType typeOperand) {
        Intrinsics.checkNotNullParameter((Object)typeOperand, (String)"typeOperand");
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)typeOperand);
        if (irClassSymbol == null || (irClassSymbol = IrTypesKt.getDefaultType((IrClassifierSymbol)((IrClassifierSymbol)irClassSymbol))) == null) {
            CompilationExceptionKt.compilationException((String)"Unsupported SAM conversion", (IrType)typeOperand);
            throw null;
        }
        return irClassSymbol;
    }
}

