/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "keep", "", "", "<init>", "(Ljava/util/Set;)V", "keptDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "shouldKeep", "", "declaration", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "data", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "isInKeep", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "KeepData", "backend.js"})
@SourceDebugExtension(value={"SMAP\nKeeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1755#2,3:69\n*S KotlinDebug\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n*L\n18#1:69,3\n*E\n"})
public final class Keeper
implements IrElementVisitor<Unit, KeepData> {
    @NotNull
    private final Set<String> keep;
    @NotNull
    private final Set<IrDeclaration> keptDeclarations;

    public Keeper(@NotNull Set<String> keep) {
        Intrinsics.checkNotNullParameter(keep, (String)"keep");
        this.keep = keep;
        this.keptDeclarations = new LinkedHashSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldKeep(@NotNull IrDeclaration declaration) {
        IrSymbolOwner irSymbolOwner;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.keptDeclarations.contains(declaration)) return true;
        if (!(declaration instanceof IrOverridableDeclaration)) return false;
        Iterable $this$any$iv = ((IrOverridableDeclaration)declaration).getOverriddenSymbols();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            irSymbolOwner = it.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        } while (!this.shouldKeep((IrDeclaration)irSymbolOwner));
        return true;
    }

    public void visitElement(@NotNull IrElement element, @NotNull KeepData data) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        element.acceptChildren((IrElementVisitor)this, (Object)data);
    }

    public void visitClass(@NotNull IrClass declaration, @NotNull KeepData data) {
        boolean keptClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean prevShouldBeKept = data.getClassShouldBeKept();
        boolean prevClassInKeep = data.getClassInKeep();
        data.setClassShouldBeKept(false);
        boolean bl = keptClass = data.getClassInKeep() || this.isInKeep((IrDeclarationWithName)declaration);
        if (keptClass) {
            this.keptDeclarations.add((IrDeclaration)declaration);
        }
        data.setClassInKeep(keptClass);
        IrElementVisitor.DefaultImpls.visitClass((IrElementVisitor)this, (IrClass)declaration, (Object)data);
        if (data.getClassShouldBeKept()) {
            this.keptDeclarations.add((IrDeclaration)declaration);
        }
        data.setClassShouldBeKept(prevShouldBeKept);
        data.setClassInKeep(prevClassInKeep);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull KeepData data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        IrElementVisitor.DefaultImpls.visitDeclaration((IrElementVisitor)this, (IrDeclarationBase)declaration, (Object)data);
        if (this.keptDeclarations.contains(declaration)) {
            return;
        }
        if (declaration instanceof IrDeclarationWithName && this.isInKeep((IrDeclarationWithName)declaration) || data.getClassInKeep()) {
            this.keptDeclarations.add((IrDeclaration)declaration);
            data.setClassShouldBeKept(true);
            return;
        }
    }

    private final boolean isInKeep(IrDeclarationWithName declaration) {
        FqName fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)declaration);
        return CollectionsKt.contains((Iterable)this.keep, (Object)(fqName != null ? fqName.asString() : null));
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitValueParameter((IrElementVisitor)this, (IrValueParameter)declaration, (Object)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitAnonymousInitializer((IrElementVisitor)this, (IrAnonymousInitializer)declaration, (Object)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitTypeParameter((IrElementVisitor)this, (IrTypeParameter)declaration, (Object)data);
    }

    public void visitFunction(@NotNull IrFunction declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFunction((IrElementVisitor)this, (IrFunction)declaration, (Object)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstructor((IrElementVisitor)this, (IrConstructor)declaration, (Object)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitEnumEntry((IrElementVisitor)this, (IrEnumEntry)declaration, (Object)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitErrorDeclaration((IrElementVisitor)this, (IrErrorDeclaration)declaration, (Object)data);
    }

    public void visitField(@NotNull IrField declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitField((IrElementVisitor)this, (IrField)declaration, (Object)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitor)this, (IrLocalDelegatedProperty)declaration, (Object)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitModuleFragment((IrElementVisitor)this, (IrModuleFragment)declaration, (Object)data);
    }

    public void visitProperty(@NotNull IrProperty declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitProperty((IrElementVisitor)this, (IrProperty)declaration, (Object)data);
    }

    public void visitScript(@NotNull IrScript declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitScript((IrElementVisitor)this, (IrScript)declaration, (Object)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSimpleFunction((IrElementVisitor)this, (IrSimpleFunction)declaration, (Object)data);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitTypeAlias((IrElementVisitor)this, (IrTypeAlias)declaration, (Object)data);
    }

    public void visitVariable(@NotNull IrVariable declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitVariable((IrElementVisitor)this, (IrVariable)declaration, (Object)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitPackageFragment((IrElementVisitor)this, (IrPackageFragment)declaration, (Object)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitExternalPackageFragment((IrElementVisitor)this, (IrExternalPackageFragment)declaration, (Object)data);
    }

    public void visitFile(@NotNull IrFile declaration, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFile((IrElementVisitor)this, (IrFile)declaration, (Object)data);
    }

    public void visitExpression(@NotNull IrExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitExpression((IrElementVisitor)this, (IrExpression)expression2, (Object)data);
    }

    public void visitBody(@NotNull IrBody body, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBody((IrElementVisitor)this, (IrBody)body, (Object)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitExpressionBody((IrElementVisitor)this, (IrExpressionBody)body, (Object)data);
    }

    public void visitBlockBody(@NotNull IrBlockBody body, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBlockBody((IrElementVisitor)this, (IrBlockBody)body, (Object)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDeclarationReference((IrElementVisitor)this, (IrDeclarationReference)expression2, (Object)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitMemberAccess((IrElementVisitor)this, expression2, (Object)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFunctionAccess((IrElementVisitor)this, (IrFunctionAccessExpression)expression2, (Object)data);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstructorCall((IrElementVisitor)this, (IrConstructorCall)expression2, (Object)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSingletonReference((IrElementVisitor)this, (IrGetSingletonValue)expression2, (Object)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitGetObjectValue((IrElementVisitor)this, (IrGetObjectValue)expression2, (Object)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitGetEnumValue((IrElementVisitor)this, (IrGetEnumValue)expression2, (Object)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitRawFunctionReference((IrElementVisitor)this, (IrRawFunctionReference)expression2, (Object)data);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitContainerExpression((IrElementVisitor)this, (IrContainerExpression)expression2, (Object)data);
    }

    public void visitBlock(@NotNull IrBlock expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBlock((IrElementVisitor)this, (IrBlock)expression2, (Object)data);
    }

    public void visitComposite(@NotNull IrComposite expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitComposite((IrElementVisitor)this, (IrComposite)expression2, (Object)data);
    }

    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitReturnableBlock((IrElementVisitor)this, (IrReturnableBlock)expression2, (Object)data);
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitor)this, (IrInlinedFunctionBlock)inlinedBlock, (Object)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSyntheticBody((IrElementVisitor)this, (IrSyntheticBody)body, (Object)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBreakContinue((IrElementVisitor)this, (IrBreakContinue)jump, (Object)data);
    }

    public void visitBreak(@NotNull IrBreak jump, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBreak((IrElementVisitor)this, (IrBreak)jump, (Object)data);
    }

    public void visitContinue(@NotNull IrContinue jump, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitContinue((IrElementVisitor)this, (IrContinue)jump, (Object)data);
    }

    public void visitCall(@NotNull IrCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitCall((IrElementVisitor)this, (IrCall)expression2, (Object)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitCallableReference((IrElementVisitor)this, expression2, (Object)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFunctionReference((IrElementVisitor)this, (IrFunctionReference)expression2, (Object)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitPropertyReference((IrElementVisitor)this, (IrPropertyReference)expression2, (Object)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitor)this, (IrLocalDelegatedPropertyReference)expression2, (Object)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitClassReference((IrElementVisitor)this, (IrClassReference)expression2, (Object)data);
    }

    public void visitConst(@NotNull IrConst<?> expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConst((IrElementVisitor)this, expression2, (Object)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstantValue((IrElementVisitor)this, (IrConstantValue)expression2, (Object)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstantPrimitive((IrElementVisitor)this, (IrConstantPrimitive)expression2, (Object)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstantObject((IrElementVisitor)this, (IrConstantObject)expression2, (Object)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitConstantArray((IrElementVisitor)this, (IrConstantArray)expression2, (Object)data);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitor)this, (IrDelegatingConstructorCall)expression2, (Object)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDynamicExpression((IrElementVisitor)this, (IrDynamicExpression)expression2, (Object)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitor)this, (IrDynamicOperatorExpression)expression2, (Object)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDynamicMemberExpression((IrElementVisitor)this, (IrDynamicMemberExpression)expression2, (Object)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitEnumConstructorCall((IrElementVisitor)this, (IrEnumConstructorCall)expression2, (Object)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitErrorExpression((IrElementVisitor)this, (IrErrorExpression)expression2, (Object)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitErrorCallExpression((IrElementVisitor)this, (IrErrorCallExpression)expression2, (Object)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFieldAccess((IrElementVisitor)this, (IrFieldAccessExpression)expression2, (Object)data);
    }

    public void visitGetField(@NotNull IrGetField expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitGetField((IrElementVisitor)this, (IrGetField)expression2, (Object)data);
    }

    public void visitSetField(@NotNull IrSetField expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSetField((IrElementVisitor)this, (IrSetField)expression2, (Object)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitFunctionExpression((IrElementVisitor)this, (IrFunctionExpression)expression2, (Object)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitGetClass((IrElementVisitor)this, (IrGetClass)expression2, (Object)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitInstanceInitializerCall((IrElementVisitor)this, (IrInstanceInitializerCall)expression2, (Object)data);
    }

    public void visitLoop(@NotNull IrLoop loop, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitLoop((IrElementVisitor)this, (IrLoop)loop, (Object)data);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitWhileLoop((IrElementVisitor)this, (IrWhileLoop)loop, (Object)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitDoWhileLoop((IrElementVisitor)this, (IrDoWhileLoop)loop, (Object)data);
    }

    public void visitReturn(@NotNull IrReturn expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitReturn((IrElementVisitor)this, (IrReturn)expression2, (Object)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitStringConcatenation((IrElementVisitor)this, (IrStringConcatenation)expression2, (Object)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSuspensionPoint((IrElementVisitor)this, (IrSuspensionPoint)expression2, (Object)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSuspendableExpression((IrElementVisitor)this, (IrSuspendableExpression)expression2, (Object)data);
    }

    public void visitThrow(@NotNull IrThrow expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitThrow((IrElementVisitor)this, (IrThrow)expression2, (Object)data);
    }

    public void visitTry(@NotNull IrTry aTry, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitTry((IrElementVisitor)this, (IrTry)aTry, (Object)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitCatch((IrElementVisitor)this, (IrCatch)aCatch, (Object)data);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitTypeOperator((IrElementVisitor)this, (IrTypeOperatorCall)expression2, (Object)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitValueAccess((IrElementVisitor)this, (IrValueAccessExpression)expression2, (Object)data);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitGetValue((IrElementVisitor)this, (IrGetValue)expression2, (Object)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSetValue((IrElementVisitor)this, (IrSetValue)expression2, (Object)data);
    }

    public void visitVararg(@NotNull IrVararg expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitVararg((IrElementVisitor)this, (IrVararg)expression2, (Object)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitSpreadElement((IrElementVisitor)this, (IrSpreadElement)spread, (Object)data);
    }

    public void visitWhen(@NotNull IrWhen expression2, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitWhen((IrElementVisitor)this, (IrWhen)expression2, (Object)data);
    }

    public void visitBranch(@NotNull IrBranch branch, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitBranch((IrElementVisitor)this, (IrBranch)branch, (Object)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull KeepData data) {
        IrElementVisitor.DefaultImpls.visitElseBranch((IrElementVisitor)this, (IrElseBranch)branch, (Object)data);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "", "classInKeep", "", "classShouldBeKept", "<init>", "(ZZ)V", "getClassInKeep", "()Z", "setClassInKeep", "(Z)V", "getClassShouldBeKept", "setClassShouldBeKept", "backend.js"})
    public static final class KeepData {
        private boolean classInKeep;
        private boolean classShouldBeKept;

        public KeepData(boolean classInKeep, boolean classShouldBeKept) {
            this.classInKeep = classInKeep;
            this.classShouldBeKept = classShouldBeKept;
        }

        public final boolean getClassInKeep() {
            return this.classInKeep;
        }

        public final void setClassInKeep(boolean bl) {
            this.classInKeep = bl;
        }

        public final boolean getClassShouldBeKept() {
            return this.classShouldBeKept;
        }

        public final void setClassShouldBeKept(boolean bl) {
            this.classShouldBeKept = bl;
        }
    }
}

