/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dev.psiViewer.stubs;

import com.intellij.dev.psiViewer.DevPsiViewerBundle;
import com.intellij.dev.psiViewer.stubs.StubViewerPsiBasedTree;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import java.awt.Component;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StubDetailsViewer {
    private static final boolean DEFAULT_SHOW_STUB_DETAILS = false;
    private static final String PROPERTY_NAME = "StubDetailsViewer.showPreviewDetails";
    @NotNull
    private final StubViewerPsiBasedTree myStubViewerTree;
    @NotNull
    private final Tree myStubDetailsTree;

    public StubDetailsViewer(@NotNull StubViewerPsiBasedTree tree) {
        if (tree == null) {
            StubDetailsViewer.$$$reportNull$$$0(0);
        }
        this.myStubViewerTree = tree;
        this.myStubDetailsTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myStubDetailsTree.setRootVisible(false);
    }

    public AnAction addComponent(final JBSplitter splitter) {
        this.updateStubDetailsTreeView(PropertiesComponent.getInstance().getBoolean(PROPERTY_NAME, false), splitter);
        return new ToggleAction(DevPsiViewerBundle.message("action.show.stub.details.text", new Object[0]), null, AllIcons.Actions.PreviewDetails){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PropertiesComponent.getInstance().getBoolean(StubDetailsViewer.PROPERTY_NAME, false);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                PropertiesComponent.getInstance().setValue(StubDetailsViewer.PROPERTY_NAME, state, false);
                StubDetailsViewer.this.updateStubDetailsTreeView(state, splitter);
                if (state) {
                    StubDetailsViewer.this.valueChanged(StubDetailsViewer.this.myStubViewerTree.getSelectedStub());
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    private void updateStubDetailsTreeView(boolean isShown, JBSplitter splitter) {
        this.myStubDetailsTree.setEnabled(isShown);
        splitter.setSecondComponent(isShown ? ScrollPaneFactory.createScrollPane((Component)this.myStubDetailsTree, (boolean)true) : null);
    }

    public void valueChanged(@Nullable StubElement<?> stub) {
        if (this.myStubDetailsTree.isEnabled()) {
            Disposable treeModelDisposable = this.myStubViewerTree.myTreeModelDisposable;
            StructureTreeModel model = new StructureTreeModel((AbstractTreeStructure)new StubDetailsTreeStructure(stub), null, Invoker.forEventDispatchThread((Disposable)treeModelDisposable), treeModelDisposable);
            this.myStubDetailsTree.setModel((TreeModel)model);
            this.myStubDetailsTree.expandRow(0);
            this.myStubDetailsTree.treeDidChange();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/dev/psiViewer/stubs/StubDetailsViewer", "<init>"));
    }

    private static class StubDetailsTreeStructure
    extends SimpleTreeStructure {
        private final Object myRoot;

        private StubDetailsTreeStructure(@Nullable StubElement<?> root) {
            this.myRoot = root != null ? new StubDetailsRootNode(root) : new Object();
        }

        @NotNull
        public Object getRootElement() {
            Object object = this.myRoot;
            if (object == null) {
                StubDetailsTreeStructure.$$$reportNull$$$0(0);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$StubDetailsTreeStructure", "getRootElement"));
        }
    }

    private static class StubDetailsRootNode
    extends SimpleNode {
        @NotNull
        private final StubElement<?> myStub;

        private StubDetailsRootNode(@NotNull StubElement<?> stub) {
            if (stub == null) {
                StubDetailsRootNode.$$$reportNull$$$0(0);
            }
            this.myStub = stub;
        }

        public SimpleNode @NotNull [] getChildren() {
            SimpleNode[] simpleNodeArray = (SimpleNode[])ReflectionUtil.collectFields(this.myStub.getClass()).stream().filter(f -> {
                if (Modifier.isStatic(f.getModifiers())) {
                    return false;
                }
                Class<?> aClass = f.getDeclaringClass();
                return !StubBase.class.equals(aClass) && !ObjectStubBase.class.equals(aClass) && !AtomicReference.class.equals(aClass) && (f.canAccess(this.myStub) || f.trySetAccessible());
            }).map(f -> f.getName() + " = " + ReflectionUtil.getFieldValue((Field)f, this.myStub)).sorted().map(s -> new SimpleNode((String)s){
                final /* synthetic */ String val$s;
                {
                    this.val$s = string;
                }

                public SimpleNode @NotNull [] getChildren() {
                    if (NO_CHILDREN == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return NO_CHILDREN;
                }

                public String getName() {
                    return this.val$s;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$StubDetailsRootNode$1", "getChildren"));
                }
            }).toArray(SimpleNode[]::new);
            if (simpleNodeArray == null) {
                StubDetailsRootNode.$$$reportNull$$$0(1);
            }
            return simpleNodeArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stub";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$StubDetailsRootNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dev/psiViewer/stubs/StubDetailsViewer$StubDetailsRootNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

