/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.ProjectDependenciesModel;
import com.intellij.packageChecker.model.ProjectSnapshot;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.packageChecker.service.PackageServiceKt;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 !2\u00020\u0001:\u0001!B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\u0006\u0010\t\u001a\u00020\nJ.\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\bJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\b2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\fJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aJ\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\nH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/service/PackageService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "calculateRoots", "", "Lorg/jetbrains/security/package/Package;", "", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "packages", "declareDependency", "", "psiFile", "pkg", "declaredDependencies", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "dependencyModelsProvider", "Lcom/intellij/packageChecker/model/ProjectDependenciesModel;", "importedDependencies", "isBuildFile", "", "scanAllModules", "", "supportsFixes", "updateDependency", "version", "", "fileProvider", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "Companion", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,138:1\n766#2:139\n857#2,2:140\n1360#2:142\n1446#2,5:143\n1360#2:148\n1446#2,5:149\n1271#2,2:154\n1285#2,2:156\n766#2:158\n857#2,2:159\n1288#2:161\n766#2:178\n857#2,2:179\n526#3:162\n511#3,6:163\n125#4:169\n152#4,3:170\n96#4,5:173\n*S KotlinDebug\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService\n*L\n27#1:139\n27#1:140,2\n31#1:142\n31#1:143,5\n38#1:148\n38#1:149,5\n48#1:154,2\n48#1:156,2\n50#1:158\n50#1:159,2\n48#1:161\n100#1:178\n100#1:179,2\n57#1:162\n57#1:163,6\n59#1:169\n59#1:170,3\n67#1:173,5\n*E\n"})
public final class PackageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public PackageService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final boolean isBuildFile(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return this.fileProvider(psiFile) != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageDeclaration> declaredDependencies(@NotNull PsiFile psiFile) {
        void $this$flatMapTo$iv$iv;
        ProjectDependenciesModel projectDependenciesModel;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Iterable $this$filter$iv = this.dependencyModelsProvider();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (!projectDependenciesModel.supports(psiFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv$iv = projectDependenciesModel.declaredDependencies(psiFile);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PackageDeclaration> declaredDependencies(@NotNull Module module) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Iterable $this$flatMap$iv = this.dependencyModelsProvider();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv$iv = projectDependenciesModel.declaredDependencies(module);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Package> scanAllModules() {
        void destination$iv;
        void $this$flatMapTo$iv;
        Object providersToModules2;
        Object object;
        Object element$iv$iv;
        List modules = ArraysKt.toList((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
        Object[] objectArray = new Object[]{modules.size()};
        PackageServiceKt.access$getLogger$p().debug("Count of found modules: ", objectArray);
        Iterable $this$associateWith$iv = this.dependencyModelsProvider();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Object $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        Iterator iterator = $this$associateWithTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            element$iv$iv = iterator.next();
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable $this$filter$iv = modules;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void provider;
                Module it = (Module)element$iv$iv2;
                boolean bl2 = false;
                ProgressManager.checkCanceled();
                if (!provider.supports(it)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            object.put(t, list);
        }
        Map providerToModulesList = result$iv;
        if (PackageServiceKt.access$getLogger$p().isDebugEnabled()) {
            void $this$mapTo$iv$iv;
            Object[] $this$map$iv;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = providerToModulesList;
            boolean $i$f$filter = false;
            $this$associateWithTo$iv$iv = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            element$iv$iv = $this$filterTo$iv$iv.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                Map.Entry element$iv$iv3;
                Map.Entry it = element$iv$iv3 = (Map.Entry)element$iv$iv.next();
                boolean bl = false;
                boolean bl3 = !((Collection)it.getValue()).isEmpty();
                if (!bl3) continue;
                destination$iv$iv.put(element$iv$iv3.getKey(), element$iv$iv3.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            element$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
            while (element$iv$iv.hasNext()) {
                void providerWithModules;
                Map.Entry item$iv$iv;
                Map.Entry it = item$iv$iv = (Map.Entry)element$iv$iv.next();
                object = destination$iv$iv;
                boolean bl = false;
                object.add(providerWithModules.getKey().getClass().getSimpleName() + ": \n-" + CollectionsKt.joinToString$default((Iterable)((Iterable)providerWithModules.getValue()), (CharSequence)"\n-", null, null, (int)0, null, (Function1)scanAllModules.providersToModules.2.1.INSTANCE, (int)30, null));
            }
            providersToModules2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            $this$map$iv = new Object[]{providersToModules2};
            PackageServiceKt.access$getLogger$p().debug("Modules by related providers: \n", $this$map$iv);
        }
        providersToModules2 = providerToModulesList;
        Collection $this$map$iv = new LinkedHashSet();
        boolean $i$f$flatMapTo = false;
        Iterator iterator2 = $this$flatMapTo$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator2.next();
            boolean bl = false;
            ProgressManager.checkCanceled();
            Iterable list$iv = ((ProjectDependenciesModel)it.getKey()).declaredDependencies(new ProjectSnapshot(this.project, (List)it.getValue()));
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        return (Set)destination$iv;
    }

    @NotNull
    public final Map<Package, List<Package>> calculateRoots(@NotNull PsiFile file2, @NotNull List<Package> packages) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        BuildFileProvider buildFileProvider = this.fileProvider(file2);
        if (buildFileProvider == null) {
            return MapsKt.emptyMap();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.getRoots(file2, packages);
    }

    @NotNull
    public final Map<Package, List<Package>> calculateRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildFileProvider buildFileProvider = this.fileProvider(module);
        if (buildFileProvider == null) {
            return MapsKt.emptyMap();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.getRoots(module);
    }

    @NotNull
    public final List<Package> importedDependencies(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        BuildFileProvider buildFileProvider = this.fileProvider(psiFile);
        if (buildFileProvider == null) {
            throw new IllegalStateException(("Unmanaged file: " + psiFile.getName()).toString());
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.importedPackages(psiFile);
    }

    public final void declareDependency(@NotNull PsiFile psiFile, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        BuildFileProvider buildFileProvider = this.fileProvider(psiFile);
        if (buildFileProvider == null) {
            throw new IllegalStateException(("Unmanaged file: " + psiFile.getName()).toString());
        }
        BuildFileProvider provider = buildFileProvider;
        provider.declarePackage(psiFile, pkg);
    }

    public final void updateDependency(@NotNull PsiFile psiFile, @NotNull Package pkg, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        BuildFileProvider buildFileProvider = this.fileProvider(psiFile);
        if (buildFileProvider == null) {
            throw new IllegalStateException(("Unmanaged file: " + psiFile.getName()).toString());
        }
        BuildFileProvider provider = buildFileProvider;
        provider.updatePackageDeclaration(psiFile, pkg, version);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProjectDependenciesModel> dependencyModelsProvider() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ProjectDependenciesModel.Companion.getEP_NAME().getExtensions((AreaInstance)this.project);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectDependenciesModel projectDependenciesModel = (ProjectDependenciesModel)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (!projectDependenciesModel.supports(this.project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final BuildFileProvider fileProvider(PsiFile $this$fileProvider) {
        Object v1;
        block1: {
            Project project = $this$fileProvider.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Iterable iterable = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            for (Object t : iterable) {
                BuildFileProvider buildFileProvider = (BuildFileProvider)t;
                boolean bl = false;
                ProgressManager.checkCanceled();
                if (!buildFileProvider.supports($this$fileProvider)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final BuildFileProvider fileProvider(Module $this$fileProvider) {
        Object v1;
        block1: {
            Project project = $this$fileProvider.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            Iterable iterable = BuildFileProvider.Companion.getEP_NAME().getExtensions((AreaInstance)project2);
            for (Object t : iterable) {
                BuildFileProvider buildFileProvider = (BuildFileProvider)t;
                boolean bl = false;
                ProgressManager.checkCanceled();
                if (!buildFileProvider.supports($this$fileProvider)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final List<Package> importedDependencies(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildFileProvider buildFileProvider = this.fileProvider(module);
        if (buildFileProvider == null) {
            return CollectionsKt.emptyList();
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.importedPackages(module);
    }

    public final boolean supportsFixes(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildFileProvider buildFileProvider = this.fileProvider(module);
        if (buildFileProvider == null) {
            return false;
        }
        BuildFileProvider provider = buildFileProvider;
        return provider.supportsFixes();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/packageChecker/service/PackageService$Companion;", "", "()V", "getInstance", "Lcom/intellij/packageChecker/service/PackageService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.packageChecker"})
    @SourceDebugExtension(value={"SMAP\nPackageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,138:1\n31#2,2:139\n*S KotlinDebug\n*F\n+ 1 PackageService.kt\ncom/intellij/packageChecker/service/PackageService$Companion\n*L\n134#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PackageService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<PackageService> serviceClass$iv = PackageService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (PackageService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

