/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.find.impl.TextSearchContributor;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchAdapter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.awt.Component;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SearchEverywhereCommand
extends AbstractCommand {
    public static final String PREFIX = "%searchEverywhere";
    private static final Logger LOG = Logger.getInstance(SearchEverywhereCommand.class);
    private final Options myOptions;

    public SearchEverywhereCommand(@NotNull String text2, int line) {
        if (text2 == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(0);
        }
        super(text2, line);
        this.myOptions = new Options();
        this.getArgs();
    }

    private Boolean isWarmupMode() {
        return this.extractCommandArgument("%").contains("WARMUP");
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        String[] args = this.getArgs();
        String tab = this.myOptions.tab;
        String insertText = args.length > 1 ? args[1] : "";
        boolean warmup = this.isWarmupMode();
        Ref tabId = new Ref();
        switch (tab) {
            case "text": {
                tabId.set((Object)TextSearchContributor.class.getSimpleName());
                break;
            }
            case "file": {
                tabId.set((Object)FileSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "class": {
                tabId.set((Object)ClassSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "action": {
                tabId.set((Object)ActionSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "symbol": {
                tabId.set((Object)SymbolSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "all": {
                tabId.set((Object)"SearchEverywhereContributor.All");
                break;
            }
            default: {
                throw new RuntimeException("Tab is not set");
            }
        }
        LOG.info((String)tabId.get());
        int numberOfPermits = insertText.isEmpty() && this.myOptions.typingText.isEmpty() ? 1 : (!insertText.isEmpty() && !this.myOptions.typingText.isEmpty() ? -1 : 0);
        Semaphore typingSemaphore = new Semaphore(numberOfPermits);
        TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.getTracer(warmup), (String)"searchEverywhere", globalSpan -> {
            ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                try {
                    Object component;
                    TypingTarget target = AlphaNumericTypeCommand.findTarget((PlaybackContext)context);
                    if (!(target instanceof EditorComponentImpl)) {
                        LOG.info("Editor is not opened, focus owner will be used.");
                        component = IdeFocusManager.getInstance((Project)project).getFocusOwner();
                    } else {
                        component = (EditorComponentImpl)target;
                    }
                    DataContext dataContext = DataManager.getInstance().getDataContext((Component)component);
                    IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
                    TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.getTracer(warmup), (String)"searchEverywhere_dialog_shown", dialogSpan -> {
                        SearchEverywhereManager manager = SearchEverywhereManager.getInstance((Project)project);
                        manager.show((String)tabId.get(), "", new AnActionEvent(null, dataContext, "EditorPopup", new Presentation(), ActionManager.getInstance(), 0){

                            public Project getProject() {
                                return context.getProject();
                            }
                        });
                        this.attachSearchListeners(manager.getCurrentlyShownUI());
                    });
                    if (!insertText.isEmpty()) {
                        this.insertText(context.getProject(), insertText, typingSemaphore, warmup);
                    }
                    if (!this.myOptions.typingText.isEmpty()) {
                        this.typeText(context.getProject(), this.myOptions.typingText, typingSemaphore, warmup);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }));
            try {
                typingSemaphore.acquire();
                SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
                if (this.myOptions.close.booleanValue()) {
                    ApplicationManager.getApplication().invokeAndWait(() -> ui.closePopup());
                }
                if (this.myOptions.selectFirst.booleanValue()) {
                    WriteAction.runAndWait(() -> ApplicationManager.getApplication().invokeAndWait(() -> ui.selectFirst()));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            finally {
                actionCallback.setDone();
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @NotNull
    protected String[] getArgs() {
        String[] stringArray = this.getArgs(PREFIX);
        if (stringArray == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    protected String[] getArgs(String prefix) {
        String input = this.extractCommandArgument(prefix);
        String[] args = input.split("\\|");
        Args.parse((Object)this.myOptions, (String[])args[0].split(" "));
        if (args == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(4);
        }
        return args;
    }

    private void insertText(Project project, String insertText, Semaphore typingSemaphore, boolean warmup) {
        SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
        Span insertSpan = PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_items_loaded").startSpan();
        final Span firstBatchAddedSpan = PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_first_elements_added").startSpan();
        ui.addSearchListener((SearchListener)new SearchAdapter(){

            public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list) {
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.elementsAdded(list);
                firstBatchAddedSpan.setAttribute("number", (long)list.size());
                firstBatchAddedSpan.end();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand$2", "elementsAdded"));
            }
        });
        Future elements = ui.findElementsForPattern(insertText);
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> {
            insertSpan.setAttribute("text", insertText);
            List result2 = (List)elements.get();
            insertSpan.setAttribute("number", (long)result2.size());
            insertSpan.end();
            typingSemaphore.release();
            return result2;
        }));
    }

    private void typeText(Project project, String typingText, final Semaphore typingSemaphore, boolean warmup) {
        SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
        Document document = ui.getSearchField().getDocument();
        final Semaphore oneLetterLock = new Semaphore(1);
        final ThreadPoolExecutor typing = ConcurrencyUtil.newSingleThreadExecutor((String)"Performance plugin delayed type");
        final Ref isTypingFinished = new Ref((Object)false);
        final Ref oneLetterSpan = new Ref();
        final Ref firstBatchAddedSpan = new Ref();
        ui.addSearchListener((SearchListener)new SearchAdapter(){

            public void elementsAdded(@NotNull List<? extends SearchEverywhereFoundElementInfo> list) {
                if (list == null) {
                    3.$$$reportNull$$$0(0);
                }
                ((Span)firstBatchAddedSpan.get()).setAttribute("number", (long)list.size());
                ((Span)firstBatchAddedSpan.get()).end();
            }

            public void searchFinished(@NotNull List<Object> items) {
                if (items == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.searchFinished(items);
                oneLetterLock.release();
                if (!oneLetterSpan.isNull()) {
                    ((Span)oneLetterSpan.get()).setAttribute("number", (long)items.size());
                    ((Span)oneLetterSpan.get()).end();
                }
                if (((Boolean)isTypingFinished.get()).booleanValue()) {
                    typingSemaphore.release();
                    typing.shutdown();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "items";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementsAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "searchFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        int i = 0;
        while (i < typingText.length()) {
            int index = i++;
            typing.execute(Context.current().wrap(() -> {
                try {
                    oneLetterLock.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                    try {
                        char currentChar = typingText.charAt(index);
                        oneLetterSpan.set((Object)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_items_loaded").startSpan().setAttribute("text", String.valueOf(currentChar)));
                        firstBatchAddedSpan.set((Object)PerformanceTestSpan.getTracer(warmup).spanBuilder("searchEverywhere_first_elements_added").startSpan());
                        document.insertString(document.getLength(), String.valueOf(currentChar), null);
                        if (index == typingText.length() - 1) {
                            isTypingFinished.set((Object)true);
                        }
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }));
        }
    }

    protected void attachSearchListeners(@NotNull SearchEverywhereUI ui) {
        if (ui == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachSearchListeners";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    static class Options {
        @Argument
        String tab = "all";
        @Argument
        Boolean close = false;
        @Argument
        Boolean selectFirst = false;
        @Argument(alias="type")
        String typingText = "";

        Options() {
        }
    }
}

