/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.core.util.Lists;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;

final class JTreeAddRootIfInvisibleTask {
    @Nonnull
    @RunsInCurrentThread
    static TreePath addRootIfInvisible(@Nonnull JTree tree, @Nonnull TreePath path) {
        Object root = tree.getModel().getRoot();
        if (tree.isRootVisible() || root == null) {
            return path;
        }
        if (path.getPathCount() > 0 && root == path.getPathComponent(0)) {
            return path;
        }
        Object[] pathAsArray = path.getPath();
        if (pathAsArray == null) {
            return new TreePath(Lists.newArrayList(root));
        }
        ArrayList<Object> newPath = Lists.newArrayList(pathAsArray);
        newPath.add(0, root);
        return new TreePath(newPath.toArray());
    }

    private JTreeAddRootIfInvisibleTask() {
    }
}

