/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch.tool;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.editor.DiffEditorViewerFileEditor;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.diff.tools.combined.CombinedDiffComponentProcessor;
import com.intellij.diff.tools.combined.CombinedDiffManager;
import com.intellij.diff.tools.combined.CombinedDiffRegistry;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.StructureViewFileEditorProvider;
import com.intellij.openapi.fileEditor.impl.JComponentFileEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.PatchFileType;
import com.intellij.openapi.vcs.changes.patch.tool.CombinedViewerPatchChangeListener;
import com.intellij.openapi.vcs.changes.patch.tool.DiffPatchFileEditorProviderKt;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequestChain;
import com.intellij.openapi.vcs.changes.patch.tool.RequestProcessorPatchChangeListener;
import com.intellij.openapi.vcs.changes.ui.MutableDiffRequestChainProcessor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/patch/tool/DiffPatchFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/fileEditor/ex/StructureViewFileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "getStructureViewBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "intellij.platform.vcs.impl"})
public final class DiffPatchFileEditorProvider
implements FileEditorProvider,
StructureViewFileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Registry.is((String)"enable.patch.file.diff.viewer")) {
            return false;
        }
        return PatchFileType.isPatchFile(file) && TextEditorProvider.Companion.isTextFile(file) && !SingleRootFileViewProvider.isTooLargeForContentLoading((VirtualFile)file);
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            JPanel jPanel = DiffUtil.createMessagePanel((String)VcsBundle.message((String)"patch.parse.no.document.error", (Object[])new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createMessagePanel(...)");
            JPanel label = jPanel;
            JComponent jComponent = label;
            String string = DiffBundle.message((String)"diff.file.editor.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (FileEditor)new JComponentFileEditor(file, jComponent, string);
        }
        if (CombinedDiffRegistry.INSTANCE.isEnabled()) {
            CombinedDiffComponentProcessor processor2 = CombinedDiffManager.createProcessor$default((CombinedDiffManager)CombinedDiffManager.Companion.getInstance(project), null, (int)1, null);
            processor2.setBlocks(DiffPatchFileEditorProviderKt.access$buildCombinedDiffModel(document));
            DiffEditorViewerFileEditor editor = new DiffEditorViewerFileEditor(file, (DiffEditorViewer)processor2);
            document.addDocumentListener((DocumentListener)new CombinedViewerPatchChangeListener(processor2), (Disposable)editor);
            return (FileEditor)editor;
        }
        PatchDiffRequestChain chain = new PatchDiffRequestChain(document);
        MutableDiffRequestChainProcessor processor3 = new MutableDiffRequestChainProcessor(project, (DiffRequestChain)chain);
        DiffEditorViewerFileEditor editor = new DiffEditorViewerFileEditor(file, (DiffEditorViewer)processor3);
        document.addDocumentListener((DocumentListener)new RequestProcessorPatchChangeListener(processor3), (Disposable)editor);
        return (FileEditor)editor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "DiffPatchFileEditorProvider";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.PLACE_BEFORE_DEFAULT_EDITOR;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }
}

