/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.java;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.HtmlUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.grazie.utils.Text;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.impl.source.javadoc.PsiDocTagImpl;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class JavaTextExtractor
extends TextExtractor {
    private static final TokenSet EXCLUDED = TokenSet.create((IElementType[])new IElementType[]{JavaDocTokenType.DOC_COMMENT_START, JavaDocTokenType.DOC_COMMENT_LEADING_ASTERISKS, JavaDocTokenType.DOC_COMMENT_END, JavaDocElementType.DOC_PARAMETER_REF, JavaDocElementType.DOC_REFERENCE_HOLDER});
    private static final TextContentBuilder javadocBuilder = TextContentBuilder.FromPsi.withUnknown(e -> e instanceof PsiInlineDocTag).excluding(e -> EXCLUDED.contains(PsiUtilCore.getElementType((PsiElement)e))).removingIndents(" \t").removingLineSuffixes(" \t");

    @Override
    public TextContent buildTextContent(@NotNull PsiElement root, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (root == null) {
            JavaTextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            JavaTextExtractor.$$$reportNull$$$0(1);
        }
        if (allowedDomains.contains((Object)TextContent.TextDomain.DOCUMENTATION)) {
            if (root instanceof PsiDocComment) {
                return HtmlUtilsKt.removeHtml(javadocBuilder.excluding(e -> e instanceof PsiDocTagImpl).build(root, TextContent.TextDomain.DOCUMENTATION));
            }
            if (root instanceof PsiDocTagImpl) {
                return HtmlUtilsKt.removeHtml(javadocBuilder.build(root, TextContent.TextDomain.DOCUMENTATION));
            }
        }
        if (root instanceof PsiCommentImpl && allowedDomains.contains((Object)TextContent.TextDomain.COMMENTS)) {
            List<PsiElement> roots = PsiUtilsKt.getNotSoDistantSimilarSiblings(root, (Function1<? super PsiElement, Boolean>)((Function1)e -> ElementType.JAVA_PLAIN_COMMENT_BIT_SET.contains(PsiUtilCore.getElementType((PsiElement)e))));
            return TextContent.joinWithWhitespace('\n', ContainerUtil.mapNotNull(roots, c -> TextContentBuilder.FromPsi.removingIndents(" \t*/").removingLineSuffixes(" \t").build((PsiElement)c, TextContent.TextDomain.COMMENTS)));
        }
        if (root instanceof PsiLiteralExpression && allowedDomains.contains((Object)TextContent.TextDomain.LITERALS) && ((PsiLiteralExpression)root).getValue() instanceof String) {
            TextContent content = TextContentBuilder.FromPsi.build(root, TextContent.TextDomain.LITERALS);
            int indent = PsiLiteralUtil.getTextBlockIndent((PsiLiteralExpression)((PsiLiteralExpression)root));
            if (indent >= 0 && indent < 1000 && content != null) {
                if (indent > 0) {
                    content = content.excludeRanges(ContainerUtil.map(Text.allOccurrences(Pattern.compile("(?<=\n)\\s{" + indent + "}"), content), TextContent.Exclusion::exclude));
                }
                content = content.excludeRanges(ContainerUtil.map(Text.allOccurrences(Pattern.compile("\\\\\n"), content), TextContent.Exclusion::exclude));
                return content.trimWhitespace();
            }
            return content;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "allowedDomains";
                break;
            }
        }
        objectArray[1] = "com/intellij/grazie/ide/language/java/JavaTextExtractor";
        objectArray[2] = "buildTextContent";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

