/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.utils;

import ai.grazie.nlp.utils.WhiteSpacesKt;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.utils.Text;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.html.ApiKt;
import kotlinx.html.BODY;
import kotlinx.html.Entities;
import kotlinx.html.FlowContent;
import kotlinx.html.HTML;
import kotlinx.html.TABLE;
import kotlinx.html.TD;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.stream.StreamKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0016\u001a\u00020\u00062\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\u0002\b\u001b\u001a\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d\u001a\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001d\u001a\n\u0010\u0004\u001a\u00020\u001a*\u00020!\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"(\u0010\u0007\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\"(\u0010\r\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\"(\u0010\u0010\u001a\u00020\u0006*\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"anyTag", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "closingTag", "nbsp", "value", "", "cellpading", "Lkotlinx/html/TABLE;", "getCellpading", "(Lkotlinx/html/TABLE;)Ljava/lang/String;", "setCellpading", "(Lkotlinx/html/TABLE;Ljava/lang/String;)V", "cellspacing", "getCellspacing", "setCellspacing", "valign", "Lkotlinx/html/TD;", "getValign", "(Lkotlinx/html/TD;)Ljava/lang/String;", "setValign", "(Lkotlinx/html/TD;Ljava/lang/String;)V", "html", "body", "Lkotlin/Function1;", "Lkotlinx/html/BODY;", "", "Lkotlin/ExtensionFunctionType;", "nbspToSpace", "Lcom/intellij/grazie/text/TextContent;", "content", "removeHtml", "_content", "Lkotlinx/html/FlowContent;", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nHtmlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n+ 2 gen-consumer-tags.kt\nkotlinx/html/Gen_consumer_tagsKt\n+ 3 api.kt\nkotlinx/html/ApiKt\n+ 4 visit.kt\nkotlinx/html/VisitKt\n+ 5 gen-tags-h.kt\nkotlinx/html/Gen_tags_hKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n577#2,3:92\n79#3:95\n76#3:104\n10#4,5:96\n4#4,2:101\n6#4,10:105\n164#5:103\n378#6,7:115\n*S KotlinDebug\n*F\n+ 1 HtmlUtils.kt\ncom/intellij/grazie/utils/HtmlUtilsKt\n*L\n13#1:92,3\n13#1:95\n13#1:104\n13#1:96,5\n13#1:101,2\n13#1:105,10\n13#1:103\n55#1:115,7\n*E\n"})
public final class HtmlUtilsKt {
    private static final Pattern anyTag = Pattern.compile("</?\\w+[^>]*>");
    private static final Pattern closingTag = Pattern.compile("</\\w+\\s*>");
    private static final Pattern nbsp = Pattern.compile("&nbsp;");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String html(@NotNull Function1<? super BODY, Unit> body) {
        void $this$visitAndFinalize$iv$iv;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        TagConsumer $this$html_u24default$iv = StreamKt.createHTML$default((boolean)false, (boolean)false, (int)2, null);
        String namespace$iv = null;
        boolean $i$f$html = false;
        Tag tag = (Tag)new HTML(ApiKt.getEmptyMap(), $this$html_u24default$iv, namespace$iv);
        boolean $i$f$visitAndFinalize = false;
        void $this$visitTagAndFinalize$iv$iv$iv = $this$visitAndFinalize$iv$iv;
        boolean $i$f$visitTagAndFinalize = false;
        if ($this$visitTagAndFinalize$iv$iv$iv.getConsumer() != $this$html_u24default$iv) {
            throw new IllegalArgumentException("Wrong exception");
        }
        void $this$visitTag$iv$iv$iv$iv = $this$visitTagAndFinalize$iv$iv$iv;
        boolean $i$f$visitTag = false;
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagStart((Tag)$this$visitTag$iv$iv$iv$iv);
        void $this$visitAndFinalize_u24lambda_u241$iv$iv = $this$visitTag$iv$iv$iv$iv;
        boolean bl = false;
        HTML $this$html_u24lambda_u241 = (HTML)$this$visitAndFinalize_u24lambda_u241$iv$iv;
        boolean bl2 = false;
        HTML $this$body_u24default$iv = $this$html_u24lambda_u241;
        String classes$iv = null;
        boolean $i$f$body = false;
        Tag $this$visit$iv$iv = (Tag)new BODY(ApiKt.attributesMapOf((String)"class", classes$iv), $this$body_u24default$iv.getConsumer());
        boolean $i$f$visit = false;
        Tag $this$visitTag$iv$iv$iv = $this$visit$iv$iv;
        boolean $i$f$visitTag2 = false;
        $this$visitTag$iv$iv$iv.getConsumer().onTagStart($this$visitTag$iv$iv$iv);
        Tag $this$visit_u24lambda_u240$iv$iv = $this$visitTag$iv$iv$iv;
        boolean bl3 = false;
        BODY $this$html_u24lambda_u241_u24lambda_u240 = (BODY)$this$visit_u24lambda_u240$iv$iv;
        boolean bl4 = false;
        body.invoke((Object)$this$html_u24lambda_u241_u24lambda_u240);
        $this$visitTag$iv$iv$iv.getConsumer().onTagEnd($this$visitTag$iv$iv$iv);
        $this$visitTag$iv$iv$iv$iv.getConsumer().onTagEnd((Tag)$this$visitTag$iv$iv$iv$iv);
        return (String)$this$html_u24default$iv.finalize();
    }

    @NotNull
    public static final String getCellpading(@NotNull TABLE $this$cellpading) {
        Intrinsics.checkNotNullParameter((Object)$this$cellpading, (String)"<this>");
        String string2 = (String)$this$cellpading.getAttributes().get((Object)"cellpadding");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setCellpading(@NotNull TABLE $this$cellpading, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$cellpading, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$cellpading.getAttributes()).put("cellpadding", value);
    }

    @NotNull
    public static final String getCellspacing(@NotNull TABLE $this$cellspacing) {
        Intrinsics.checkNotNullParameter((Object)$this$cellspacing, (String)"<this>");
        String string2 = (String)$this$cellspacing.getAttributes().get((Object)"cellspacing");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setCellspacing(@NotNull TABLE $this$cellspacing, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$cellspacing, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$cellspacing.getAttributes()).put("cellspacing", value);
    }

    @NotNull
    public static final String getValign(@NotNull TD $this$valign) {
        Intrinsics.checkNotNullParameter((Object)$this$valign, (String)"<this>");
        String string2 = (String)$this$valign.getAttributes().get((Object)"valign");
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void setValign(@NotNull TD $this$valign, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$valign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)$this$valign.getAttributes()).put("valign", value);
    }

    public static final void nbsp(@NotNull FlowContent $this$nbsp) {
        Intrinsics.checkNotNullParameter((Object)$this$nbsp, (String)"<this>");
        $this$nbsp.unaryPlus(Entities.nbsp);
    }

    @Nullable
    public static final TextContent removeHtml(@Nullable TextContent _content) {
        Ref.ObjectRef content = new Ref.ObjectRef();
        TextContent textContent = _content;
        if (textContent == null) {
            return null;
        }
        content.element = textContent;
        while (StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<html>", (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"<body>", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)((TextContent)content.element).excludeRange(new TextRange(0, 6)), (String)"excludeRange(...)");
            content.element = content.element;
        }
        while (StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</html>", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)((CharSequence)content.element), (CharSequence)"</body>", (boolean)false, (int)2, null)) {
            Intrinsics.checkNotNullExpressionValue((Object)((TextContent)content.element).excludeRange(TextRange.from((int)(((TextContent)content.element).length() - 7), (int)7)), (String)"excludeRange(...)");
            content.element = content.element;
        }
        ArrayList<TextContent.Exclusion> exclusions = new ArrayList<TextContent.Exclusion>();
        Pattern pattern = anyTag;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"anyTag");
        for (TextRange tagRange : Text.allOccurrences(pattern, (CharSequence)content.element)) {
            ProgressManager.checkCanceled();
            if (closingTag.matcher(((TextContent)content.element).subSequence(tagRange.getStartOffset(), tagRange.getEndOffset())).matches()) {
                exclusions.add(TextContent.Exclusion.markUnknown(tagRange));
                HtmlUtilsKt.removeHtml$tagClosed(exclusions, (Ref.ObjectRef<TextContent>)content, ((Object)StringsKt.trim((CharSequence)((Object)((CharSequence)content.element).subSequence(tagRange.getStartOffset() + 2, tagRange.getEndOffset() - 1)).toString())).toString());
                continue;
            }
            if (HtmlUtilsKt.removeHtml$openingTagName((Ref.ObjectRef<TextContent>)content, tagRange.getStartOffset(), tagRange.getEndOffset()) == null) continue;
            exclusions.add(TextContent.Exclusion.markUnknown(tagRange));
        }
        return ((TextContent)content.element).excludeRanges((List<TextContent.Exclusion>)exclusions);
    }

    @Nullable
    public static final TextContent nbspToSpace(@Nullable TextContent content) {
        if (content == null) {
            return null;
        }
        Pattern pattern = nbsp;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"nbsp");
        List<TextRange> spaces = Text.allOccurrences(pattern, content);
        if (spaces.isEmpty()) {
            return content.trimWhitespace();
        }
        ArrayList<TextContent> components = new ArrayList<TextContent>();
        int n = spaces.size();
        for (int i = 0; i < n; ++i) {
            int prevEnd = i == 0 ? 0 : spaces.get(i - 1).getEndOffset();
            TextContent textContent = content.subText(new TextRange(prevEnd, spaces.get(i).getStartOffset()));
            components.add(textContent != null ? textContent.trimWhitespace() : null);
        }
        TextContent textContent = content.subText(new TextRange(((TextRange)CollectionsKt.last(spaces)).getEndOffset(), content.length()));
        components.add(textContent != null ? textContent.trimWhitespace() : null);
        return TextContent.joinWithWhitespace(' ', CollectionsKt.filterNotNull((Iterable)components));
    }

    private static final String removeHtml$openingTagName(Ref.ObjectRef<TextContent> content, int tagRangeStart, int tagRangeEnd) {
        return Character.isLetter(((TextContent)content.element).charAt(tagRangeStart + 1)) ? WhiteSpacesKt.takeNonWhitespaces(((Object)((CharSequence)content.element).subSequence(tagRangeStart + 1, tagRangeEnd - 1)).toString()) : null;
    }

    private static final void removeHtml$tagClosed(ArrayList<TextContent.Exclusion> exclusions, Ref.ObjectRef<TextContent> content, String tagName) {
        int openingIndex;
        block2: {
            int n;
            List $this$indexOfLast$iv = exclusions;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                TextContent.Exclusion it = (TextContent.Exclusion)iterator$iv.previous();
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)HtmlUtilsKt.removeHtml$openingTagName(content, it.start, it.end), (Object)tagName) && ((TextContent)content.element).charAt(it.end - 2) != '/')) continue;
                n = iterator$iv.nextIndex();
                break block2;
            }
            n = openingIndex = -1;
        }
        if (openingIndex >= 0) {
            exclusions.set(openingIndex, TextContent.Exclusion.markUnknown(new TextRange(exclusions.get((int)openingIndex).start, ((TextContent.Exclusion)CollectionsKt.last((List)((List)exclusions))).end)));
            exclusions.subList(openingIndex + 1, exclusions.size()).clear();
        }
    }
}

