/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.bindable.ViewModel;
import com.jetbrains.rd.ui.util.ExtensionsKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\bB\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/util/RichText;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "Lcom/jetbrains/rd/ui/bindable/ViewModel;", "()V", "text", "", "(Ljava/lang/String;)V", "richText", "(Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;)V", "parts", "", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichString;", "(Ljava/lang/String;Ljava/util/Collection;)V", "toRichTextModel", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "Companion", "intellij.rd.ui"})
public final class RichText
extends com.intellij.codeInsight.codeVision.ui.model.richText.RichText
implements ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RichText(@NotNull String text, @NotNull Collection<RichString> parts) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        super(text, parts);
    }

    @NotNull
    public final RichTextModel toRichTextModel() {
        List modelParts = new ArrayList();
        for (RichString part : this.getParts()) {
            Color color = part.getAttributes().getFgColor();
            Color color2 = part.getAttributes().getBgColor();
            Color color3 = part.getAttributes().getWaveColor();
            RichStringModel element = new RichStringModel(part.getText(), color != null ? ExtensionsKt.toRgbColor(color) : null, color2 != null ? ExtensionsKt.toRgbColor(color2) : null, color3 != null ? ExtensionsKt.toRgbColor(color3) : null, null, null, 48, null);
            modelParts.add(element);
        }
        return new RichTextModel(modelParts);
    }

    public RichText() {
        this("", CollectionsKt.emptyList());
    }

    public RichText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        this.append(text, simpleTextAttributes);
    }

    public RichText(@NotNull com.intellij.codeInsight.codeVision.ui.model.richText.RichText richText) {
        Intrinsics.checkNotNullParameter((Object)richText, (String)"richText");
        this(richText.getText(), richText.getParts());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rd/ui/util/RichText$Companion;", "", "()V", "toRichText", "Lcom/jetbrains/rd/ui/util/RichText;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RichText toRichText(@NotNull com.intellij.codeInsight.codeVision.ui.model.richText.RichText $this$toRichText) {
            Intrinsics.checkNotNullParameter((Object)$this$toRichText, (String)"<this>");
            return new RichText($this$toRichText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

