/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceChangeListListener;
import org.jetbrains.idea.perforce.application.PerforceNumberNameMap;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

@State(name="PerforceNumberNameSynchronizer", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
public class PerforceNumberNameSynchronizer
implements PersistentStateComponent<ConfigBean> {
    private final Map<ConnectionKey, PerforceNumberNameMap> myMap = new HashMap<ConnectionKey, PerforceNumberNameMap>();
    private final Object myLock = new Object();
    private final Project myProject;
    private ConfigBean myConfig = new ConfigBean();
    private static final Pattern AUTO_GENERATED_NAME_PATTERN = Pattern.compile("(.*?)( \\(\\d+\\))?");

    PerforceNumberNameSynchronizer(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleChangeListSubmitted(@NotNull P4Connection connection, long changeListNumber, long l) {
        void newNumber;
        if (connection == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(0);
        }
        if (changeListNumber > 0L && newNumber > 0L) {
            Object object = this.myLock;
            synchronized (object) {
                String prevName;
                PerforceNumberNameMap map = this.myMap.get(connection.getConnectionKey());
                if (map != null && (prevName = map.removeList(changeListNumber)) != null) {
                    map.put(prevName, (long)newNumber);
                }
            }
        }
    }

    void startListening(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(1);
        }
        ChangeListManager.getInstance((Project)this.myProject).addChangeListListener((ChangeListListener)new PerforceChangeListListener(this.myProject, this), parentDisposable);
    }

    public static PerforceNumberNameSynchronizer getInstance(Project project) {
        return (PerforceNumberNameSynchronizer)project.getService(PerforceNumberNameSynchronizer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNonexistentKeys(Set<ConnectionKey> keys) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.keySet().retainAll(keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> findOrCreate(@NotNull P4Connection connection, LocalChangeList list) throws VcsException {
        String description;
        if (connection == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(2);
        }
        String listName = list.getName();
        if (list.hasDefaultName()) {
            return Collections.singletonList(-1L);
        }
        ConnectionKey key = connection.getConnectionKey();
        Object object = this.myLock;
        synchronized (object) {
            PerforceNumberNameMap map = this.ensureMapping(key);
            Long number = map.getNumber(listName);
            if (number != null) {
                return Collections.singletonList(number);
            }
            description = PerforceNumberNameSynchronizer.getP4Description((ChangeList)list, map);
        }
        long newNumber = this.createList(connection, description);
        Object object2 = this.myLock;
        synchronized (object2) {
            this.ensureMapping(key).put(listName, newNumber);
            return Collections.singletonList(newNumber);
        }
    }

    private long createList(P4Connection connection, String description) throws VcsException {
        PerforceRunner runner = PerforceRunner.getInstance(this.myProject);
        for (PerforceChangeList changeList : runner.getPendingChangeLists(connection)) {
            if (!Objects.equals(changeList.getName(), description) || !changeList.getChanges().isEmpty()) continue;
            return changeList.getNumber();
        }
        return runner.createChangeList(description, connection, null);
    }

    private static String getP4Description(ChangeList list, PerforceNumberNameMap map) {
        String description = list.getComment().trim();
        if (description.length() == 0) {
            return list.getName();
        }
        return map.getNumber(description) != null ? list.getName() : description;
    }

    private PerforceNumberNameMap ensureMapping(ConnectionKey key) {
        return this.myMap.computeIfAbsent(key, __ -> new PerforceNumberNameMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> acceptInfo(ConnectionKey key, Collection<PerforceChangeList> lists, ChangeListManagerGate gate, Set<String> ideaLists) {
        Object object = this.myLock;
        synchronized (object) {
            PerforceNumberNameMap prevMap = this.ensureMapping(key);
            PerforceNumberNameMap currentMap = new PerforceNumberNameMap();
            for (PerforceChangeList changeList : ContainerUtil.sorted(lists, Comparator.comparing(PerforceChangeList::getNumber))) {
                String currentName = PerforceNumberNameSynchronizer.obtainIdeaChangeList(gate, prevMap, currentMap, changeList);
                ideaLists.add(currentName);
                currentMap.put(currentName, changeList.getNumber());
            }
            return prevMap.updateMapping(currentMap);
        }
    }

    @NotNull
    private static String obtainIdeaChangeList(@NotNull ChangeListManagerGate gate, @NotNull PerforceNumberNameMap prevMap, @NotNull PerforceNumberNameMap currentMap, @NotNull PerforceChangeList changeList) {
        LocalChangeList existingList;
        if (gate == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(3);
        }
        if (prevMap == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(4);
        }
        if (currentMap == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(5);
        }
        if (changeList == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(6);
        }
        String p4Description = changeList.getComment();
        String baseP4Name = PerforceNumberNameSynchronizer.toOneLine(p4Description);
        String associatedName = prevMap.getName(changeList.getNumber());
        LocalChangeList localChangeList = existingList = associatedName == null ? null : gate.findChangeList(associatedName);
        if (existingList != null) {
            String ideaComment = StringUtil.notNullize((String)existingList.getComment());
            return ideaComment.equals(p4Description) ? PerforceNumberNameSynchronizer.simplifyNameIfPossible(gate, associatedName, baseP4Name) : PerforceNumberNameSynchronizer.resetFromNativeDescription(gate, p4Description, ideaComment, associatedName);
        }
        if (gate.findChangeList(baseP4Name) != null && prevMap.getNumber(baseP4Name) == null && currentMap.getNumber(baseP4Name) == null) {
            String string = baseP4Name;
            if (string == null) {
                PerforceNumberNameSynchronizer.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = gate.addChangeList(PerforceNumberNameSynchronizer.suggestUniqueChangeListName(gate, baseP4Name), p4Description).getName();
        if (string == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String resetFromNativeDescription(ChangeListManagerGate gate, String nativeDescription, String ideaComment, String listName) {
        gate.editComment(listName, nativeDescription);
        String baseName = PerforceNumberNameSynchronizer.toOneLine(nativeDescription);
        if (PerforceNumberNameSynchronizer.isAutoGeneratedName(listName, PerforceNumberNameSynchronizer.toOneLine(ideaComment)) && !PerforceNumberNameSynchronizer.isAutoGeneratedName(listName, baseName)) {
            String uniqueName = PerforceNumberNameSynchronizer.suggestUniqueChangeListName(gate, baseName);
            gate.editName(listName, uniqueName);
            String string = uniqueName;
            if (string == null) {
                PerforceNumberNameSynchronizer.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = listName;
        if (string == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static String simplifyNameIfPossible(ChangeListManagerGate gate, String listName, String simplestName) {
        if (PerforceNumberNameSynchronizer.isAutoGeneratedName(listName, simplestName) && !listName.equals(simplestName) && gate.findChangeList(simplestName) == null) {
            gate.editName(listName, simplestName);
            return simplestName;
        }
        return listName;
    }

    private static boolean isAutoGeneratedName(String name, String baseName) {
        Matcher matcher = AUTO_GENERATED_NAME_PATTERN.matcher(name);
        return matcher.matches() && baseName.equals(matcher.group(1));
    }

    @NotNull
    private static String suggestUniqueChangeListName(ChangeListManagerGate gate, String baseName) {
        String string = UniqueNameGenerator.generateUniqueName((String)baseName, (String)"", (String)"", (String)" (", (String)")", s -> gate.findChangeList(s) == null);
        if (string == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @VisibleForTesting
    public static String toOneLine(String description) {
        int pos = (description = description.trim()).indexOf("\n");
        Object object = pos >= 0 ? description.substring(0, pos).trim() + "..." : description;
        if (object == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(12);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(@NotNull ConnectionKey key, @NotNull Long number) {
        if (key == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(13);
        }
        if (number == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            PerforceNumberNameMap map = this.myMap.get(key);
            return map != null ? map.getName(number) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Long getNumber(@NotNull ConnectionKey key, @NotNull String name) {
        if (key == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(15);
        }
        if (name == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(16);
        }
        Object object = this.myLock;
        synchronized (object) {
            PerforceNumberNameMap map = this.myMap.get(key);
            return map != null ? map.getNumber(name) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiMap<ConnectionKey, Long> getAllNumbers(@NotNull String name) {
        if (name == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(17);
        }
        MultiMap numbers = MultiMap.create();
        Object object = this.myLock;
        synchronized (object) {
            for (Map.Entry<ConnectionKey, PerforceNumberNameMap> entry : this.myMap.entrySet()) {
                Long number = entry.getValue().getNumber(name);
                if (number == null) continue;
                numbers.putValue((Object)entry.getKey(), (Object)number);
            }
        }
        return numbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHidden(Long number, boolean hidden) {
        Object object = this.myLock;
        synchronized (object) {
            if (hidden) {
                this.myConfig.removedFromIdea.add(number);
            } else {
                this.myConfig.removedFromIdea.remove(number);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHidden(Long number) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myConfig.removedFromIdea.contains(number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renameList(@NotNull String from, @NotNull String to) {
        if (from == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(18);
        }
        if (to == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(19);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.values().forEach(map -> map.rename(from, to));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeList(long nativeNumber) {
        Object object = this.myLock;
        synchronized (object) {
            this.myMap.values().forEach(map -> map.removeList(nativeNumber));
        }
        this.setHidden(nativeNumber, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ConfigBean getState() {
        Object object = this.myLock;
        synchronized (object) {
            this.myConfig.listMappings.clear();
            for (Map.Entry<ConnectionKey, PerforceNumberNameMap> entry : this.myMap.entrySet()) {
                ConnectionKeyBean bean = new ConnectionKeyBean();
                bean.server = entry.getKey().getServer();
                bean.client = entry.getKey().getClient();
                bean.user = entry.getKey().getUser();
                this.myConfig.listMappings.put(bean, entry.getValue());
            }
            return this.myConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull ConfigBean state) {
        if (state == null) {
            PerforceNumberNameSynchronizer.$$$reportNull$$$0(20);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myConfig = state;
            this.myMap.clear();
            for (Map.Entry<ConnectionKeyBean, PerforceNumberNameMap> entry : this.myConfig.listMappings.entrySet()) {
                this.myMap.put(new ConnectionKey(entry.getKey().server, entry.getKey().client, entry.getKey().user), entry.getValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMap";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceNumberNameSynchronizer";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceNumberNameSynchronizer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainIdeaChangeList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resetFromNativeDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUniqueChangeListName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toOneLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleChangeListSubmitted";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startListening";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "obtainIdeaChangeList";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAllNumbers";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "renameList";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    public static class ConfigBean {
        public Set<Long> removedFromIdea = new LinkedHashSet<Long>();
        public Map<ConnectionKeyBean, PerforceNumberNameMap> listMappings = new HashMap<ConnectionKeyBean, PerforceNumberNameMap>();
    }

    public static class ConnectionKeyBean {
        public String server;
        public String client;
        public String user;
    }
}

