/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.arrays;

import io.kinference.ndarray.UtilsKt;
import io.kinference.ndarray.arrays.ShortHeapKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0017\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\u001fR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lio/kinference/ndarray/arrays/ShortMinHeap;", "", "size", "", "(I)V", "count", "data", "", "getData", "()[S", "indices", "", "getIndices", "()[I", "maxIndex", "getMaxIndex", "()I", "maxValue", "", "getMaxValue", "()S", "clear", "", "insert", "key", "index", "removeMax", "siftDown", "idx", "siftUp", "sorted", "Lkotlin/Pair;", "ndarray-core"})
public final class ShortMinHeap {
    @NotNull
    private final short[] data;
    @NotNull
    private final int[] indices;
    private int count;

    public ShortMinHeap(int size2) {
        this.data = new short[size2];
        this.indices = new int[size2];
    }

    @NotNull
    public final short[] getData() {
        return this.data;
    }

    @NotNull
    public final int[] getIndices() {
        return this.indices;
    }

    public final short getMaxValue() {
        return this.data[0];
    }

    private final int getMaxIndex() {
        return this.indices[0];
    }

    private final void siftUp(int idx) {
        int internalIdx = idx;
        while (this.data[idx] > this.data[(idx - 1) / 2]) {
            UtilsKt.swap(this.indices, idx, (idx - 1) / 2);
            ShortHeapKt.swap(this.data, idx, (idx - 1) / 2);
            internalIdx = (internalIdx - 1) / 2;
        }
    }

    private final void siftDown(int idx) {
        int internalIdx = idx;
        while (2 * internalIdx + 1 < this.count) {
            int j;
            int left = 2 * internalIdx + 1;
            int right = left + 1;
            int n = j = right < this.count && this.data[right] > this.data[left] ? right : left;
            if (this.data[internalIdx] >= this.data[j]) break;
            ShortHeapKt.swap(this.data, internalIdx, j);
            UtilsKt.swap(this.indices, internalIdx, j);
            internalIdx = j;
        }
    }

    public final void insert(short key, int index) {
        int n = this.count;
        this.count = n + 1;
        this.data[this.count - 1] = key;
        this.indices[this.count - 1] = index;
        this.siftUp(this.count - 1);
    }

    public final void removeMax() {
        this.data[0] = this.data[this.count - 1];
        this.indices[0] = this.indices[this.count - 1];
        int n = this.count;
        this.count = n + -1;
        this.siftDown(0);
    }

    @NotNull
    public final Pair<short[], int[]> sorted() {
        short[] sortedData = new short[this.count];
        int[] sortedIndices = new int[this.count];
        for (int idx = this.count - 1; -1 < idx; --idx) {
            sortedData[idx] = this.getMaxValue();
            sortedIndices[idx] = this.getMaxIndex();
            this.removeMax();
        }
        return TuplesKt.to((Object)sortedData, (Object)sortedIndices);
    }

    public final void clear() {
        this.count = 0;
    }
}

