/*
 * Decompiled with CFR 0.152.
 */
package io.kinference.ndarray.extensions.broadcasting;

import io.kinference.ndarray.arrays.NDArrayCore;
import io.kinference.ndarray.extensions.utils.UtilsKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 #2\u00020\u0001:\u0001#B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0014J\t\u0010\u0018\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003JL\u0010\u001c\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\tH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006$"}, d2={"Lio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo;", "", "broadcastingShapes", "", "", "broadcastingDestShape", "destShape", "broadcastingAxes", "", "", "broadcastAlongLastAxis", "", "([[I[I[ILjava/util/List;Z)V", "getBroadcastAlongLastAxis", "()Z", "getBroadcastingAxes", "()Ljava/util/List;", "getBroadcastingDestShape", "()[I", "getBroadcastingShapes", "()[[I", "[[I", "getDestShape", "component1", "component2", "component3", "component4", "component5", "copy", "([[I[I[ILjava/util/List;Z)Lio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo;", "equals", "other", "hashCode", "toString", "", "Companion", "ndarray-core"})
public final class BroadcastingInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[][] broadcastingShapes;
    @NotNull
    private final int[] broadcastingDestShape;
    @NotNull
    private final int[] destShape;
    @NotNull
    private final List<Integer> broadcastingAxes;
    private final boolean broadcastAlongLastAxis;

    public BroadcastingInfo(@NotNull int[][] broadcastingShapes, @NotNull int[] broadcastingDestShape, @NotNull int[] destShape, @NotNull List<Integer> broadcastingAxes, boolean broadcastAlongLastAxis) {
        Intrinsics.checkNotNullParameter((Object)broadcastingShapes, (String)"broadcastingShapes");
        Intrinsics.checkNotNullParameter((Object)broadcastingDestShape, (String)"broadcastingDestShape");
        Intrinsics.checkNotNullParameter((Object)destShape, (String)"destShape");
        Intrinsics.checkNotNullParameter(broadcastingAxes, (String)"broadcastingAxes");
        this.broadcastingShapes = broadcastingShapes;
        this.broadcastingDestShape = broadcastingDestShape;
        this.destShape = destShape;
        this.broadcastingAxes = broadcastingAxes;
        this.broadcastAlongLastAxis = broadcastAlongLastAxis;
    }

    @NotNull
    public final int[][] getBroadcastingShapes() {
        return this.broadcastingShapes;
    }

    @NotNull
    public final int[] getBroadcastingDestShape() {
        return this.broadcastingDestShape;
    }

    @NotNull
    public final int[] getDestShape() {
        return this.destShape;
    }

    @NotNull
    public final List<Integer> getBroadcastingAxes() {
        return this.broadcastingAxes;
    }

    public final boolean getBroadcastAlongLastAxis() {
        return this.broadcastAlongLastAxis;
    }

    @NotNull
    public final int[][] component1() {
        return this.broadcastingShapes;
    }

    @NotNull
    public final int[] component2() {
        return this.broadcastingDestShape;
    }

    @NotNull
    public final int[] component3() {
        return this.destShape;
    }

    @NotNull
    public final List<Integer> component4() {
        return this.broadcastingAxes;
    }

    public final boolean component5() {
        return this.broadcastAlongLastAxis;
    }

    @NotNull
    public final BroadcastingInfo copy(@NotNull int[][] broadcastingShapes, @NotNull int[] broadcastingDestShape, @NotNull int[] destShape, @NotNull List<Integer> broadcastingAxes, boolean broadcastAlongLastAxis) {
        Intrinsics.checkNotNullParameter((Object)broadcastingShapes, (String)"broadcastingShapes");
        Intrinsics.checkNotNullParameter((Object)broadcastingDestShape, (String)"broadcastingDestShape");
        Intrinsics.checkNotNullParameter((Object)destShape, (String)"destShape");
        Intrinsics.checkNotNullParameter(broadcastingAxes, (String)"broadcastingAxes");
        return new BroadcastingInfo(broadcastingShapes, broadcastingDestShape, destShape, broadcastingAxes, broadcastAlongLastAxis);
    }

    public static /* synthetic */ BroadcastingInfo copy$default(BroadcastingInfo broadcastingInfo, int[][] nArray, int[] nArray2, int[] nArray3, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            nArray = broadcastingInfo.broadcastingShapes;
        }
        if ((n & 2) != 0) {
            nArray2 = broadcastingInfo.broadcastingDestShape;
        }
        if ((n & 4) != 0) {
            nArray3 = broadcastingInfo.destShape;
        }
        if ((n & 8) != 0) {
            list = broadcastingInfo.broadcastingAxes;
        }
        if ((n & 0x10) != 0) {
            bl = broadcastingInfo.broadcastAlongLastAxis;
        }
        return broadcastingInfo.copy(nArray, nArray2, nArray3, list, bl);
    }

    @NotNull
    public String toString() {
        return "BroadcastingInfo(broadcastingShapes=" + Arrays.toString((Object[])this.broadcastingShapes) + ", broadcastingDestShape=" + Arrays.toString(this.broadcastingDestShape) + ", destShape=" + Arrays.toString(this.destShape) + ", broadcastingAxes=" + this.broadcastingAxes + ", broadcastAlongLastAxis=" + this.broadcastAlongLastAxis + ")";
    }

    public int hashCode() {
        int result2 = Arrays.hashCode((Object[])this.broadcastingShapes);
        result2 = result2 * 31 + Arrays.hashCode(this.broadcastingDestShape);
        result2 = result2 * 31 + Arrays.hashCode(this.destShape);
        result2 = result2 * 31 + ((Object)this.broadcastingAxes).hashCode();
        int n = this.broadcastAlongLastAxis ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BroadcastingInfo)) {
            return false;
        }
        BroadcastingInfo broadcastingInfo = (BroadcastingInfo)other;
        if (!Intrinsics.areEqual((Object)this.broadcastingShapes, (Object)broadcastingInfo.broadcastingShapes)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.broadcastingDestShape, (Object)broadcastingInfo.broadcastingDestShape)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.destShape, (Object)broadcastingInfo.destShape)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.broadcastingAxes, broadcastingInfo.broadcastingAxes)) {
            return false;
        }
        return this.broadcastAlongLastAxis == broadcastingInfo.broadcastAlongLastAxis;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo$Companion;", "", "()V", "create", "Lio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo;", "inputs", "", "Lio/kinference/ndarray/arrays/NDArrayCore;", "shapeToBroadcastingShape", "", "expandedShape", "broadcastingAxes", "", "broadcastAlongLastAxis", "", "ndarray-core"})
    @SourceDebugExtension(value={"SMAP\nReshapeView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReshapeView.kt\nio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1747#3,3:107\n*S KotlinDebug\n*F\n+ 1 ReshapeView.kt\nio/kinference/ndarray/extensions/broadcasting/BroadcastingInfo$Companion\n*L\n17#1:107,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final BroadcastingInfo create(@NotNull List<? extends NDArrayCore> inputs) {
            int shapeIdx;
            int n;
            int[][] nArrayArray;
            Object object;
            boolean isRequiredExpand;
            int $i$f$any;
            int maxSize;
            int it32;
            block12: {
                Intrinsics.checkNotNullParameter(inputs, (String)"inputs");
                Iterator iterator2 = ((Iterable)inputs).iterator();
                if (!iterator2.hasNext()) {
                    throw new NoSuchElementException();
                }
                NDArrayCore it22 = (NDArrayCore)iterator2.next();
                boolean bl = false;
                int it22 = it22.getShape().length;
                while (iterator2.hasNext()) {
                    NDArrayCore it32 = (NDArrayCore)iterator2.next();
                    $i$a$-maxOf-BroadcastingInfo$Companion$create$maxSize$1 = false;
                    it32 = it32.getShape().length;
                    if (it22 >= it32) continue;
                    it22 = it32;
                }
                maxSize = it22;
                Iterable $this$any$iv = inputs;
                $i$f$any = 0;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NDArrayCore it = (NDArrayCore)element$iv;
                        boolean bl2 = false;
                        if (!(it.getShape().length != maxSize)) continue;
                        v0 = true;
                        break block12;
                    }
                    v0 = isRequiredExpand = false;
                }
            }
            if (isRequiredExpand) {
                $i$f$any = 0;
                it32 = inputs.size();
                element$iv = new int[it32][];
                while ($i$f$any < it32) {
                    void $this$create_u24lambda_u242;
                    int it = $i$f$any++;
                    int[] shape = inputs.get(it).getShape();
                    int offset = maxSize - shape.length;
                    int[] nArray = object = new int[maxSize];
                    int n2 = it;
                    int[][] nArrayArray2 = element$iv;
                    boolean bl = false;
                    ArraysKt.fill((int[])$this$create_u24lambda_u242, (int)1, (int)0, (int)offset);
                    ArraysKt.copyInto$default((int[])shape, (int[])$this$create_u24lambda_u242, (int)offset, (int)0, (int)0, (int)12, null);
                    Unit unit = Unit.INSTANCE;
                    nArrayArray2[n2] = object;
                }
                nArrayArray = element$iv;
            } else {
                $i$f$any = 0;
                it32 = inputs.size();
                element$iv = new int[it32][];
                while ($i$f$any < it32) {
                    int it = $i$f$any++;
                    element$iv[it] = inputs.get(it).getShape();
                }
                nArrayArray = element$iv;
            }
            int[][] expandedShapes = nArrayArray;
            List broadcastingAxes = new ArrayList();
            int[] destShape = new int[maxSize];
            block4: for (int axis2 = 0; axis2 < maxSize; ++axis2) {
                int dim;
                destShape[axis2] = dim = ((int[])ArraysKt.first((Object[])((Object[])expandedShapes)))[axis2];
                n = ((Object[])expandedShapes).length;
                for (shapeIdx = 1; shapeIdx < n; ++shapeIdx) {
                    if (dim == expandedShapes[shapeIdx][axis2]) continue;
                    broadcastingAxes.add(axis2);
                    destShape[axis2] = Math.max(dim, expandedShapes[shapeIdx][axis2]);
                    continue block4;
                }
            }
            boolean broadcastAlongLastAxis = !((Collection)broadcastingAxes).isEmpty() && ((Number)CollectionsKt.last((List)broadcastingAxes)).intValue() == maxSize - 1;
            shapeIdx = 0;
            n = ((Object[])expandedShapes).length;
            object = new int[n][];
            while (shapeIdx < n) {
                int n3 = shapeIdx++;
                object[n3] = (int)Companion.shapeToBroadcastingShape(expandedShapes[n3], broadcastingAxes, broadcastAlongLastAxis);
            }
            Object broadcastingInputShapes = object;
            int[] broadcastingDestShape = this.shapeToBroadcastingShape(destShape, broadcastingAxes, broadcastAlongLastAxis);
            return new BroadcastingInfo((int[][])broadcastingInputShapes, broadcastingDestShape, destShape, broadcastingAxes, broadcastAlongLastAxis);
        }

        private final int[] shapeToBroadcastingShape(int[] expandedShape, List<Integer> broadcastingAxes, boolean broadcastAlongLastAxis) {
            int[] newShape = broadcastAlongLastAxis ? new int[2 * broadcastingAxes.size()] : new int[2 * broadcastingAxes.size() + 1];
            int prevAxis = 0;
            int n = broadcastingAxes.size();
            for (int broadcastingAxisIdx = 0; broadcastingAxisIdx < n; ++broadcastingAxisIdx) {
                int broadcastingAxis = ((Number)broadcastingAxes.get(broadcastingAxisIdx)).intValue();
                int batch = UtilsKt.calculateBlock(expandedShape, prevAxis, broadcastingAxis);
                int dim = expandedShape[broadcastingAxis];
                newShape[broadcastingAxisIdx * 2] = batch;
                newShape[broadcastingAxisIdx * 2 + 1] = dim;
                prevAxis = broadcastingAxis + 1;
            }
            if (!broadcastAlongLastAxis) {
                int row;
                newShape[ArraysKt.getLastIndex((int[])newShape)] = row = UtilsKt.calculateBlock$default(expandedShape, prevAxis, 0, 2, null);
            }
            return newShape;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

