/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import javaslang.Tuple;
import javaslang.Tuple2;
import javaslang.Tuple3;
import javaslang.collection.Collections;
import javaslang.collection.RedBlackTree;
import javaslang.control.Option;

interface RedBlackTreeModule {

    public static final class Empty<T>
    implements RedBlackTree<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Comparator<T> comparator;

        Empty(Comparator<? super T> comparator2) {
            this.comparator = comparator2;
        }

        @Override
        public RedBlackTree.Color color() {
            return RedBlackTree.Color.BLACK;
        }

        @Override
        public Comparator<T> comparator() {
            return this.comparator;
        }

        @Override
        public boolean contains(T value2) {
            return false;
        }

        @Override
        public Empty<T> emptyInstance() {
            return this;
        }

        @Override
        public Option<T> find(T value2) {
            return Option.none();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public RedBlackTree<T> left() {
            throw new UnsupportedOperationException("left on empty");
        }

        @Override
        public RedBlackTree<T> right() {
            throw new UnsupportedOperationException("right on empty");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public T value() {
            throw new NoSuchElementException("value on empty");
        }

        @Override
        public boolean equals(Object o) {
            return o == this || o instanceof Empty;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public String toString() {
            return "()";
        }
    }

    public static final class Node<T>
    implements RedBlackTree<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        final RedBlackTree.Color color;
        final int blackHeight;
        final RedBlackTree<T> left;
        final T value;
        final RedBlackTree<T> right;
        final Empty<T> empty;
        final int size;

        Node(RedBlackTree.Color color, int blackHeight, RedBlackTree<T> left, T value2, RedBlackTree<T> right, Empty<T> empty) {
            this.color = color;
            this.blackHeight = blackHeight;
            this.left = left;
            this.value = value2;
            this.right = right;
            this.empty = empty;
            this.size = left.size() + right.size() + 1;
        }

        @Override
        public RedBlackTree.Color color() {
            return this.color;
        }

        @Override
        public Comparator<T> comparator() {
            return this.empty.comparator;
        }

        @Override
        public boolean contains(T value2) {
            int result2 = this.empty.comparator.compare(value2, this.value);
            if (result2 < 0) {
                return this.left.contains(value2);
            }
            if (result2 > 0) {
                return this.right.contains(value2);
            }
            return true;
        }

        @Override
        public Empty<T> emptyInstance() {
            return this.empty;
        }

        @Override
        public Option<T> find(T value2) {
            int result2 = this.empty.comparator.compare(value2, this.value);
            if (result2 < 0) {
                return this.left.find(value2);
            }
            if (result2 > 0) {
                return this.right.find(value2);
            }
            return Option.some(this.value);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public RedBlackTree<T> left() {
            return this.left;
        }

        @Override
        public RedBlackTree<T> right() {
            return this.right;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Node) {
                Node that = (Node)o;
                return Collections.equals(this, that);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Collections.hash(this);
        }

        @Override
        public String toString() {
            return this.isLeaf() ? "(" + (Object)((Object)this.color) + ":" + this.value + ")" : Node.toLispString(this);
        }

        private static String toLispString(RedBlackTree<?> tree2) {
            if (tree2.isEmpty()) {
                return "";
            }
            Node node2 = (Node)tree2;
            String value2 = (Object)((Object)node2.color) + ":" + node2.value;
            if (node2.isLeaf()) {
                return value2;
            }
            String left = node2.left.isEmpty() ? "" : " " + Node.toLispString(node2.left);
            String right = node2.right.isEmpty() ? "" : " " + Node.toLispString(node2.right);
            return "(" + value2 + left + right + ")";
        }

        private boolean isLeaf() {
            return this.left.isEmpty() && this.right.isEmpty();
        }

        Node<T> color(RedBlackTree.Color color) {
            return this.color == color ? this : new Node<T>(color, this.blackHeight, this.left, this.value, this.right, this.empty);
        }

        static <T> RedBlackTree<T> color(RedBlackTree<T> tree2, RedBlackTree.Color color) {
            return tree2.isEmpty() ? tree2 : ((Node)tree2).color(color);
        }

        private static <T> Node<T> balanceLeft(RedBlackTree.Color color, int blackHeight, RedBlackTree<T> left, T value2, RedBlackTree<T> right, Empty<T> empty) {
            if (color == RedBlackTree.Color.BLACK && !left.isEmpty()) {
                Node ln = (Node)left;
                if (ln.color == RedBlackTree.Color.RED) {
                    if (!ln.left.isEmpty()) {
                        Node lln = (Node)ln.left;
                        if (lln.color == RedBlackTree.Color.RED) {
                            Node<T> newLeft = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, lln.left, lln.value, lln.right, empty);
                            Node<T> newRight = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, ln.right, value2, right, empty);
                            return new Node<T>(RedBlackTree.Color.RED, blackHeight + 1, newLeft, ln.value, newRight, empty);
                        }
                    }
                    if (!ln.right.isEmpty()) {
                        Node lrn = (Node)ln.right;
                        if (lrn.color == RedBlackTree.Color.RED) {
                            Node<T> newLeft = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, ln.left, ln.value, lrn.left, empty);
                            Node<T> newRight = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, lrn.right, value2, right, empty);
                            return new Node<T>(RedBlackTree.Color.RED, blackHeight + 1, newLeft, lrn.value, newRight, empty);
                        }
                    }
                }
            }
            return new Node<T>(color, blackHeight, left, value2, right, empty);
        }

        private static <T> Node<T> balanceRight(RedBlackTree.Color color, int blackHeight, RedBlackTree<T> left, T value2, RedBlackTree<T> right, Empty<T> empty) {
            if (color == RedBlackTree.Color.BLACK && !right.isEmpty()) {
                Node rn = (Node)right;
                if (rn.color == RedBlackTree.Color.RED) {
                    if (!rn.right.isEmpty()) {
                        Node rrn = (Node)rn.right;
                        if (rrn.color == RedBlackTree.Color.RED) {
                            Node<T> newLeft = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, left, value2, rn.left, empty);
                            Node<T> newRight = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, rrn.left, rrn.value, rrn.right, empty);
                            return new Node<T>(RedBlackTree.Color.RED, blackHeight + 1, newLeft, rn.value, newRight, empty);
                        }
                    }
                    if (!rn.left.isEmpty()) {
                        Node rln = (Node)rn.left;
                        if (rln.color == RedBlackTree.Color.RED) {
                            Node<T> newLeft = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, left, value2, rln.left, empty);
                            Node<T> newRight = new Node<T>(RedBlackTree.Color.BLACK, blackHeight, rln.right, rn.value, rn.right, empty);
                            return new Node<T>(RedBlackTree.Color.RED, blackHeight + 1, newLeft, rln.value, newRight, empty);
                        }
                    }
                }
            }
            return new Node<T>(color, blackHeight, left, value2, right, empty);
        }

        private static <T> Tuple2<? extends RedBlackTree<T>, Boolean> blackify(RedBlackTree<T> tree2) {
            if (tree2 instanceof Node) {
                Node node2 = (Node)tree2;
                if (node2.color == RedBlackTree.Color.RED) {
                    return Tuple.of(node2.color(RedBlackTree.Color.BLACK), false);
                }
            }
            return Tuple.of(tree2, true);
        }

        static <T> Tuple2<? extends RedBlackTree<T>, Boolean> delete(RedBlackTree<T> tree2, T value2) {
            if (tree2.isEmpty()) {
                return Tuple.of(tree2, false);
            }
            Node node2 = (Node)tree2;
            int comparison = node2.comparator().compare(value2, node2.value);
            if (comparison < 0) {
                Tuple2<RedBlackTree<T>, Boolean> deleted = Node.delete(node2.left, value2);
                RedBlackTree l = (RedBlackTree)deleted._1;
                boolean d = (Boolean)deleted._2;
                if (d) {
                    return Node.unbalancedRight(node2.color, node2.blackHeight - 1, l, node2.value, node2.right, node2.empty);
                }
                Node<T> newNode = new Node<T>(node2.color, node2.blackHeight, l, node2.value, node2.right, node2.empty);
                return Tuple.of(newNode, false);
            }
            if (comparison > 0) {
                Tuple2<RedBlackTree<T>, Boolean> deleted = Node.delete(node2.right, value2);
                RedBlackTree r = (RedBlackTree)deleted._1;
                boolean d = (Boolean)deleted._2;
                if (d) {
                    return Node.unbalancedLeft(node2.color, node2.blackHeight - 1, node2.left, node2.value, r, node2.empty);
                }
                Node<T> newNode = new Node<T>(node2.color, node2.blackHeight, node2.left, node2.value, r, node2.empty);
                return Tuple.of(newNode, false);
            }
            if (node2.right.isEmpty()) {
                if (node2.color == RedBlackTree.Color.BLACK) {
                    return Node.blackify(node2.left);
                }
                return Tuple.of(node2.left, false);
            }
            Node nodeRight = (Node)node2.right;
            Tuple3<RedBlackTree<T>, Boolean, T> newRight = Node.deleteMin(nodeRight);
            RedBlackTree r = (RedBlackTree)newRight._1;
            boolean d = (Boolean)newRight._2;
            Object m = newRight._3;
            if (d) {
                return Node.unbalancedLeft(node2.color, node2.blackHeight - 1, node2.left, m, r, node2.empty);
            }
            Node<T> newNode = new Node<T>(node2.color, node2.blackHeight, node2.left, m, r, node2.empty);
            return Tuple.of(newNode, false);
        }

        private static <T> Tuple3<? extends RedBlackTree<T>, Boolean, T> deleteMin(Node<T> node2) {
            if (node2.left.isEmpty()) {
                if (node2.color == RedBlackTree.Color.BLACK) {
                    if (node2.right.isEmpty()) {
                        return Tuple.of(node2.empty, true, node2.value);
                    }
                    Node rightNode = (Node)node2.right;
                    return Tuple.of(rightNode.color(RedBlackTree.Color.BLACK), false, node2.value);
                }
                return Tuple.of(node2.right, false, node2.value);
            }
            Node nodeLeft = (Node)node2.left;
            Tuple3<RedBlackTree<T>, Boolean, T> newNode = Node.deleteMin(nodeLeft);
            RedBlackTree l = (RedBlackTree)newNode._1;
            boolean d = (Boolean)newNode._2;
            Object m = newNode._3;
            if (d) {
                Tuple2<Node<T>, Boolean> tD = Node.unbalancedRight(node2.color, node2.blackHeight - 1, l, node2.value, node2.right, node2.empty);
                return Tuple.of(tD._1, tD._2, m);
            }
            Node<T> tD = new Node<T>(node2.color, node2.blackHeight, l, node2.value, node2.right, node2.empty);
            return Tuple.of(tD, false, m);
        }

        static <T> Node<T> insert(RedBlackTree<T> tree2, T value2) {
            if (tree2.isEmpty()) {
                Empty empty = (Empty)tree2;
                return new Node<T>(RedBlackTree.Color.RED, 1, empty, value2, empty, empty);
            }
            Node<T> node2 = (Node<T>)tree2;
            int comparison = node2.comparator().compare(value2, node2.value);
            if (comparison < 0) {
                Node<T> newLeft = Node.insert(node2.left, value2);
                return newLeft == node2.left ? node2 : Node.balanceLeft(node2.color, node2.blackHeight, newLeft, node2.value, node2.right, node2.empty);
            }
            if (comparison > 0) {
                Node<T> newRight = Node.insert(node2.right, value2);
                return newRight == node2.right ? node2 : Node.balanceRight(node2.color, node2.blackHeight, node2.left, node2.value, newRight, node2.empty);
            }
            return new Node<T>(node2.color, node2.blackHeight, node2.left, value2, node2.right, node2.empty);
        }

        private static boolean isRed(RedBlackTree<?> tree2) {
            return !tree2.isEmpty() && ((Node)tree2).color == RedBlackTree.Color.RED;
        }

        static <T> RedBlackTree<T> join(RedBlackTree<T> t1, T value2, RedBlackTree<T> t2) {
            if (t1.isEmpty()) {
                return t2.insert(value2);
            }
            if (t2.isEmpty()) {
                return t1.insert(value2);
            }
            Node n1 = (Node)t1;
            Node n2 = (Node)t2;
            int comparison = n1.blackHeight - n2.blackHeight;
            if (comparison < 0) {
                return Node.joinLT(n1, value2, n2, n1.blackHeight).color(RedBlackTree.Color.BLACK);
            }
            if (comparison > 0) {
                return Node.joinGT(n1, value2, n2, n2.blackHeight).color(RedBlackTree.Color.BLACK);
            }
            return new Node<T>(RedBlackTree.Color.BLACK, n1.blackHeight + 1, n1, value2, n2, n1.empty);
        }

        private static <T> Node<T> joinGT(Node<T> n1, T value2, Node<T> n2, int h2) {
            if (n1.blackHeight == h2) {
                return new Node<T>(RedBlackTree.Color.RED, h2 + 1, n1, value2, n2, n1.empty);
            }
            Node<T> node2 = Node.joinGT((Node)n1.right, value2, n2, h2);
            return Node.balanceRight(n1.color, n1.blackHeight, n1.left, n1.value, node2, n2.empty);
        }

        private static <T> Node<T> joinLT(Node<T> n1, T value2, Node<T> n2, int h1) {
            if (n2.blackHeight == h1) {
                return new Node<T>(RedBlackTree.Color.RED, h1 + 1, n1, value2, n2, n1.empty);
            }
            Node<T> node2 = Node.joinLT(n1, value2, (Node)n2.left, h1);
            return Node.balanceLeft(n2.color, n2.blackHeight, node2, n2.value, n2.right, n2.empty);
        }

        static <T> RedBlackTree<T> merge(RedBlackTree<T> t1, RedBlackTree<T> t2) {
            if (t1.isEmpty()) {
                return t2;
            }
            if (t2.isEmpty()) {
                return t1;
            }
            Node n1 = (Node)t1;
            Node n2 = (Node)t2;
            int comparison = n1.blackHeight - n2.blackHeight;
            if (comparison < 0) {
                Node<T> node2 = Node.mergeLT(n1, n2, n1.blackHeight);
                return Node.color(node2, RedBlackTree.Color.BLACK);
            }
            if (comparison > 0) {
                Node<T> node3 = Node.mergeGT(n1, n2, n2.blackHeight);
                return Node.color(node3, RedBlackTree.Color.BLACK);
            }
            Node<T> node4 = Node.mergeEQ(n1, n2);
            return Node.color(node4, RedBlackTree.Color.BLACK);
        }

        private static <T> Node<T> mergeEQ(Node<T> n1, Node<T> n2) {
            int h2;
            T m = Node.minimum(n2);
            RedBlackTree t2 = (RedBlackTree)Node.deleteMin(n2)._1;
            int n = h2 = t2.isEmpty() ? 0 : ((Node)t2).blackHeight;
            if (n1.blackHeight == h2) {
                return new Node<T>(RedBlackTree.Color.RED, n1.blackHeight + 1, n1, m, t2, n1.empty);
            }
            if (Node.isRed(n1.left)) {
                Node<T> node2 = new Node<T>(RedBlackTree.Color.BLACK, n1.blackHeight, n1.right, m, t2, n1.empty);
                return new Node<T>(RedBlackTree.Color.RED, n1.blackHeight, Node.color(n1.left, RedBlackTree.Color.BLACK), n1.value, node2, n1.empty);
            }
            if (Node.isRed(n1.right)) {
                RedBlackTree<T> rl = ((Node)n1.right).left;
                T rx = ((Node)n1.right).value;
                RedBlackTree<T> rr = ((Node)n1.right).right;
                Node<T> left = new Node<T>(RedBlackTree.Color.RED, n1.blackHeight, n1.left, n1.value, rl, n1.empty);
                Node<T> right = new Node<T>(RedBlackTree.Color.RED, n1.blackHeight, rr, m, t2, n1.empty);
                return new Node<T>(RedBlackTree.Color.BLACK, n1.blackHeight, left, rx, right, n1.empty);
            }
            return new Node<T>(RedBlackTree.Color.BLACK, n1.blackHeight, n1.color(RedBlackTree.Color.RED), m, t2, n1.empty);
        }

        private static <T> Node<T> mergeGT(Node<T> n1, Node<T> n2, int h2) {
            if (n1.blackHeight == h2) {
                return Node.mergeEQ(n1, n2);
            }
            Node<T> node2 = Node.mergeGT((Node)n1.right, n2, h2);
            return Node.balanceRight(n1.color, n1.blackHeight, n1.left, n1.value, node2, n1.empty);
        }

        private static <T> Node<T> mergeLT(Node<T> n1, Node<T> n2, int h1) {
            if (n2.blackHeight == h1) {
                return Node.mergeEQ(n1, n2);
            }
            Node<T> node2 = Node.mergeLT(n1, (Node)n2.left, h1);
            return Node.balanceLeft(n2.color, n2.blackHeight, node2, n2.value, n2.right, n2.empty);
        }

        static <T> T maximum(Node<T> node2) {
            Node curr = node2;
            while (!curr.right.isEmpty()) {
                curr = (Node)curr.right;
            }
            return curr.value;
        }

        static <T> T minimum(Node<T> node2) {
            Node curr = node2;
            while (!curr.left.isEmpty()) {
                curr = (Node)curr.left;
            }
            return curr.value;
        }

        static <T> Tuple2<RedBlackTree<T>, RedBlackTree<T>> split(RedBlackTree<T> tree2, T value2) {
            if (tree2.isEmpty()) {
                return Tuple.of(tree2, tree2);
            }
            Node node2 = (Node)tree2;
            int comparison = node2.comparator().compare(value2, node2.value);
            if (comparison < 0) {
                Tuple2<RedBlackTree<T>, RedBlackTree<T>> split = Node.split(node2.left, value2);
                return Tuple.of(split._1, Node.join((RedBlackTree)split._2, node2.value, Node.color(node2.right, RedBlackTree.Color.BLACK)));
            }
            if (comparison > 0) {
                Tuple2<RedBlackTree<T>, RedBlackTree<T>> split = Node.split(node2.right, value2);
                return Tuple.of(Node.join(Node.color(node2.left, RedBlackTree.Color.BLACK), node2.value, (RedBlackTree)split._1), split._2);
            }
            return Tuple.of(Node.color(node2.left, RedBlackTree.Color.BLACK), Node.color(node2.right, RedBlackTree.Color.BLACK));
        }

        private static <T> Tuple2<Node<T>, Boolean> unbalancedLeft(RedBlackTree.Color color, int blackHeight, RedBlackTree<T> left, T value2, RedBlackTree<T> right, Empty<T> empty) {
            if (!left.isEmpty()) {
                Node ln = (Node)left;
                if (ln.color == RedBlackTree.Color.BLACK) {
                    Node<T> newNode = Node.balanceLeft(RedBlackTree.Color.BLACK, blackHeight, ln.color(RedBlackTree.Color.RED), value2, right, empty);
                    return Tuple.of(newNode, color == RedBlackTree.Color.BLACK);
                }
                if (color == RedBlackTree.Color.BLACK && !ln.right.isEmpty()) {
                    Node lrn = (Node)ln.right;
                    if (lrn.color == RedBlackTree.Color.BLACK) {
                        Node<T> newRightNode = Node.balanceLeft(RedBlackTree.Color.BLACK, blackHeight, lrn.color(RedBlackTree.Color.RED), value2, right, empty);
                        Node<T> newNode = new Node<T>(RedBlackTree.Color.BLACK, ln.blackHeight, ln.left, ln.value, newRightNode, empty);
                        return Tuple.of(newNode, false);
                    }
                }
            }
            throw new IllegalStateException(String.format("unbalancedLeft(%s, %s, %s, %s, %s)", new Object[]{color, blackHeight, left, value2, right}));
        }

        private static <T> Tuple2<Node<T>, Boolean> unbalancedRight(RedBlackTree.Color color, int blackHeight, RedBlackTree<T> left, T value2, RedBlackTree<T> right, Empty<T> empty) {
            if (!right.isEmpty()) {
                Node rn = (Node)right;
                if (rn.color == RedBlackTree.Color.BLACK) {
                    Node<T> newNode = Node.balanceRight(RedBlackTree.Color.BLACK, blackHeight, left, value2, rn.color(RedBlackTree.Color.RED), empty);
                    return Tuple.of(newNode, color == RedBlackTree.Color.BLACK);
                }
                if (color == RedBlackTree.Color.BLACK && !rn.left.isEmpty()) {
                    Node rln = (Node)rn.left;
                    if (rln.color == RedBlackTree.Color.BLACK) {
                        Node<T> newLeftNode = Node.balanceRight(RedBlackTree.Color.BLACK, blackHeight, left, value2, rln.color(RedBlackTree.Color.RED), empty);
                        Node<T> newNode = new Node<T>(RedBlackTree.Color.BLACK, rn.blackHeight, newLeftNode, rn.value, rn.right, empty);
                        return Tuple.of(newNode, false);
                    }
                }
            }
            throw new IllegalStateException(String.format("unbalancedRight(%s, %s, %s, %s, %s)", new Object[]{color, blackHeight, left, value2, right}));
        }
    }
}

