/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaNonPublicApi;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisFacade;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.InlineDelegatedPropertyAccessorsAnalyzer;
import org.jetbrains.kotlin.analysis.api.descriptors.utils.InlineFunctionsCollector;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@KaNonPublicApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer;", "", "analysisContext", "Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;", "analyzeOnlyReifiedInlineFunctions", "", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/descriptors/Fe10AnalysisContext;Z)V", "analyzedElements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlineFunctionsWithBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "analyze", "", "element", "allFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "inlineObjectDeclarations", "", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "analysis-api-fe10"})
@SourceDebugExtension(value={"SMAP\nInlineFunctionAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineFunctionAnalyzer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1628#2,3:120\n1863#2,2:123\n*S KotlinDebug\n*F\n+ 1 InlineFunctionAnalyzer.kt\norg/jetbrains/kotlin/analysis/api/descriptors/utils/InlineFunctionAnalyzer\n*L\n99#1:120,3\n107#1:123,2\n*E\n"})
public final class InlineFunctionAnalyzer {
    @NotNull
    private final Fe10AnalysisContext analysisContext;
    private final boolean analyzeOnlyReifiedInlineFunctions;
    @NotNull
    private final Set<KtElement> analyzedElements;
    @NotNull
    private final Set<KtDeclarationWithBody> inlineFunctionsWithBody;

    public InlineFunctionAnalyzer(@NotNull Fe10AnalysisContext analysisContext, boolean analyzeOnlyReifiedInlineFunctions) {
        Intrinsics.checkNotNullParameter((Object)analysisContext, (String)"analysisContext");
        this.analysisContext = analysisContext;
        this.analyzeOnlyReifiedInlineFunctions = analyzeOnlyReifiedInlineFunctions;
        this.analyzedElements = new LinkedHashSet();
        this.inlineFunctionsWithBody = new LinkedHashSet();
    }

    public final void analyze(@NotNull KtElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Project project2 = element3.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        HashSet nextInlineFunctions = new HashSet();
        InlineFunctionsCollector collector2 = new InlineFunctionsCollector(project3, this.analyzeOnlyReifiedInlineFunctions, (Function1<? super KtDeclarationWithBody, Unit>)((Function1)arg_0 -> InlineFunctionAnalyzer.analyze$lambda$0(this, nextInlineFunctions, arg_0)));
        InlineDelegatedPropertyAccessorsAnalyzer propertyAccessor = new InlineDelegatedPropertyAccessorsAnalyzer(this.analysisContext, collector2);
        element3.accept((PsiElementVisitor)new KtTreeVisitorVoid(this, collector2, propertyAccessor){
            final /* synthetic */ InlineFunctionAnalyzer this$0;
            final /* synthetic */ InlineFunctionsCollector $collector;
            final /* synthetic */ InlineDelegatedPropertyAccessorsAnalyzer $propertyAccessor;
            {
                this.this$0 = $receiver;
                this.$collector = $collector;
                this.$propertyAccessor = $propertyAccessor;
            }

            public void visitExpression(KtExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitExpression(expression2);
                BindingContext bindingContext2 = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), (KtElement)expression2, null, 2, null);
                Call call2 = (Call)bindingContext2.get((ReadOnlySlice)BindingContext.CALL, (Object)expression2);
                if (call2 == null) {
                    return;
                }
                Call call3 = call2;
                ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.RESOLVED_CALL, (Object)call3);
                this.$collector.checkResolveCall(resolvedCall2);
            }

            public void visitDestructuringDeclaration(KtDestructuringDeclaration destructuringDeclaration) {
                Intrinsics.checkNotNullParameter((Object)destructuringDeclaration, (String)"destructuringDeclaration");
                super.visitDestructuringDeclaration(destructuringDeclaration);
                BindingContext bindingContext2 = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), (KtElement)destructuringDeclaration, null, 2, null);
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    ResolvedCall resolvedCall2 = (ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.COMPONENT_RESOLVED_CALL, (Object)entry);
                    this.$collector.checkResolveCall(resolvedCall2);
                }
            }

            public void visitForExpression(KtForExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitForExpression(expression2);
                BindingContext bindingContext2 = Fe10AnalysisFacade.analyze$default((Fe10AnalysisFacade)InlineFunctionAnalyzer.access$getAnalysisContext$p(this.this$0), (KtElement)expression2, null, 2, null);
                this.$collector.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.$collector.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
                this.$collector.checkResolveCall((ResolvedCall)bindingContext2.get((ReadOnlySlice)BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL, (Object)expression2.getLoopRange()));
            }

            public void visitProperty(KtProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                super.visitProperty(property2);
                this.$propertyAccessor.visitProperty(property2);
            }
        });
        this.analyzedElements.add(element3);
        if (!((Collection)nextInlineFunctions).isEmpty()) {
            Iterator iterator2 = nextInlineFunctions.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                KtDeclarationWithBody inlineFunction = (KtDeclarationWithBody)e;
                if (inlineFunction.getBodyExpression() == null) continue;
                this.inlineFunctionsWithBody.add(inlineFunction);
                this.analyze((KtElement)inlineFunction);
            }
            this.analyzedElements.addAll(nextInlineFunctions);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtFile> allFiles() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.analyzedElements;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtElement ktElement = (KtElement)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(it.getContainingKtFile());
        }
        return CollectionsKt.toList((Iterable)((Iterable)var2_2));
    }

    @NotNull
    public final Set<KtObjectDeclaration> inlineObjectDeclarations() {
        Set results2 = new LinkedHashSet();
        Iterable $this$forEach$iv = this.inlineFunctionsWithBody;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression body2;
            KtDeclarationWithBody inlineFunction = (KtDeclarationWithBody)element$iv;
            boolean bl = false;
            if (inlineFunction.getBodyExpression() == null) continue;
            body2.accept((PsiElementVisitor)new KtTreeVisitorVoid(results2){
                final /* synthetic */ Set<KtObjectDeclaration> $results;
                {
                    this.$results = $results;
                }

                public void visitObjectLiteralExpression(KtObjectLiteralExpression expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    super.visitObjectLiteralExpression(expression2);
                    KtObjectDeclaration ktObjectDeclaration = expression2.getObjectDeclaration();
                    Intrinsics.checkNotNullExpressionValue((Object)ktObjectDeclaration, (String)"getObjectDeclaration(...)");
                    this.$results.add(ktObjectDeclaration);
                }
            });
        }
        return results2;
    }

    private static final Unit analyze$lambda$0(InlineFunctionAnalyzer this$0, HashSet $nextInlineFunctions, KtDeclarationWithBody declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (!this$0.analyzedElements.contains(declaration2)) {
            $nextInlineFunctions.add(declaration2);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Fe10AnalysisContext access$getAnalysisContext$p(InlineFunctionAnalyzer $this) {
        return $this.analysisContext;
    }
}

