/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extended.FirAnonymousUnusedParamChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/FirAnonymousUnusedParamChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnonymousFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "unusedParamsVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "LambdaBodyContext", "checkers"})
public final class FirAnonymousUnusedParamChecker
extends FirDeclarationChecker<FirAnonymousFunction> {
    @NotNull
    public static final FirAnonymousUnusedParamChecker INSTANCE = new FirAnonymousUnusedParamChecker();
    @NotNull
    private static final FirVisitor<Unit, Set<FirValueParameterSymbol>> unusedParamsVisitor = new FirVisitor<Unit, Set<FirValueParameterSymbol>>(){

        public void visitElement(FirElement element3, Set<FirValueParameterSymbol> data) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!((Collection)data).isEmpty()) {
                element3.acceptChildren(this, data);
            }
        }

        public void visitResolvedNamedReference(FirResolvedNamedReference resolvedNamedReference, Set<FirValueParameterSymbol> data) {
            Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            CollectionsKt.removeAll((Iterable)data, arg_0 -> unusedParamsVisitor.1.visitResolvedNamedReference$lambda$0(resolvedNamedReference, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        public void visitAnonymousFunction(FirAnonymousFunction anonymousFunction, Set<FirValueParameterSymbol> data) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            FirValueParameterSymbol it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)anonymousFunction, (String)"anonymousFunction");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            if (!anonymousFunction.isLambda()) {
                this.visitElement((FirElement)anonymousFunction, data);
                return;
            }
            Iterable $this$map$iv = anonymousFunction.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((FirValueParameter)((Object)it)).getSymbol());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            boolean $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (FirValueParameterSymbol)element$iv$iv;
                boolean bl = false;
                if (!(!(it.getSource() instanceof KtFakeSourceElement))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set unusedParams = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            data.addAll(unusedParams);
            anonymousFunction.acceptChildren(this, data);
        }

        private static final boolean visitResolvedNamedReference$lambda$0(FirResolvedNamedReference $resolvedNamedReference, FirValueParameterSymbol it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual($resolvedNamedReference.getResolvedSymbol(), (Object)it);
        }
    };

    private FirAnonymousUnusedParamChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirAnonymousFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            LambdaBodyContext lambdaBodyContext = context2.getLambdaBodyContext();
            if (lambdaBodyContext == null) break block0;
            lambdaBodyContext.checkUnusedParams$checkers(declaration2, context2, reporter);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/FirAnonymousUnusedParamChecker$LambdaBodyContext;", "", "outermostLambda", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)V", "checkUnusedParams", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkUnusedParams$checkers", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirAnonymousUnusedParamChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnonymousUnusedParamChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/FirAnonymousUnusedParamChecker$LambdaBodyContext\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1557#2:74\n1628#2,3:75\n774#2:78\n865#2,2:79\n1863#2,2:81\n*S KotlinDebug\n*F\n+ 1 FirAnonymousUnusedParamChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extended/FirAnonymousUnusedParamChecker$LambdaBodyContext\n*L\n32#1:74\n32#1:75,3\n32#1:78\n32#1:79,2\n35#1:81,2\n*E\n"})
    public static final class LambdaBodyContext {
        @NotNull
        private final FirAnonymousFunction outermostLambda;

        public LambdaBodyContext(@NotNull FirAnonymousFunction outermostLambda) {
            Intrinsics.checkNotNullParameter((Object)outermostLambda, (String)"outermostLambda");
            this.outermostLambda = outermostLambda;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkUnusedParams$checkers(@NotNull FirAnonymousFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            FirValueParameterSymbol it;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            if (!Intrinsics.areEqual((Object)declaration2, (Object)this.outermostLambda)) {
                return;
            }
            Iterable $this$map$iv = declaration2.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((FirValueParameter)((Object)it)).getSymbol());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (FirValueParameterSymbol)element$iv$iv;
                boolean bl = false;
                if (!(!(it.getSource() instanceof KtFakeSourceElement))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set unusedParams = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
            FirBlock firBlock = declaration2.getBody();
            if (firBlock != null) {
                firBlock.accept(unusedParamsVisitor, unusedParams);
            }
            Iterable $this$forEach$iv = unusedParams;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameterSymbol it2 = (FirValueParameterSymbol)element$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)it2.getSource()), FirErrors.INSTANCE.getUNUSED_ANONYMOUS_PARAMETER(), (Object)it2, (DiagnosticContext)context2, null, (int)16, null);
            }
        }
    }
}

