/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.idea.ScriptResidenceExceptionProvider;
import org.jetbrains.kotlin.idea.base.projectStructure.LanguageVersionSettingsProviderUtils;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerSettings;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\b\u001a\n\u0010\t\u001a\u00020\u0004*\u00020\b\u001a\u001c\u0010\n\u001a\u00020\u0004*\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u000e\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0014\u0010\u000f\u001a\u00020\u0004*\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"scriptResidenceExceptionProviders", "", "Lorg/jetbrains/kotlin/idea/ScriptResidenceExceptionProvider;", "compilerAllowsAnyScriptsInSourceRoots", "", "project", "Lcom/intellij/openapi/project/Project;", "hasNoExceptionsToBeUnderSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasUnknownScriptExt", "isEnabled", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "module", "Lcom/intellij/openapi/module/Module;", "isRunnableKotlinScript", "isStandaloneKotlinScript", "kotlin.base.scripting"})
@SourceDebugExtension(value={"SMAP\nScriptResidenceExceptionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptResidenceExceptionProvider.kt\norg/jetbrains/kotlin/idea/ScriptResidenceExceptionProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n2624#2,3:84\n2624#2,3:87\n1#3:90\n*S KotlinDebug\n*F\n+ 1 ScriptResidenceExceptionProvider.kt\norg/jetbrains/kotlin/idea/ScriptResidenceExceptionProviderKt\n*L\n54#1:84,3\n57#1:87,3\n*E\n"})
public final class ScriptResidenceExceptionProviderKt {
    @NotNull
    private static final List<ScriptResidenceExceptionProvider> scriptResidenceExceptionProviders;

    public static final boolean hasUnknownScriptExt(@NotNull VirtualFile $this$hasUnknownScriptExt) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasUnknownScriptExt, (String)"<this>");
            Iterable $this$none$iv = scriptResidenceExceptionProviders;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ScriptResidenceExceptionProvider it = (ScriptResidenceExceptionProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isSupportedScriptExtension($this$hasUnknownScriptExt)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean hasNoExceptionsToBeUnderSourceRoot(@NotNull VirtualFile $this$hasNoExceptionsToBeUnderSourceRoot) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasNoExceptionsToBeUnderSourceRoot, (String)"<this>");
            Iterable $this$none$iv = scriptResidenceExceptionProviders;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ScriptResidenceExceptionProvider it = (ScriptResidenceExceptionProvider)element$iv;
                    boolean bl2 = false;
                    if (!it.isSupportedUnderSourceRoot($this$hasNoExceptionsToBeUnderSourceRoot)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static final boolean isEnabled(@NotNull LanguageFeature $this$isEnabled, @Nullable Module module2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$isEnabled, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Module module3 = module2;
        if (module3 == null || (module3 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(module3)) == null) {
            module3 = LanguageVersionSettingsProviderUtils.getLanguageVersionSettings(project2);
        }
        Module settings2 = module3;
        return settings2.supportsFeature($this$isEnabled);
    }

    @ApiStatus.Internal
    public static final boolean compilerAllowsAnyScriptsInSourceRoots(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CompilerSettings additionalSettings = (CompilerSettings)KotlinCompilerSettings.Companion.getInstance(project2).getSettings();
        return StringsKt.contains$default((CharSequence)additionalSettings.getAdditionalArguments(), (CharSequence)"-Xallow-any-scripts-in-source-roots", (boolean)false, (int)2, null);
    }

    @ApiStatus.Internal
    public static final boolean isRunnableKotlinScript(@NotNull VirtualFile $this$isRunnableKotlinScript, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)$this$isRunnableKotlinScript, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        CharSequence charSequence = $this$isRunnableKotlinScript.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        if (StringsKt.endsWith$default((CharSequence)charSequence, (CharSequence)".gradle.kts", (boolean)false, (int)2, null)) {
            return false;
        }
        return ScriptResidenceExceptionProviderKt.isStandaloneKotlinScript($this$isRunnableKotlinScript, project2);
    }

    @ApiStatus.Internal
    public static final boolean isStandaloneKotlinScript(@NotNull VirtualFile $this$isStandaloneKotlinScript, @NotNull Project project2) {
        Object object;
        block5: {
            block4: {
                KtFile ktFile2;
                Intrinsics.checkNotNullParameter((Object)$this$isStandaloneKotlinScript, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile($this$isStandaloneKotlinScript, project2);
                object = psiFile2 instanceof KtFile ? (KtFile)psiFile2 : null;
                if (object == null) break block4;
                KtFile p0 = ktFile2 = object;
                boolean bl = false;
                object = p0.isScript() ? ktFile2 : null;
                if (object != null) break block5;
            }
            return false;
        }
        KtFile ktFile3 = object;
        Object object2 = ScriptDefinitionProvider.Companion.getInstance(project2);
        if (object2 == null || (object2 = object2.findDefinition(new KtFileScriptSource(ktFile3, null, 2, null))) == null) {
            return false;
        }
        Object scriptDefinition = object2;
        return Intrinsics.areEqual((Object)((ScriptDefinition)((Object)scriptDefinition)).getCompilationConfiguration().get(ScriptCompilationKt.isStandalone(ScriptCompilationConfiguration.Companion)), (Object)true);
    }

    static {
        Object[] objectArray = new ScriptResidenceExceptionProvider[]{new ScriptResidenceExceptionProvider(".gradle.kts", true), new ScriptResidenceExceptionProvider(".main.kts", false, 2, null), new ScriptResidenceExceptionProvider(".space.kts", false, 2, null), new ScriptResidenceExceptionProvider(".inspection.kts", false, 2, null), new ScriptResidenceExceptionProvider(".ws.kts", true), new ScriptResidenceExceptionProvider(){

            public boolean isSupportedScriptExtension(@NotNull VirtualFile virtualFile2) {
                Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
                String string = virtualFile2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null)) {
                    return false;
                }
                for (VirtualFile parent2 = virtualFile2.getParent(); parent2 != null; parent2 = parent2.getParent()) {
                    if (!parent2.isDirectory() || !Intrinsics.areEqual((Object)parent2.getName(), (Object)".teamcity")) continue;
                    return true;
                }
                return false;
            }
        }};
        scriptResidenceExceptionProviders = CollectionsKt.listOf((Object[])objectArray);
    }
}

