/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.analysisApiPlatform;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinModuleDependentsProviderBase;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaBuiltinsModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptDependencyModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.idea.base.facet.KotlinFacetUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.base.projectStructure.KtLibraryModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtLibrarySourceModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSdkLibraryModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.KtSourceModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryDependenciesCache;
import org.jetbrains.kotlin.idea.base.projectStructure.LibraryUsageIndex;
import org.jetbrains.kotlin.idea.base.projectStructure.NotUnderContentRootModuleByModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.ProjectStructureProviderIdeImplKt;
import org.jetbrains.kotlin.idea.base.projectStructure.libraryToSourceAnalysis.ResolutionAnchorCacheService;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.LibraryInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleProductionSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.moduleInfo.ModuleTestSourceInfo;
import org.jetbrains.kotlin.idea.base.projectStructure.util.LibraryDependenciesUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u000b\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\t2\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u001a\u0010\u0012\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J\u001a\u0010\u0015\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u000b\u001a\u00020\u000fH\u0002J \u0010\u0016\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModuleDependentsProvider;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinModuleDependentsProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "transitiveDependentsCache", "Lcom/intellij/psi/util/CachedValue;", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "", "getDirectDependents", "module", "getDirectDependentsForLibraryModule", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KtLibraryModuleByModuleInfo;", "getDirectDependentsForSourceModule", "Lorg/jetbrains/kotlin/idea/base/projectStructure/KtSourceModuleByModuleInfo;", "getRefinementDependents", "getTransitiveDependents", "addAnchorModuleDependents", "", "", "addFriendDependentsForSourceModule", "addWorkspaceModelDependents", "symbolicId", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "kotlin.base.analysis-api-platform"})
@SourceDebugExtension(value={"SMAP\nIdeKotlinModuleDependentsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeKotlinModuleDependentsProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModuleDependentsProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1855#2,2:161\n1611#2:172\n1855#2:173\n1856#2:175\n1612#2:176\n31#3,2:163\n1144#4:165\n1313#4:166\n1314#4:168\n1145#4:169\n1313#4,2:170\n1#5:167\n1#5:174\n1#5:177\n*S KotlinDebug\n*F\n+ 1 IdeKotlinModuleDependentsProvider.kt\norg/jetbrains/kotlin/idea/base/analysisApiPlatform/IdeKotlinModuleDependentsProvider\n*L\n101#1:161,2\n157#1:172\n157#1:173\n157#1:175\n157#1:176\n108#1:163,2\n110#1:165\n110#1:166\n110#1:168\n110#1:169\n116#1:170,2\n110#1:167\n157#1:174\n*E\n"})
public final class IdeKotlinModuleDependentsProvider
extends KotlinModuleDependentsProviderBase {
    @NotNull
    private final Project project;
    @NotNull
    private final CachedValue<Cache<KaModule, Set<KaModule>>> transitiveDependentsCache;

    public IdeKotlinModuleDependentsProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)this.project).createCachedValue(() -> IdeKotlinModuleDependentsProvider.transitiveDependentsCache$lambda$4(this));
        Intrinsics.checkNotNullExpressionValue((Object)cachedValue2, (String)"createCachedValue(...)");
        this.transitiveDependentsCache = cachedValue2;
    }

    @Override
    @NotNull
    public Set<KaModule> getDirectDependents(@NotNull KaModule module2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        KaModule kaModule = module2;
        if (kaModule instanceof KtSourceModuleByModuleInfo) {
            set = this.getDirectDependentsForSourceModule((KtSourceModuleByModuleInfo)module2);
        } else if (kaModule instanceof KtLibraryModuleByModuleInfo) {
            set = this.getDirectDependentsForLibraryModule((KtLibraryModuleByModuleInfo)module2);
        } else if (kaModule instanceof KtLibrarySourceModuleByModuleInfo) {
            set = this.getDirectDependents(((KtLibrarySourceModuleByModuleInfo)module2).getBinaryLibrary());
        } else if (kaModule instanceof KtSdkLibraryModuleByModuleInfo) {
            set = SetsKt.emptySet();
        } else if (kaModule instanceof KaBuiltinsModule) {
            set = SetsKt.emptySet();
        } else if (kaModule instanceof KaDanglingFileModule) {
            set = SetsKt.emptySet();
        } else if (kaModule instanceof KaScriptModule ? true : kaModule instanceof KaScriptDependencyModule) {
            set = SetsKt.emptySet();
        } else if (kaModule instanceof NotUnderContentRootModuleByModuleInfo) {
            set = SetsKt.emptySet();
        } else {
            throw new KotlinExceptionWithAttachments("Unexpected " + Reflection.getOrCreateKotlinClass(module2.getClass()).getSimpleName()).withAttachment("module.txt", (Object)module2);
        }
        return set;
    }

    private final Set<KaModule> getDirectDependentsForSourceModule(KtSourceModuleByModuleInfo module2) {
        Set set;
        Set $this$getDirectDependentsForSourceModule_u24lambda_u240 = set = (Set)new LinkedHashSet();
        boolean bl = false;
        this.addFriendDependentsForSourceModule($this$getDirectDependentsForSourceModule_u24lambda_u240, module2);
        this.addWorkspaceModelDependents($this$getDirectDependentsForSourceModule_u24lambda_u240, (SymbolicEntityId<? extends WorkspaceEntityWithSymbolicId>)((SymbolicEntityId)module2.getModuleId()));
        this.addAnchorModuleDependents($this$getDirectDependentsForSourceModule_u24lambda_u240, module2);
        return set;
    }

    private final void addFriendDependentsForSourceModule(Set<KaModule> $this$addFriendDependentsForSourceModule, KtSourceModuleByModuleInfo module2) {
        if (module2.getIdeaModuleInfo() instanceof ModuleProductionSourceInfo) {
            ModuleTestSourceInfo moduleTestSourceInfo = KotlinProjectStructureUtils.getTestSourceInfo(module2.getIdeaModule());
            CollectionsKt.addIfNotNull((Collection)$this$addFriendDependentsForSourceModule, (Object)(moduleTestSourceInfo != null ? ProjectStructureProviderIdeImplKt.toKaModule(moduleTestSourceInfo) : null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addAnchorModuleDependents(Set<KaModule> $this$addAnchorModuleDependents, KtSourceModuleByModuleInfo module2) {
        void $this$forEach$iv;
        Object object = module2.getIdeaModuleInfo();
        ModuleSourceInfo moduleSourceInfo = object instanceof ModuleSourceInfo ? (ModuleSourceInfo)object : null;
        if (moduleSourceInfo == null) {
            return;
        }
        ModuleSourceInfo moduleInfo = moduleSourceInfo;
        List<LibraryInfo> list2 = ResolutionAnchorCacheService.Companion.getInstance(this.project).getLibrariesForResolutionAnchors().get(moduleInfo);
        if (list2 == null) {
            return;
        }
        List<LibraryInfo> anchoringLibraries = list2;
        object = LibraryDependenciesUtilKt.getTransitiveLibraryDependencyInfos(LibraryDependenciesCache.Companion.getInstance(this.project), (Collection<? extends LibraryInfo>)anchoringLibraries);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryInfo libraryInfo = (LibraryInfo)element$iv;
            boolean bl = false;
            $this$addAnchorModuleDependents.add(ProjectStructureProviderIdeImplKt.toKaModule(libraryInfo));
            $this$addAnchorModuleDependents.add(ProjectStructureProviderIdeImplKt.toKaModule(libraryInfo.getSourcesModuleInfo()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<KaModule> getDirectDependentsForLibraryModule(KtLibraryModuleByModuleInfo module2) {
        void var3_4;
        void $this$mapNotNullTo$iv;
        Sequence<Module> $this$service$iv = (Sequence<Module>)this.project;
        boolean $i$f$service = false;
        Class<LibraryUsageIndex> serviceClass$iv = LibraryUsageIndex.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        $this$service$iv = ((LibraryUsageIndex)object).getDependentModules(module2.getLibraryInfo());
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KaModule it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Module it = (Module)element$iv;
            boolean bl2 = false;
            ModuleSourceInfo moduleSourceInfo = KotlinProjectStructureUtils.getProductionOrTestSourceModuleInfo(it);
            if ((moduleSourceInfo != null ? ProjectStructureProviderIdeImplKt.toKaModule(moduleSourceInfo) : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return (Set)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private final void addWorkspaceModelDependents(Set<KaModule> $this$addWorkspaceModelDependents, SymbolicEntityId<? extends WorkspaceEntityWithSymbolicId> symbolicId) {
        void $this$forEach$iv;
        ImmutableEntityStorage snapshot2 = WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot();
        Sequence sequence2 = snapshot2.referrers(symbolicId, ModuleEntity.class);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModuleEntity moduleEntity = (ModuleEntity)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)moduleEntity.getSymbolicId(), symbolicId)) continue;
            Object object = ModuleEntityUtils.findModule((ModuleEntity)moduleEntity, (EntityStorage)((EntityStorage)snapshot2));
            CollectionsKt.addIfNotNull((Collection)$this$addWorkspaceModelDependents, object != null && (object = KotlinProjectStructureUtils.getProductionOrTestSourceModuleInfo((Module)object)) != null ? ProjectStructureProviderIdeImplKt.toKaModule((IdeaModuleInfo)object) : null);
        }
    }

    @Override
    @NotNull
    public Set<KaModule> getTransitiveDependents(@NotNull KaModule module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Object object = ((Cache)this.transitiveDependentsCache.getValue()).get((Object)module2, arg_0 -> IdeKotlinModuleDependentsProvider.getTransitiveDependents$lambda$5((Function1)new Function1<KaModule, Set<? extends KaModule>>(this){
            final /* synthetic */ IdeKotlinModuleDependentsProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Set<KaModule> invoke(KaModule it) {
                Intrinsics.checkNotNull((Object)it);
                return IdeKotlinModuleDependentsProvider.access$computeTransitiveDependents(this.this$0, it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Set)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<KaModule> getRefinementDependents(@NotNull KaModule module2) {
        Object object;
        void destination$iv;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Object object2 = KotlinProjectStructureUtils.getModuleInfo(module2);
        ModuleSourceInfo moduleSourceInfo = object2 instanceof ModuleSourceInfo ? (ModuleSourceInfo)object2 : null;
        if (moduleSourceInfo == null) {
            return SetsKt.emptySet();
        }
        ModuleSourceInfo moduleInfo = moduleSourceInfo;
        List<Module> implementingModules2 = KotlinFacetUtils.getImplementingModules(moduleInfo.getModule());
        object2 = implementingModules2;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KaModule it$iv;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl = false;
            Module it = (Module)element$iv;
            boolean bl2 = false;
            ModuleSourceInfo moduleSourceInfo2 = KotlinProjectStructureUtils.getProductionOrTestSourceModuleInfo(it);
            if ((moduleSourceInfo2 != null ? ProjectStructureProviderIdeImplKt.toKaModule(moduleSourceInfo2) : null) == null) continue;
            it$iv = it$iv;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        object2 = destination$iv;
        if (object2.isEmpty()) {
            boolean bl = false;
            object = SetsKt.emptySet();
        } else {
            object = object2;
        }
        return (Set)object;
    }

    private static final CachedValueProvider.Result transitiveDependentsCache$lambda$4(IdeKotlinModuleDependentsProvider this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Object[] objectArray = new Object[]{ProjectRootModificationTracker.getInstance((Project)this$0.project)};
        return CachedValueProvider.Result.create((Object)Caffeine.newBuilder().maximumSize(100L).build(), (Object[])objectArray);
    }

    private static final Set getTransitiveDependents$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Set access$computeTransitiveDependents(IdeKotlinModuleDependentsProvider $this, KaModule module2) {
        return $this.computeTransitiveDependents(module2);
    }
}

