/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.inspections.shared.libraries.AddKotlinLibraryQuickFixProvider;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/SimpleAddKotlinLibraryQuickFixProvider;", "Lorg/jetbrains/kotlin/idea/codeInsight/inspections/shared/libraries/AddKotlinLibraryQuickFixProvider;", "libraryGroupId", "", "libraryArtifactId", "namesToCheck", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "isLibraryReference", "", "ref", "Lcom/intellij/psi/PsiReference;", "kotlin.code-insight.inspections.shared"})
public abstract class SimpleAddKotlinLibraryQuickFixProvider
extends AddKotlinLibraryQuickFixProvider {
    @NotNull
    private final Set<String> namesToCheck;

    public SimpleAddKotlinLibraryQuickFixProvider(@NotNull String libraryGroupId, @NotNull String libraryArtifactId, @NotNull Set<String> namesToCheck) {
        Intrinsics.checkNotNullParameter((Object)libraryGroupId, (String)"libraryGroupId");
        Intrinsics.checkNotNullParameter((Object)libraryArtifactId, (String)"libraryArtifactId");
        Intrinsics.checkNotNullParameter(namesToCheck, (String)"namesToCheck");
        super(libraryGroupId, libraryArtifactId);
        this.namesToCheck = namesToCheck;
    }

    @Override
    protected boolean isLibraryReference(@NotNull PsiReference ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        PsiElement psiElement2 = ref.getElement();
        KtReferenceExpression ktReferenceExpression = psiElement2 instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement2 : null;
        if (ktReferenceExpression == null) {
            return false;
        }
        KtReferenceExpression referenceExpression = ktReferenceExpression;
        if (!this.namesToCheck.contains(referenceExpression.getText())) {
            return false;
        }
        return !(referenceExpression.getParent() instanceof KtQualifiedExpression);
    }
}

