/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.lineMarkers;

import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.NavigateAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.KotlinExpectActualLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.MarkersKt;
import org.jetbrains.kotlin.idea.codeInsight.lineMarkers.shared.NavigationPopupDescriptor;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerOptions;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0002J,\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e2\u0012\u0010\u0007\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\bH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinExpectActualLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "collectActualMarkers", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "collectExpectMarkers", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "getLineMarkerInfo", "element", "getName", "", "getOptions", "", "Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "()[Lcom/intellij/codeInsight/daemon/GutterIconDescriptor$Option;", "kotlin.code-insight.line-markers.k2"})
@SourceDebugExtension(value={"SMAP\nKotlinExpectActualLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinExpectActualLineMarkerProvider.kt\norg/jetbrains/kotlin/idea/codeInsight/lineMarkers/KotlinExpectActualLineMarkerProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,214:1\n1#2:215\n*E\n"})
public final class KotlinExpectActualLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        return KotlinBundle.message((String)"highlighter.name.expect.actual.line.markers", (Object[])new Object[0]);
    }

    @NotNull
    public GutterIconDescriptor.Option[] getOptions() {
        GutterIconDescriptor.Option[] optionArray = new GutterIconDescriptor.Option[]{KotlinLineMarkerOptions.INSTANCE.getExpectOption(), KotlinLineMarkerOptions.INSTANCE.getActualOption()};
        return optionArray;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (elements2.isEmpty()) {
            return;
        }
        boolean expectEnabled = KotlinLineMarkerOptions.INSTANCE.getExpectOption().isEnabled();
        boolean actualEnabled = KotlinLineMarkerOptions.INSTANCE.getActualOption().isEnabled();
        if (!expectEnabled && !actualEnabled) {
            return;
        }
        PsiElement first2 = (PsiElement)CollectionsKt.first(elements2);
        Project project2 = first2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (DumbService.Companion.getInstance(project2).isDumb()) {
            return;
        }
        for (PsiElement psiElement2 : elements2) {
            KtNamedDeclaration declaration2;
            if ((psiElement2 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement2 : null) == null) continue;
            declaration2 = declaration2;
            if (!expectEnabled || MarkersKt.isExpectDeclaration((KtDeclaration)declaration2) || !KotlinPsiUtils.isEffectivelyActual$default((KtDeclaration)declaration2, false, 1, null)) continue;
            this.collectExpectMarkers(declaration2, result2);
        }
        for (PsiElement psiElement3 : elements2) {
            KtNamedDeclaration declaration2;
            if ((psiElement3 instanceof KtNamedDeclaration ? (KtNamedDeclaration)psiElement3 : null) == null) continue;
            declaration2 = declaration2;
            if (!actualEnabled || !MarkersKt.isExpectDeclaration((KtDeclaration)declaration2)) continue;
            this.collectActualMarkers(declaration2, result2);
        }
    }

    private final boolean collectActualMarkers(KtNamedDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getActualOption();
        if (!gutter.isEnabled()) {
            return false;
        }
        if (MarkersKt.areMarkersForbidden$default(declaration2, null, 1, null)) {
            return false;
        }
        if (!PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)declaration2))) {
            KtClassOrObject ktClassOrObject = MarkersKt.containingClassOrObjectOrSelf((KtElement)declaration2);
            if (!(ktClassOrObject != null ? PsiUtilsKt.hasExpectModifier((KtModifierListOwner)((KtModifierListOwner)ktClassOrObject)) : false)) {
                return false;
            }
        }
        PsiElement anchor = MarkersKt.getExpectOrActualAnchor(declaration2);
        KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(anchor);
        Collection<Object> navigatableActualDeclarations = ktDeclaration != null ? MarkersKt.allNavigatableActualDeclarations(ktDeclaration) : null;
        Collection<SmartPsiElementPointer<KtDeclaration>> collection = navigatableActualDeclarations;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        GutterIconNavigationHandler navigationHandler = (arg_0, arg_1) -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$1(navigatableActualDeclarations, arg_0, arg_1);
        TextRange textRange = anchor.getTextRange();
        Icon icon2 = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon2);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon2, arg_0 -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$2((Function1)new Function1<PsiElement, String>(navigatableActualDeclarations){
            final /* synthetic */ Collection<SmartPsiElementPointer<KtDeclaration>> $navigatableActualDeclarations;
            {
                this.$navigatableActualDeclarations = $navigatableActualDeclarations;
                super(1);
            }

            public final String invoke(PsiElement el) {
                String string;
                Intrinsics.checkNotNull((Object)el);
                KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(el);
                if (ktDeclaration != null) {
                    KtDeclaration ktDeclaration2 = ktDeclaration;
                    Collection<SmartPsiElementPointer<KtDeclaration>> collection = this.$navigatableActualDeclarations;
                    KtDeclaration it = ktDeclaration2;
                    boolean bl = false;
                    string = KotlinExpectActualLineMarkerProviderKt.actualTooltip(collection);
                } else {
                    string = null;
                }
                return string;
            }
        }, arg_0), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)navigationHandler, navigatableActualDeclarations){
            final /* synthetic */ GutterIconNavigationHandler<PsiElement> $navigationHandler;
            final /* synthetic */ Collection<SmartPsiElementPointer<KtDeclaration>> $navigatableActualDeclarations;
            {
                this.$navigationHandler = $navigationHandler;
                this.$navigatableActualDeclarations = $navigatableActualDeclarations;
            }

            public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                this.$navigationHandler.navigate(e, elt);
            }

            @Nullable
            public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                return KotlinExpectActualLineMarkerProviderKt.buildNavigateToActualDeclarationsPopup(element3, this.$navigatableActualDeclarations);
            }
        }, GutterIconRenderer.Alignment.RIGHT, () -> KotlinExpectActualLineMarkerProvider.collectActualMarkers$lambda$3(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message((String)"highlighter.action.text.go.to.actual.declarations", (Object[])new Object[0]), (String)"GotoImplementation");
        result2.add(lineMarkerInfo2);
        return true;
    }

    private final boolean collectExpectMarkers(KtNamedDeclaration declaration2, Collection<? super LineMarkerInfo<?>> result2) {
        GutterIconDescriptor.Option gutter = KotlinLineMarkerOptions.INSTANCE.getExpectOption();
        if (!gutter.isEnabled()) {
            return false;
        }
        if (MarkersKt.areMarkersForbidden$default(declaration2, null, 1, null)) {
            return false;
        }
        if (!PsiUtilsKt.hasActualModifier((KtModifierListOwner)((KtModifierListOwner)declaration2))) {
            return false;
        }
        if (!MarkersKt.hasExpectForActual((KtDeclaration)declaration2)) {
            return false;
        }
        PsiElement anchor = MarkersKt.getExpectOrActualAnchor(declaration2);
        KtDeclaration ktDeclaration = MarkersKt.getMarkerDeclaration(anchor);
        List<SmartPsiElementPointer<KtDeclaration>> navigatableExpectedDeclarations = ktDeclaration != null ? MarkersKt.allNavigatableExpectedDeclarations(ktDeclaration) : null;
        GutterIconNavigationHandler navigationHandler = (arg_0, arg_1) -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$4(navigatableExpectedDeclarations, arg_0, arg_1);
        TextRange textRange = anchor.getTextRange();
        Icon icon2 = gutter.getIcon();
        Intrinsics.checkNotNull((Object)icon2);
        LineMarkerInfo lineMarkerInfo2 = new LineMarkerInfo(anchor, textRange, icon2, arg_0 -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$5((Function1)new Function1<PsiElement, String>(navigatableExpectedDeclarations){
            final /* synthetic */ List<SmartPsiElementPointer<KtDeclaration>> $navigatableExpectedDeclarations;
            {
                this.$navigatableExpectedDeclarations = $navigatableExpectedDeclarations;
                super(1);
            }

            public final String invoke(PsiElement el) {
                Intrinsics.checkNotNull((Object)el);
                return MarkersKt.getMarkerDeclaration(el) != null ? KotlinExpectActualLineMarkerProviderKt.expectTooltip((Collection<? extends SmartPsiElementPointer<KtDeclaration>>)this.$navigatableExpectedDeclarations) : null;
            }
        }, arg_0), (GutterIconNavigationHandler)new GutterIconNavigationHandler<PsiElement>((GutterIconNavigationHandler<PsiElement>)navigationHandler, navigatableExpectedDeclarations){
            final /* synthetic */ GutterIconNavigationHandler<PsiElement> $navigationHandler;
            final /* synthetic */ List<SmartPsiElementPointer<KtDeclaration>> $navigatableExpectedDeclarations;
            {
                this.$navigationHandler = $navigationHandler;
                this.$navigatableExpectedDeclarations = $navigatableExpectedDeclarations;
            }

            public void navigate(@Nullable MouseEvent e, @Nullable PsiElement elt) {
                this.$navigationHandler.navigate(e, elt);
            }

            @Nullable
            public NavigationPopupDescriptor getTargetsPopupDescriptor(@Nullable PsiElement element3) {
                return KotlinExpectActualLineMarkerProviderKt.buildNavigateToExpectedDeclarationsPopup(element3, this.$navigatableExpectedDeclarations);
            }
        }, GutterIconRenderer.Alignment.RIGHT, () -> KotlinExpectActualLineMarkerProvider.collectExpectMarkers$lambda$6(gutter));
        NavigateAction.setNavigateAction((LineMarkerInfo)lineMarkerInfo2, (String)KotlinBundle.message((String)"highlighter.action.text.go.to.expected.declaration", (Object[])new Object[0]), null);
        result2.add(lineMarkerInfo2);
        return true;
    }

    private static final void collectActualMarkers$lambda$1(Collection $navigatableActualDeclarations, MouseEvent e, PsiElement element3) {
        block1: {
            MouseEvent mouseEvent = e;
            if (mouseEvent == null) break block1;
            MouseEvent it = mouseEvent;
            boolean bl = false;
            NavigationPopupDescriptor navigationPopupDescriptor = KotlinExpectActualLineMarkerProviderKt.buildNavigateToActualDeclarationsPopup(element3, $navigatableActualDeclarations);
            if (navigationPopupDescriptor != null) {
                navigationPopupDescriptor.showPopup(e);
            }
        }
    }

    private static final String collectActualMarkers$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String collectActualMarkers$lambda$3(GutterIconDescriptor.Option $gutter) {
        Intrinsics.checkNotNullParameter((Object)$gutter, (String)"$gutter");
        return $gutter.getName();
    }

    private static final void collectExpectMarkers$lambda$4(List $navigatableExpectedDeclarations, MouseEvent e, PsiElement element3) {
        block1: {
            if (e == null) break block1;
            NavigationPopupDescriptor navigationPopupDescriptor = KotlinExpectActualLineMarkerProviderKt.buildNavigateToExpectedDeclarationsPopup(element3, $navigatableExpectedDeclarations);
            if (navigationPopupDescriptor != null) {
                navigationPopupDescriptor.showPopup(e);
            }
        }
    }

    private static final String collectExpectMarkers$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String collectExpectMarkers$lambda$6(GutterIconDescriptor.Option $gutter) {
        Intrinsics.checkNotNullParameter((Object)$gutter, (String)"$gutter");
        return $gutter.getName();
    }
}

