/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

public class KotlinDeclarationMover
extends AbstractKotlinUpDownMover {
    private boolean moveEnumConstant = false;
    private boolean moveOutOfBlock = false;
    private boolean moveIntoBlock = false;
    private static final Class[] DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtAnonymousInitializer.class, KtFunction.class, KtPropertyAccessor.class, KtFile.class};
    private static final Class[] CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES = new Class[]{KtClassBody.class, KtFile.class};

    private static int findNearestNonWhitespace(@NotNull CharSequence sequence2, int index) {
        if (sequence2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(0);
        }
        char ch = sequence2.charAt(--index);
        while (Character.isWhitespace(ch)) {
            ch = sequence2.charAt(--index);
        }
        return index;
    }

    public void afterMove(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(2);
        }
        if (info2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(3);
        }
        super.afterMove(editor2, file2, info2, down);
        Document document = editor2.getDocument();
        if (this.moveEnumConstant) {
            int end2;
            char c2;
            int end1;
            CharSequence cs = document.getCharsSequence();
            char c1 = cs.charAt(end1 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info2.range1.getEndOffset()));
            if (c1 == (c2 = cs.charAt(end2 = KotlinDeclarationMover.findNearestNonWhitespace(cs, info2.range2.getEndOffset()))) || c1 != ',' && c2 != ',') {
                return;
            }
            if (c1 == ';' || c2 == ';') {
                document.replaceString(end1, end1 + 1, (CharSequence)String.valueOf(c2));
                document.replaceString(end2, end2 + 1, (CharSequence)String.valueOf(c1));
            } else if (c1 == ',') {
                document.deleteString(end1, end1 + 1);
                document.insertString(end2 + 1, (CharSequence)",");
            } else {
                document.deleteString(end2, end2 + 1);
                document.insertString(end1 + 1, (CharSequence)",");
            }
        }
        if (this.moveIntoBlock || this.moveOutOfBlock) {
            if (down) {
                if (this.moveIntoBlock) {
                    document.deleteString(info2.range1.getEndOffset(), info2.range2.getStartOffset());
                } else {
                    int offset2 = info2.range1.getEndOffset();
                    document.insertString(offset2, (CharSequence)"\n");
                    CaretModel caretModel = editor2.getCaretModel();
                    if (document.getCharsSequence().charAt(caretModel.getOffset() - 1) == '\n') {
                        caretModel.moveToOffset(offset2 + 1);
                    }
                }
            } else if (this.moveIntoBlock) {
                document.deleteString(info2.range2.getEndOffset(), info2.range1.getStartOffset());
            } else {
                document.insertString(info2.range2.getEndOffset(), (CharSequence)"\n");
            }
        }
    }

    @NotNull
    private static List<PsiElement> getDeclarationAnchors(@NotNull KtDeclaration declaration2) {
        PsiElement nameIdentifier;
        if (declaration2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(4);
        }
        final ArrayList<PsiElement> memberSuspects = new ArrayList<PsiElement>();
        KtModifierList modifierList = declaration2.getModifierList();
        if (modifierList != null) {
            memberSuspects.add((PsiElement)modifierList);
        }
        if (declaration2 instanceof KtNamedDeclaration && (nameIdentifier = ((KtNamedDeclaration)declaration2).getNameIdentifier()) != null) {
            memberSuspects.add(nameIdentifier);
        }
        declaration2.accept((PsiElementVisitor)new KtVisitorVoid(){

            public void visitClassInitializer(@NotNull KtClassInitializer initializer2) {
                PsiElement brace;
                if (initializer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((brace = initializer2.getOpenBraceNode()) != null) {
                    memberSuspects.add(brace);
                }
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                KtTypeParameterList typeParameterList;
                PsiElement equalsToken;
                if (function2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((equalsToken = function2.getEqualsToken()) != null) {
                    memberSuspects.add(equalsToken);
                }
                if ((typeParameterList = function2.getTypeParameterList()) != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = function2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = function2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            public void visitProperty(@NotNull KtProperty property2) {
                KtTypeReference returnTypeRef;
                KtTypeReference receiverTypeRef;
                if (property2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiElement valOrVarKeyword = property2.getValOrVarKeyword();
                memberSuspects.add(valOrVarKeyword);
                KtTypeParameterList typeParameterList = property2.getTypeParameterList();
                if (typeParameterList != null) {
                    memberSuspects.add(typeParameterList);
                }
                if ((receiverTypeRef = property2.getReceiverTypeReference()) != null) {
                    memberSuspects.add(receiverTypeRef);
                }
                if ((returnTypeRef = property2.getTypeReference()) != null) {
                    memberSuspects.add(returnTypeRef);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "initializer";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClassInitializer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNamedFunction";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<PsiElement> arrayList = memberSuspects;
        if (arrayList == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static KtDeclaration getMovableDeclaration(@Nullable PsiElement element3) {
        KtLambdaExpression lambda2;
        KtFunction function2;
        if (element3 == null) {
            return null;
        }
        if (KotlinDeclarationMover.getParentFileAnnotationEntry(element3) != null) {
            return null;
        }
        KtDeclaration declaration2 = null;
        if (element3.getNode().getElementType() == KtTokens.LBRACE && (function2 = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)(lambda2 = (KtLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtLambdaExpression.class, (boolean)true)), KtFunction.class, (boolean)true)) != null && function2.getBodyExpression() == lambda2) {
            declaration2 = function2;
        }
        if (declaration2 == null) {
            declaration2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element3, KtDeclaration.class, (boolean)false);
        }
        if (declaration2 instanceof KtParameter) {
            return null;
        }
        if (declaration2 instanceof KtTypeParameter) {
            return KotlinDeclarationMover.getMovableDeclaration(declaration2.getParent());
        }
        return PsiTreeUtil.instanceOf((Object)PsiTreeUtil.getParentOfType((PsiElement)declaration2, (Class[])DECLARATION_CONTAINER_CLASSES), (Class[])CLASSBODYLIKE_DECLARATION_CONTAINER_CLASSES) ? declaration2 : null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(6);
        }
        return element3 instanceof KtDeclaration;
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull LineRange oldRange) {
        PsiElement last2;
        PsiElement first2;
        if (element3 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(7);
        }
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(8);
        }
        if (oldRange == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(9);
        }
        if (element3 instanceof KtDeclaration) {
            first2 = element3.getFirstChild();
            last2 = element3.getLastChild();
            if (first2 == null || last2 == null) {
                return null;
            }
        } else {
            first2 = last2 = element3;
        }
        TextRange textRange1 = first2.getTextRange();
        TextRange textRange2 = last2.getTextRange();
        Document doc = editor2.getDocument();
        if (doc.getTextLength() < textRange2.getEndOffset()) {
            return null;
        }
        int startLine = editor2.offsetToLogicalPosition((int)textRange1.getStartOffset()).line;
        int endLine = editor2.offsetToLogicalPosition((int)textRange2.getEndOffset()).line + 1;
        if (element3 instanceof PsiComment || startLine == oldRange.startLine || startLine == oldRange.endLine || endLine == oldRange.startLine || endLine == oldRange.endLine) {
            return new LineRange(startLine, endLine);
        }
        int lineCount = doc.getLineCount();
        if (oldRange.startLine >= lineCount || oldRange.endLine >= lineCount) {
            return null;
        }
        TextRange lineTextRange = new TextRange(doc.getLineStartOffset(oldRange.startLine), doc.getLineEndOffset(oldRange.endLine));
        if (element3 instanceof KtDeclaration) {
            for (PsiElement anchor : KotlinDeclarationMover.getDeclarationAnchors((KtDeclaration)element3)) {
                TextRange suspectTextRange = anchor.getTextRange();
                if (suspectTextRange == null || !lineTextRange.intersects(suspectTextRange)) continue;
                return new LineRange(startLine, endLine);
            }
        }
        return null;
    }

    @Nullable
    private static LineRange getTargetRange(@NotNull Editor editor2, @NotNull PsiElement sibling, boolean down, @NotNull PsiElement target2) {
        KtClassBody nextParent;
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(10);
        }
        if (sibling == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(12);
        }
        PsiElement start2 = sibling;
        PsiElement end = sibling;
        if (KotlinDeclarationMover.isMovingOutOfBlock(sibling, down)) {
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtClassBody)) {
                return null;
            }
            if (target2 instanceof KtEnumEntry) {
                return null;
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)parent2.getParent();
            assert (ktClassOrObject != null);
            nextParent = ktClassOrObject.getParent();
            if (!down) {
                start2 = ktClassOrObject;
            }
        } else {
            KtClassBody classBody;
            nextParent = classBody = KotlinDeclarationMover.getClassBody(sibling);
            if (classBody != null) {
                if (!down) {
                    start2 = classBody.getRBrace();
                }
                PsiElement psiElement2 = end = down ? classBody.getLBrace() : classBody.getRBrace();
            }
        }
        if (nextParent != null) {
            if (target2 instanceof KtAnonymousInitializer && !(nextParent instanceof KtClassBody)) {
                return null;
            }
            if (target2 instanceof KtEnumEntry) {
                KtClassOrObject nextClassOrObject = (KtClassOrObject)nextParent.getParent();
                assert (nextClassOrObject != null);
                if (!nextClassOrObject.hasModifier(KtTokens.ENUM_KEYWORD)) {
                    return null;
                }
            }
        }
        if (target2 instanceof KtPropertyAccessor && !(sibling instanceof KtPropertyAccessor)) {
            return null;
        }
        return start2 != null && end != null ? new LineRange(start2, end, editor2.getDocument()) : null;
    }

    private static boolean isMovingOutOfBlock(@NotNull PsiElement sibling, boolean down) {
        if (sibling == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(13);
        }
        return sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE);
    }

    @Nullable
    private static KtClassBody getClassBody(PsiElement element3) {
        if (element3 instanceof KtClassOrObject) {
            return ((KtClassOrObject)element3).getBody();
        }
        return null;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        if (editor2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(15);
        }
        if (info2 == null) {
            KotlinDeclarationMover.$$$reportNull$$$0(16);
        }
        if (!super.checkAvailable(editor2, file2, info2, down)) {
            return false;
        }
        LineRange oldRange = info2.toMove;
        Pair psiRange = KotlinDeclarationMover.getElementRange((Editor)editor2, (PsiFile)file2, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        KtDeclaration firstDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getFirst());
        if (firstDecl == null) {
            return false;
        }
        this.moveEnumConstant = firstDecl instanceof KtEnumEntry;
        KtDeclaration lastDecl = KotlinDeclarationMover.getMovableDeclaration((PsiElement)psiRange.getSecond());
        if (lastDecl == null) {
            return false;
        }
        LineRange sourceRange = this.getSourceRange((PsiElement)firstDecl, (PsiElement)lastDecl, editor2, oldRange);
        if (sourceRange == null) {
            return false;
        }
        PsiElement sibling = KotlinDeclarationMover.getLastNonWhiteSiblingInLine(KotlinDeclarationMover.firstNonWhiteSibling(sourceRange, down), editor2, down);
        if (sibling == null || sibling instanceof KtPackageDirective || sibling instanceof KtImportList) {
            info2.toMove2 = null;
            return true;
        }
        this.moveOutOfBlock = KotlinDeclarationMover.isMovingOutOfBlock(sibling, down);
        this.moveIntoBlock = KotlinDeclarationMover.getClassBody(sibling) != null;
        info2.toMove = sourceRange;
        info2.toMove2 = KotlinDeclarationMover.getTargetRange(editor2, sibling, down, sourceRange.firstElement);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinDeclarationMover";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationAnchors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNearestNonWhitespace";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "afterMove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationAnchors";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMovingOutOfBlock";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

