/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ReflectionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013J\"\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0013H\u0014J\b\u0010\u001b\u001a\u00020\fH\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n8\bX\u0089\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "", "element", "(Lcom/intellij/psi/PsiElement;)V", "getElement", "()Lcom/intellij/psi/PsiElement;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "isCrossLanguageFix", "", "()Z", "clone", "", "getFileModifierForPreview", "Lcom/intellij/codeInsight/intention/FileModifier;", "target", "Lcom/intellij/psi/PsiFile;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "isAvailableImpl", "startInWriteAction", "kotlin.code-insight.api"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nQuickFixActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuickFixActionBase.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,99:1\n73#2:100\n*S KotlinDebug\n*F\n+ 1 QuickFixActionBase.kt\norg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/QuickFixActionBase\n*L\n39#1:100\n*E\n"})
public abstract class QuickFixActionBase<T extends PsiElement>
implements IntentionAction,
Cloneable {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final SmartPsiElementPointer<T> elementPointer;
    private final boolean isCrossLanguageFix;

    public QuickFixActionBase(@NotNull T element3) {
        Intrinsics.checkNotNullParameter(element3, (String)"element");
        this.elementPointer = SmartPointersKt.createSmartPointer(element3);
    }

    @Nullable
    public final T getElement() {
        return (T)this.elementPointer.getElement();
    }

    public boolean isCrossLanguageFix() {
        return this.isCrossLanguageFix;
    }

    protected boolean isAvailableImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)true);
        }
        try {
            T t;
            if (this.getElement() == null) {
                boolean bl = false;
                return bl;
            }
            T element3 = t;
            boolean bl = element3.isValid() && !element3.getProject().isDisposed() && (file2.getManager().isInProject((PsiElement)file2) || file2 instanceof KtCodeFragment || file2 instanceof KtFile && ((KtFile)file2).isScript()) && (file2 instanceof KtFile || this.isCrossLanguageFix()) && this.isAvailableImpl(project2, editor2, file2);
            return bl;
        }
        finally {
            CreateByPatternKt.setCREATE_BY_PATTERN_MAY_NOT_REFORMAT((boolean)false);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target2) {
        QuickFixActionBase quickFixActionBase;
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        if (super.getFileModifierForPreview(target2) != this) {
            return null;
        }
        T oldElement = this.getElement();
        if (oldElement == null) {
            return null;
        }
        if (!Intrinsics.areEqual((Object)IntentionPreviewUtils.getOriginalFile((PsiFile)target2), (Object)oldElement.getContainingFile())) {
            throw new IllegalStateException("Intention action " + Reflection.getOrCreateKotlinClass(this.getClass()) + " (" + this.getFamilyName() + ") refers to the element from another source file. It's likely that it's going to modify a file not opened in the editor, so default preview strategy won't work. Also, if another file is modified, getElementToMakeWritable() must be properly implemented to denote the actual file to be modified.");
        }
        PsiElement newElement2 = PsiTreeUtil.findSameElementInCopy(oldElement, (PsiFile)target2);
        try {
            Object object = super.clone();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.QuickFixActionBase<*>");
            quickFixActionBase = (QuickFixActionBase)object;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
        QuickFixActionBase clone2 = quickFixActionBase;
        if (!ReflectionUtil.setField(QuickFixActionBase.class, (Object)clone2, SmartPsiElementPointer.class, (String)"elementPointer", (Object)SmartPointersKt.createSmartPointer((PsiElement)newElement2))) {
            return null;
        }
        return (FileModifier)clone2;
    }

    @NotNull
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

