/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineCallRequestorWrapper;", "Lcom/intellij/debugger/requests/ClassPrepareRequestor;", "originalRequestor", "line", "", "sourceCandidatesInternalName", "", "", "(Lcom/intellij/debugger/requests/ClassPrepareRequestor;ILjava/util/List;)V", "processClassPrepare", "", "debuggerProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "referenceType", "Lcom/sun/jdi/ReferenceType;", "kotlin.jvm-debugger.core"})
final class InlineCallRequestorWrapper
implements ClassPrepareRequestor {
    @NotNull
    private final ClassPrepareRequestor originalRequestor;
    private final int line;
    @NotNull
    private final List<String> sourceCandidatesInternalName;

    public InlineCallRequestorWrapper(@NotNull ClassPrepareRequestor originalRequestor, int line, @NotNull List<String> sourceCandidatesInternalName) {
        Intrinsics.checkNotNullParameter((Object)originalRequestor, (String)"originalRequestor");
        Intrinsics.checkNotNullParameter(sourceCandidatesInternalName, (String)"sourceCandidatesInternalName");
        this.originalRequestor = originalRequestor;
        this.line = line;
        this.sourceCandidatesInternalName = sourceCandidatesInternalName;
    }

    public void processClassPrepare(@Nullable DebugProcess debuggerProcess, @Nullable ReferenceType referenceType) {
        boolean hasInlinedLines;
        if (referenceType == null) {
            return;
        }
        boolean bl = hasInlinedLines = referenceType instanceof ReferenceTypeImpl ? ((ReferenceTypeImpl)referenceType).hasMappedLineTo("Kotlin", this.line, arg_0 -> InlineCallRequestorWrapper.processClassPrepare$lambda$0(this, arg_0)) : KotlinPositionManagerKt.access$fallbackHasInlinedLinesTo(referenceType, this.line, this.sourceCandidatesInternalName);
        if (hasInlinedLines) {
            this.originalRequestor.processClassPrepare(debuggerProcess, referenceType);
        }
    }

    private static final boolean processClassPrepare$lambda$0(InlineCallRequestorWrapper this$0, String path2) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)path2);
        return KotlinPositionManagerKt.access$sourcePathMatchesCandidates(path2, this$0.sourceCandidatesInternalName);
    }
}

