/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0002\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a!\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u000f*\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0017\u001a\f\u0010\u0018\u001a\u00020\u0012*\u00020\u0015H\u0002\u001a\u000e\u0010\u0019\u001a\u00020\u0012*\u0004\u0018\u00010\u0015H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u0012*\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000fH\u0000\"\"\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u0006\u0012\u0002\b\u00030\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001c"}, d2={"javaBreakpointProperties", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "getJavaBreakpointProperties", "(Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;)Lorg/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties;", "createLineSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl;", "getLambdaBreakpointTargets", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "position", "getLambdaByOrdinal", "ordinal", "", "(Lcom/intellij/debugger/SourcePosition;Ljava/lang/Integer;)Lorg/jetbrains/kotlin/psi/KtFunction;", "inTheMethod", "", "pos", "method", "Lcom/intellij/psi/PsiElement;", "getFirstLineWithExecutableCode", "(Lorg/jetbrains/kotlin/psi/KtFunction;)Ljava/lang/Integer;", "isClosingBraceInMethod", "isInlineOnlyDeclaration", "isSuitableLambdaBreakpointTarget", "line", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLineBreakpointType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointTypeKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,260:1\n766#2:261\n857#2,2:262\n*S KotlinDebug\n*F\n+ 1 KotlinLineBreakpointType.kt\norg/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointTypeKt\n*L\n232#1:261\n232#1:262,2\n*E\n"})
public final class KotlinLineBreakpointTypeKt {
    private static final JavaBreakpointProperties<?> getJavaBreakpointProperties(LineBreakpoint<?> $this$javaBreakpointProperties) {
        XBreakpoint xBreakpoint = $this$javaBreakpointProperties.getXBreakpoint();
        JavaBreakpointProperties javaBreakpointProperties = xBreakpoint != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
        return javaBreakpointProperties instanceof JavaBreakpointProperties ? javaBreakpointProperties : null;
    }

    private static final boolean isInlineOnlyDeclaration(PsiElement $this$isInlineOnlyDeclaration) {
        return $this$isInlineOnlyDeclaration instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)$this$isInlineOnlyDeclaration);
    }

    private static final boolean isClosingBraceInMethod(PsiElement $this$isClosingBraceInMethod) {
        if ($this$isClosingBraceInMethod instanceof LeafPsiElement && ((LeafPsiElement)$this$isClosingBraceInMethod).getNode().getElementType() == KtTokens.RBRACE) {
            PsiElement owner;
            PsiElement blockExpression2 = ((LeafPsiElement)$this$isClosingBraceInMethod).getParent();
            if (blockExpression2 instanceof KtFunctionLiteral) {
                return true;
            }
            if (blockExpression2 instanceof KtBlockExpression && ((owner = ((KtBlockExpression)blockExpression2).getParent()) instanceof KtFunction || owner instanceof KtClassInitializer)) {
                return true;
            }
        }
        return false;
    }

    private static final KtFunction getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        if (ordinal == null || ordinal < 0) {
            return null;
        }
        List lambdas2 = (List)ActionsKt.runReadAction((Function0)((Function0)new Function0<List<? extends KtFunction>>(position){
            final /* synthetic */ SourcePosition $position;
            {
                this.$position = $position;
                super(0);
            }

            @NotNull
            public final List<KtFunction> invoke() {
                PsiElement targetElement = this.$position.getElementAt();
                if (targetElement == null || !targetElement.isValid()) {
                    return CollectionsKt.emptyList();
                }
                return KotlinLineBreakpointTypeKt.access$getLambdaBreakpointTargets(this.$position);
            }
        }));
        return (KtFunction)CollectionsKt.getOrNull((List)lambdas2, (int)ordinal);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<KtFunction> getLambdaBreakpointTargets(SourcePosition position) {
        void $this$filterTo$iv$iv;
        List<KtFunction> allLambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position);
        int line = position.getLine();
        Iterable $this$filter$iv = allLambdas;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            boolean bl = false;
            if (!KotlinLineBreakpointTypeKt.isSuitableLambdaBreakpointTarget(it, line)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isSuitableLambdaBreakpointTarget(@NotNull KtFunction $this$isSuitableLambdaBreakpointTarget, int line) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuitableLambdaBreakpointTarget, (String)"<this>");
        if (Registry.is((String)"debugger.kotlin.multiline.lambda.breakpoints")) return true;
        if (PsiLinesUtilsKt.isOneLiner((PsiElement)$this$isSuitableLambdaBreakpointTarget)) return true;
        Integer n = KotlinLineBreakpointTypeKt.getFirstLineWithExecutableCode($this$isSuitableLambdaBreakpointTarget);
        int n2 = line;
        if (n == null) return false;
        if (n != n2) return false;
        return true;
    }

    private static final Integer getFirstLineWithExecutableCode(KtFunction $this$getFirstLineWithExecutableCode) {
        KtBlockExpression ktBlockExpression = $this$getFirstLineWithExecutableCode.getBodyBlockExpression();
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression bodyExpression = ktBlockExpression;
        KtExpression ktExpression = bodyExpression.getFirstStatement();
        if (ktExpression == null) {
            return null;
        }
        KtExpression first2 = ktExpression;
        return PsiLinesUtilsKt.getLineNumber$default((PsiElement)first2, false, 1, null);
    }

    public static final boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiElement psiElement2 = pos.getElementAt();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement elem = psiElement2;
        PsiElement topmostElement = KotlinPsiUtils.getTopmostElementAtOffset(elem, elem.getTextRange().getStartOffset());
        return Comparing.equal((Object)KotlinPositionManagerKt.getContainingMethod$default(topmostElement, false, 1, null), (Object)method);
    }

    private static final SourcePosition createLineSourcePosition(XLineBreakpointImpl<?> breakpoint2) {
        VirtualFile virtualFile2 = breakpoint2.getFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        PsiManager psiManager = PsiManager.getInstance((Project)breakpoint2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        PsiFile psiFile2 = (PsiFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<PsiFile>(psiManager2, file2){
            final /* synthetic */ PsiManager $psiManager;
            final /* synthetic */ VirtualFile $file;
            {
                this.$psiManager = $psiManager;
                this.$file = $file;
                super(0);
            }

            @Nullable
            public final PsiFile invoke() {
                return this.$psiManager.findFile(this.$file);
            }
        }));
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        return SourcePosition.createFromLine((PsiFile)psiFile3, (int)breakpoint2.getLine());
    }

    public static final /* synthetic */ JavaBreakpointProperties access$getJavaBreakpointProperties(LineBreakpoint $receiver) {
        return KotlinLineBreakpointTypeKt.getJavaBreakpointProperties($receiver);
    }

    public static final /* synthetic */ boolean access$isInlineOnlyDeclaration(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isInlineOnlyDeclaration($receiver);
    }

    public static final /* synthetic */ boolean access$isClosingBraceInMethod(PsiElement $receiver) {
        return KotlinLineBreakpointTypeKt.isClosingBraceInMethod($receiver);
    }

    public static final /* synthetic */ List access$getLambdaBreakpointTargets(SourcePosition position) {
        return KotlinLineBreakpointTypeKt.getLambdaBreakpointTargets(position);
    }

    public static final /* synthetic */ SourcePosition access$createLineSourcePosition(XLineBreakpointImpl breakpoint2) {
        return KotlinLineBreakpointTypeKt.createLineSourcePosition(breakpoint2);
    }

    public static final /* synthetic */ KtFunction access$getLambdaByOrdinal(SourcePosition position, Integer ordinal) {
        return KotlinLineBreakpointTypeKt.getLambdaByOrdinal(position, ordinal);
    }
}

