/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.KotlinFunctionBreakpointKt;
import org.jetbrains.kotlin.idea.debugger.core.breakpoints.SourcePositionRefiner;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0017J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0012\u0010\u0011\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint;", "Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/SourcePositionRefiner;", "project", "Lcom/intellij/openapi/project/Project;", "breakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "getPsiClass", "Lcom/intellij/psi/PsiClass;", "invalidateMethodData", "", "refineSourcePosition", "Lcom/intellij/debugger/SourcePosition;", "sourcePosition", "reload", "updateClassPattern", "updateMethodData", "descriptor", "Lcom/intellij/debugger/ui/breakpoints/MethodBreakpoint$MethodDescriptor;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinFunctionBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,204:1\n67#2:205\n78#3:206\n73#3:207\n*S KotlinDebug\n*F\n+ 1 KotlinFunctionBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinFunctionBreakpoint\n*L\n66#1:205\n116#1:206\n116#1:207\n*E\n"})
public class KotlinFunctionBreakpoint
extends MethodBreakpoint
implements SourcePositionRefiner {
    public KotlinFunctionBreakpoint(@NotNull Project project2, @NotNull XBreakpoint<?> breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        super(project2, breakpoint2);
    }

    @Nullable
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition2 = this.getSourcePosition();
        KtClassOrObject ktClassOrObject = (KtClassOrObject)PositionUtil.getPsiElementAt((Project)this.myProject, KtClassOrObject.class, (SourcePosition)sourcePosition2);
        if (ktClassOrObject == null) {
            return null;
        }
        KtClassOrObject declaration2 = ktClassOrObject;
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        return (PsiClass)DumbService.Companion.getInstance(project2).runReadActionInSmartMode(() -> KotlinFunctionBreakpoint.getPsiClass$lambda$0(declaration2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SourcePosition refineSourcePosition(@NotNull SourcePosition sourcePosition2) {
        PsiElement psiElement2;
        block7: {
            block6: {
                void $this$parentOfType$iv;
                Intrinsics.checkNotNullParameter((Object)sourcePosition2, (String)"sourcePosition");
                psiElement2 = sourcePosition2.getElementAt();
                if (psiElement2 == null) break block6;
                PsiElement psiElement3 = psiElement2;
                boolean withSelf$iv = true;
                boolean $i$f$parentOfType = false;
                psiElement2 = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtDeclaration.class, (boolean)false);
                if (psiElement2 != null) break block7;
            }
            return sourcePosition2;
        }
        PsiElement declaration2 = psiElement2;
        if (KotlinPsiUtils.isExpectDeclaration((KtDeclaration)declaration2)) {
            KtDeclaration ktDeclaration = KotlinFunctionBreakpointKt.access$getActualJvmDeclaration((KtDeclaration)declaration2);
            if (ktDeclaration == null) {
                return sourcePosition2;
            }
            KtDeclaration actualDeclaration = ktDeclaration;
            SourcePosition sourcePosition3 = SourcePosition.createFromElement((PsiElement)((PsiElement)actualDeclaration));
            if (sourcePosition3 == null) {
                sourcePosition3 = sourcePosition2;
            }
            return sourcePosition3;
        }
        return sourcePosition2;
    }

    @RequiresBackgroundThread
    public void reload() {
        MethodBreakpoint.MethodDescriptor methodDescriptor;
        super.reload();
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            if (DumbService.Companion.isDumb(project2)) {
                return;
            }
        }
        this.invalidateMethodData();
        SourcePosition sourcePosition2 = this.getSourcePosition();
        if (sourcePosition2 != null) {
            Project project3 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
            methodDescriptor = KotlinFunctionBreakpointKt.getMethodDescriptor(sourcePosition2, project3);
        } else {
            methodDescriptor = null;
        }
        MethodBreakpoint.MethodDescriptor descriptor2 = methodDescriptor;
        ProgressIndicatorProvider.checkCanceled();
        this.updateMethodData(descriptor2);
        this.updateClassPattern();
    }

    private final void invalidateMethodData() {
        this.setMethodName(null);
        this.mySignature = null;
    }

    private final void updateMethodData(MethodBreakpoint.MethodDescriptor descriptor2) {
        MethodBreakpoint.MethodDescriptor methodDescriptor = descriptor2;
        this.setMethodName(methodDescriptor != null ? methodDescriptor.methodName : null);
        MethodBreakpoint.MethodDescriptor methodDescriptor2 = descriptor2;
        Object object = this.mySignature = methodDescriptor2 != null ? methodDescriptor2.methodSignature : null;
        if (descriptor2 != null && descriptor2.isStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void updateClassPattern() {
        ProgressIndicatorProvider.checkCanceled();
        Project project2 = this.myProject;
        String string = KotlinDebuggerCoreBundle.message("function.breakpoint.initialize", new Object[0]);
        Task.Backgroundable task2 = new Task.Backgroundable(this, project2, string){
            final /* synthetic */ KotlinFunctionBreakpoint this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                PsiClass psiClass2 = this.this$0.getPsiClass();
                if (psiClass2 != null) {
                    KotlinFunctionBreakpoint.access$getProperties((KotlinFunctionBreakpoint)this.this$0).myClassPattern = (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(psiClass2){
                        final /* synthetic */ PsiClass $psiClass;
                        {
                            this.$psiClass = $psiClass;
                            super(0);
                        }

                        @Nullable
                        public final String invoke() {
                            return this.$psiClass.getQualifiedName();
                        }
                    }));
                }
            }
        };
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        boolean $i$f$isDispatchThread = false;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                progressManager2.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
                return;
            }
        }
        EmptyProgressIndicator progressIndicator = new EmptyProgressIndicator();
        progressManager2.runProcess(() -> KotlinFunctionBreakpoint.updateClassPattern$lambda$1(task2, progressIndicator), (ProgressIndicator)progressIndicator);
    }

    private static final KtLightClass getPsiClass$lambda$0(KtClassOrObject $declaration) {
        Intrinsics.checkNotNullParameter((Object)$declaration, (String)"$declaration");
        return LightClassUtilsKt.toLightClass((KtClassOrObject)$declaration);
    }

    private static final void updateClassPattern$lambda$1(updateClassPattern.task.1 $task, EmptyProgressIndicator $progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)((Object)$task), (String)"$task");
        Intrinsics.checkNotNullParameter((Object)$progressIndicator, (String)"$progressIndicator");
        $task.run((ProgressIndicator)$progressIndicator);
    }

    public static final /* synthetic */ JavaMethodBreakpointProperties access$getProperties(KotlinFunctionBreakpoint $this) {
        return (JavaMethodBreakpointProperties)$this.getProperties();
    }
}

