/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.util.DeclarationUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u001c\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinLineBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/LineBreakpoint;", "Lorg/jetbrains/java/debugger/breakpoints/properties/JavaLineBreakpointProperties;", "project", "Lcom/intellij/openapi/project/Project;", "xBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/breakpoints/XBreakpoint;)V", "canHaveTargetLine", "", "classType", "Lcom/sun/jdi/ReferenceType;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "computeMethodName", "", "processClassPrepare", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinLineBreakpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinLineBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinLineBreakpoint\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,73:1\n146#2:74\n*S KotlinDebug\n*F\n+ 1 KotlinLineBreakpoint.kt\norg/jetbrains/kotlin/idea/debugger/core/breakpoints/KotlinLineBreakpoint\n*L\n69#1:74\n*E\n"})
public final class KotlinLineBreakpoint
extends LineBreakpoint<JavaLineBreakpointProperties> {
    public KotlinLineBreakpoint(@Nullable Project project2, @Nullable XBreakpoint<? extends XBreakpointProperties<?>> xBreakpoint) {
        super(project2, xBreakpoint, false);
    }

    public void processClassPrepare(@Nullable DebugProcess debugProcess, @Nullable ReferenceType classType2) {
        XSourcePosition sourcePosition2 = (XSourcePosition)ActionsKt.runReadAction((Function0)((Function0)new Function0<XSourcePosition>(this){
            final /* synthetic */ KotlinLineBreakpoint this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final XSourcePosition invoke() {
                XBreakpoint xBreakpoint = this.this$0.getXBreakpoint();
                return xBreakpoint != null ? xBreakpoint.getSourcePosition() : null;
            }
        }));
        if (classType2 != null && sourcePosition2 != null && !this.canHaveTargetLine(classType2, sourcePosition2)) {
            return;
        }
        super.processClassPrepare(debugProcess, classType2);
    }

    private final boolean canHaveTargetLine(ReferenceType classType2, XSourcePosition sourcePosition2) {
        List list2 = DebuggerUtilsEx.allLineLocations((ReferenceType)classType2);
        if (list2 == null) {
            return false;
        }
        List allLineLocations = list2;
        String string = sourcePosition2.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        int lineNumber = sourcePosition2.getLine() + 1;
        for (Location location2 : allLineLocations) {
            Intrinsics.checkNotNull((Object)location2);
            String kotlinFileName = SafeUtilKt.safeSourceName(location2, "Kotlin");
            int kotlinLineNumber = location2.lineNumber("Kotlin");
            if (!(kotlinFileName != null ? Intrinsics.areEqual((Object)kotlinFileName, (Object)fileName) && kotlinLineNumber == lineNumber : Intrinsics.areEqual((Object)SafeUtilKt.safeSourceName(location2), (Object)fileName) && location2.lineNumber() == lineNumber)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected String computeMethodName() {
        String string = (String)ReadAction.compute(() -> KotlinLineBreakpoint.computeMethodName$lambda$0(this));
        if (string == null) {
            string = super.computeMethodName();
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String computeMethodName$lambda$0(KotlinLineBreakpoint this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        SourcePosition sourcePosition2 = this$0.getSourcePosition();
        SourcePosition sourcePosition3 = sourcePosition2;
        if (sourcePosition2 == null) return null;
        PsiElement psiElement2 = sourcePosition3.getElementAt();
        sourcePosition3 = psiElement2;
        if (psiElement2 == null) return null;
        SourcePosition $this$getNonStrictParentOfType$iv = sourcePosition3;
        boolean $i$f$getNonStrictParentOfType = false;
        KtElement ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtElement.class, (boolean)false);
        sourcePosition3 = ktElement;
        if (ktElement == null) return null;
        KtDeclaration ktDeclaration = DeclarationUtilKt.containingNonLocalDeclaration((KtElement)sourcePosition3);
        sourcePosition3 = ktDeclaration;
        if (ktDeclaration == null) return null;
        String string = sourcePosition3.getName();
        return string;
    }
}

