/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.LightOrRealThreadInfo;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendOtherThreadsRequestor;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.CustomProcessingLocatableEventRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.SteppingBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.core.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacility;
import org.jetbrains.kotlin.idea.debugger.core.stepping.CoroutineBreakpointFacilityKt;
import org.jetbrains.kotlin.idea.debugger.core.stepping.DebuggerSteppingHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility;", "", "()V", "installCoroutineResumedBreakpoint", "", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "resumedLocation", "Lcom/sun/jdi/Location;", "nextCallAfterResume", "", "installResumeBreakpointInCallerMethod", "suspendContext", "installResumeBreakpointInCurrentMethod", "kotlin.jvm-debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineBreakpointFacility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n23#2:124\n*S KotlinDebug\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/CoroutineBreakpointFacility\n*L\n107#1:124\n*E\n"})
public final class CoroutineBreakpointFacility {
    @NotNull
    public static final CoroutineBreakpointFacility INSTANCE = new CoroutineBreakpointFacility();

    private CoroutineBreakpointFacility() {
    }

    public final boolean installResumeBreakpointInCurrentMethod(@NotNull SuspendContextImpl suspendContext) {
        Location location2;
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Location location3 = suspendContext.getLocation();
        if (location3 == null) {
            return false;
        }
        Location currentLocation = location3;
        List<Location> methodLineLocations = currentLocation.method().allLineLocations();
        if (methodLineLocations.size() > 2 && Intrinsics.areEqual((Object)methodLineLocations.get(methodLineLocations.size() - 2), (Object)currentLocation)) {
            StackFrameInterceptor stackFrameInterceptor = StackFrameInterceptor.Companion.getInstance();
            location2 = stackFrameInterceptor != null ? stackFrameInterceptor.callerLocation(suspendContext) : null;
        } else {
            location2 = currentLocation;
        }
        if (location2 == null) {
            return false;
        }
        Location resumeLocation = location2;
        int nextLocationAfterResumeIndex = DebuggerUtil.getLocationOfNextInstructionAfterResume(resumeLocation);
        return this.installCoroutineResumedBreakpoint(suspendContext, resumeLocation, nextLocationAfterResumeIndex);
    }

    public final boolean installResumeBreakpointInCallerMethod(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        Object object = StackFrameInterceptor.Companion.getInstance();
        if (object == null || (object = object.callerLocation(suspendContext)) == null) {
            return false;
        }
        Object resumeLocation = object;
        int nextLocationAfterResumeIndex = DebuggerUtil.getLocationOfNextInstructionAfterResume((Location)resumeLocation);
        return this.installCoroutineResumedBreakpoint(suspendContext, (Location)resumeLocation, nextLocationAfterResumeIndex);
    }

    private final boolean installCoroutineResumedBreakpoint(SuspendContextImpl context2, Location resumedLocation, int nextCallAfterResume) {
        DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getDebugProcess(...)");
        DebugProcessImpl debugProcess = debugProcessImpl;
        debugProcess.cancelRunToCursorBreakpoint();
        Project project2 = debugProcess.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project3 = project2;
        boolean suspendAll = context2.getSuspendPolicy() == 2;
        boolean useCoroutineIdFiltering = Registry.is((String)"debugger.filter.breakpoints.by.coroutine.id");
        Method method = SafeUtilKt.safeMethod(resumedLocation);
        if (method == null) {
            return false;
        }
        Method method2 = method;
        String string = method2.declaringType().name();
        String string2 = method2.name();
        String string3 = method2.signature();
        CustomProcessingLocatableEventRequestor breakpoint2 = new CustomProcessingLocatableEventRequestor(project3, debugProcess, useCoroutineIdFiltering, suspendAll, nextCallAfterResume, string, string2, string3){
            final /* synthetic */ DebugProcessImpl $debugProcess;
            final /* synthetic */ boolean $useCoroutineIdFiltering;
            final /* synthetic */ boolean $suspendAll;
            final /* synthetic */ int $nextCallAfterResume;
            {
                this.$debugProcess = $debugProcess;
                this.$useCoroutineIdFiltering = $useCoroutineIdFiltering;
                this.$suspendAll = $suspendAll;
                this.$nextCallAfterResume = $nextCallAfterResume;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $project);
            }

            protected boolean stopOnlyInBaseClass() {
                return true;
            }

            public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action2, @NotNull LocatableEvent event) {
                Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                boolean result2 = super.processLocatableEvent(action2, event);
                if (result2) {
                    this.$debugProcess.getRequestsManager().deleteRequest((Requestor)this);
                }
                if (this.$useCoroutineIdFiltering && this.$suspendAll) {
                    return result2;
                }
                if (!result2) {
                    return false;
                }
                SuspendContextImpl suspendContextImpl = action2.getSuspendContext();
                if (suspendContextImpl == null) {
                    return true;
                }
                SuspendContextImpl suspendContextImpl2 = suspendContextImpl;
                return this.scheduleStepOverCommandForSuspendSwitch(suspendContextImpl2, this.$nextCallAfterResume);
            }

            public boolean customVoteSuspend(@NotNull SuspendContextImpl suspendContext) {
                Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                if (!this.$suspendAll) {
                    return false;
                }
                return SuspendOtherThreadsRequestor.initiateTransferToSuspendAll((SuspendContextImpl)suspendContext, arg_0 -> installCoroutineResumedBreakpoint.breakpoint.1.customVoteSuspend$lambda$0(this, this.$nextCallAfterResume, arg_0));
            }

            @NotNull
            public Function<SuspendContextImpl, Boolean> applyAfterContextSwitch() {
                return arg_0 -> installCoroutineResumedBreakpoint.breakpoint.1.applyAfterContextSwitch$lambda$1(this, this.$nextCallAfterResume, arg_0);
            }

            private final boolean scheduleStepOverCommandForSuspendSwitch(SuspendContextImpl it, int nextCallAfterResume) {
                DebuggerSteppingHelper.INSTANCE.createStepOverCommandForSuspendSwitch(it, nextCallAfterResume).prepareSteppingRequestsAndHints(it);
                return false;
            }

            private static final Boolean customVoteSuspend$lambda$0(installCoroutineResumedBreakpoint.breakpoint.1 this$0, int $nextCallAfterResume, SuspendContextImpl it) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.scheduleStepOverCommandForSuspendSwitch(it, $nextCallAfterResume);
            }

            private static final Boolean applyAfterContextSwitch$lambda$1(installCoroutineResumedBreakpoint.breakpoint.1 this$0, int $nextCallAfterResume, SuspendContextImpl c) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNull((Object)c);
                return this$0.scheduleStepOverCommandForSuspendSwitch(c, $nextCallAfterResume);
            }
        };
        breakpoint2.setSuspendPolicy(switch (context2.getSuspendPolicy()) {
            case 2 -> {
                if (useCoroutineIdFiltering && !DebuggerUtils.isAlwaysSuspendThreadBeforeSwitch()) {
                    yield "SuspendThread";
                }
                yield "SuspendAll";
            }
            case 1 -> "SuspendThread";
            case 0 -> "SuspendNone";
            default -> "SuspendAll";
        });
        if (!useCoroutineIdFiltering) {
            CoroutineBreakpointFacilityKt.access$applyEmptyThreadFilter(debugProcess);
        }
        breakpoint2.createRequest(debugProcess);
        debugProcess.setSteppingBreakpoint((SteppingBreakpoint)breakpoint2);
        LightOrRealThreadInfo filterThread = debugProcess.getRequestsManager().getFilterThread();
        CoroutineBreakpointFacility $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(CoroutineBreakpointFacility.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("Resume breakpoint for " + method2 + " in thread " + filterThread);
        return true;
    }

    static /* synthetic */ boolean installCoroutineResumedBreakpoint$default(CoroutineBreakpointFacility coroutineBreakpointFacility, SuspendContextImpl suspendContextImpl, Location location2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = -1;
        }
        return coroutineBreakpointFacility.installCoroutineResumedBreakpoint(suspendContextImpl, location2, n);
    }
}

