/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.sun.jdi.ThreadReference;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.State;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u001cR\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0018\u0010\r\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "", "descriptor", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "(Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;)V", "activeThread", "Lcom/sun/jdi/ThreadReference;", "getActiveThread", "()Lcom/sun/jdi/ThreadReference;", "continuationStackFrames", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "getContinuationStackFrames", "()Ljava/util/List;", "creationStackFrames", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "getCreationStackFrames", "getDescriptor", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineDescriptor;", "jobHierarchy", "", "getJobHierarchy", "topFrameVariables", "Lcom/intellij/debugger/engine/JavaValue;", "getTopFrameVariables", "topFrameVariables$delegate", "Lkotlin/Lazy;", "isCreated", "", "isRunning", "isRunningOnCurrentThread", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContext;", "isSuspended", "Companion", "kotlin.jvm-debugger.coroutines"})
public abstract class CoroutineInfoData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineDescriptor descriptor;
    @NotNull
    private final Lazy topFrameVariables$delegate;
    @NotNull
    public static final String DEFAULT_COROUTINE_NAME = "coroutine";
    @NotNull
    public static final String DEFAULT_COROUTINE_STATE = "UNKNOWN";

    public CoroutineInfoData(@NotNull CoroutineDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.descriptor = descriptor2;
        this.topFrameVariables$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JavaValue>>(this){
            final /* synthetic */ CoroutineInfoData this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final List<JavaValue> invoke() {
                Object object = (CoroutineStackFrameItem)((Object)CollectionsKt.firstOrNull(this.this$0.getContinuationStackFrames()));
                if (object == null || (object = object.getSpilledVariables()) == null) {
                    object = CollectionsKt.emptyList();
                }
                return object;
            }
        }));
    }

    @NotNull
    public final CoroutineDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public abstract List<CoroutineStackFrameItem> getContinuationStackFrames();

    @NotNull
    public abstract List<CreationCoroutineStackFrameItem> getCreationStackFrames();

    @Nullable
    public abstract ThreadReference getActiveThread();

    @NotNull
    public abstract List<String> getJobHierarchy();

    @NotNull
    public final List<JavaValue> getTopFrameVariables() {
        Lazy lazy = this.topFrameVariables$delegate;
        return (List)lazy.getValue();
    }

    public final boolean isSuspended() {
        return this.descriptor.getState() == State.SUSPENDED;
    }

    public final boolean isCreated() {
        return this.descriptor.getState() == State.CREATED;
    }

    public final boolean isRunning() {
        return this.descriptor.getState() == State.RUNNING;
    }

    public final boolean isRunningOnCurrentThread(@NotNull SuspendContext suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        ThreadReferenceProxy threadReferenceProxy = suspendContext.getThread();
        return Intrinsics.areEqual((Object)this.getActiveThread(), (Object)(threadReferenceProxy != null ? threadReferenceProxy.getThreadReference() : null));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData$Companion;", "", "()V", "DEFAULT_COROUTINE_NAME", "", "DEFAULT_COROUTINE_STATE", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

