/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.view;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineView;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineViewDebugSessionListener;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "coroutineView", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;", "(Lcom/intellij/xdebugger/XDebugSession;Lorg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineView;)V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "beforeSessionResume", "", "renew", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "requestClear", "sessionPaused", "sessionResumed", "sessionStopped", "settingsChanged", "stackFrameChanged", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineViewDebugSessionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineViewDebugSessionListener.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineViewDebugSessionListener\n+ 2 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,66:1\n73#2:67\n*S KotlinDebug\n*F\n+ 1 CoroutineViewDebugSessionListener.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/view/CoroutineViewDebugSessionListener\n*L\n59#1:67\n*E\n"})
public final class CoroutineViewDebugSessionListener
implements XDebugSessionListener {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final CoroutineView coroutineView;
    @NotNull
    private final ReadOnlyProperty log$delegate;

    public CoroutineViewDebugSessionListener(@NotNull XDebugSession session, @NotNull CoroutineView coroutineView) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)coroutineView, (String)"coroutineView");
        this.session = session;
        this.coroutineView = coroutineView;
        this.log$delegate = ProvidersKt.getLogger();
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void sessionPaused() {
        XSuspendContext xSuspendContext = this.session.getSuspendContext();
        if (xSuspendContext == null) {
            this.requestClear();
            return;
        }
        XSuspendContext suspendContext = xSuspendContext;
        this.coroutineView.getAlarm().cancel();
        this.renew(suspendContext);
    }

    public void sessionResumed() {
        this.coroutineView.saveState();
        XSuspendContext xSuspendContext = this.session.getSuspendContext();
        if (xSuspendContext == null) {
            this.requestClear();
            return;
        }
        XSuspendContext suspendContext = xSuspendContext;
        this.renew(suspendContext);
    }

    public void sessionStopped() {
        XSuspendContext xSuspendContext = this.session.getSuspendContext();
        if (xSuspendContext == null) {
            this.requestClear();
            return;
        }
        XSuspendContext suspendContext = xSuspendContext;
        this.renew(suspendContext);
    }

    public void stackFrameChanged() {
        this.coroutineView.saveState();
    }

    public void beforeSessionResume() {
    }

    public void settingsChanged() {
        XSuspendContext xSuspendContext = this.session.getSuspendContext();
        if (xSuspendContext == null) {
            this.requestClear();
            return;
        }
        XSuspendContext suspendContext = xSuspendContext;
        this.renew(suspendContext);
    }

    private final void renew(XSuspendContext suspendContext) {
        if (suspendContext instanceof SuspendContextImpl) {
            DebuggerUIUtil.invokeLater(() -> CoroutineViewDebugSessionListener.renew$lambda$0(this, suspendContext));
        }
    }

    private final void requestClear() {
        boolean $i$f$isUnitTestMode = false;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.coroutineView.resetRoot();
        } else {
            SingleAlarm.cancelAndRequest$default((SingleAlarm)this.coroutineView.getAlarm(), (boolean)false, (int)1, null);
        }
    }

    private static final void renew$lambda$0(CoroutineViewDebugSessionListener this$0, XSuspendContext $suspendContext) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$suspendContext, (String)"$suspendContext");
        if (this$0.coroutineView.isShowing()) {
            this$0.coroutineView.renewRoot((SuspendContextImpl)$suspendContext);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CoroutineViewDebugSessionListener.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

