/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluator;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentCompiler;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CodeFragmentParameter;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilation.CompiledCodeFragmentData;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.application.KotlinExceptionUtils;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.KtCodeFragment;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002\u001a.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u000eH\u0002\"\u0019\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u001c"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "createCompiledDataDescriptor", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CompiledCodeFragmentData;", "result", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilation/CodeFragmentCompiler$CompilationResult;", "evaluationException", "", "msg", "", "e", "", "getResolutionFacadeForCodeFragment", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "isSpecialException", "", "th", "reportError", "", "position", "Lcom/intellij/debugger/SourcePosition;", "message", "throwable", "kotlin.jvm-debugger.evaluation"})
public final class KotlinEvaluatorBuilderKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final Logger getLOG() {
        return LOG;
    }

    private static final boolean isSpecialException(Throwable th) {
        Throwable throwable = th;
        return ((((((throwable instanceof ClassNotPreparedException ? true : throwable instanceof InternalException) ? true : throwable instanceof AbsentInformationException) ? true : throwable instanceof ClassNotLoadedException) ? true : throwable instanceof IncompatibleThreadStateException) ? true : throwable instanceof InconsistentDebugInfoException) ? true : throwable instanceof ObjectCollectedException) ? true : throwable instanceof VMDisconnectedException;
    }

    private static final void reportError(KtCodeFragment codeFragment, SourcePosition position, String message2, Throwable throwable) {
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(codeFragment, position, message2, throwable){
            final /* synthetic */ KtCodeFragment $codeFragment;
            final /* synthetic */ SourcePosition $position;
            final /* synthetic */ String $message;
            final /* synthetic */ Throwable $throwable;
            {
                this.$codeFragment = $codeFragment;
                this.$position = $position;
                this.$message = $message;
                this.$throwable = $throwable;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                Object object;
                String string;
                Object object2;
                PsiElement psiElement2 = this.$codeFragment.getContext();
                PsiFile contextFile = psiElement2 != null ? psiElement2.getContainingFile() : null;
                Object[] objectArray = new Attachment[4];
                objectArray[0] = KotlinExceptionUtils.attachmentByPsiFile(contextFile);
                objectArray[1] = KotlinExceptionUtils.attachmentByPsiFile((PsiFile)this.$codeFragment);
                Object[] objectArray2 = objectArray;
                int n = 2;
                String string2 = "breakpoint.info";
                SourcePosition sourcePosition2 = this.$position;
                if (sourcePosition2 != null) {
                    void $this$invoke_u24lambda_u240;
                    SourcePosition sourcePosition3 = sourcePosition2;
                    String string3 = string2;
                    int n2 = n;
                    object2 = objectArray2;
                    boolean bl = false;
                    String string4 = $this$invoke_u24lambda_u240.getFile().getName() + ":" + $this$invoke_u24lambda_u240.getLine();
                    objectArray2 = object2;
                    n = n2;
                    string2 = string3;
                    string = string4;
                } else {
                    string = null;
                }
                String string5 = "Position: " + string;
                String string6 = string2;
                objectArray2[n] = new Attachment(string6, string5);
                objectArray[3] = new Attachment("context.info", (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(this.$codeFragment){
                    final /* synthetic */ KtCodeFragment $codeFragment;
                    {
                        this.$codeFragment = $codeFragment;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        PsiElement psiElement2 = this.$codeFragment.getContext();
                        String string = psiElement2 != null ? psiElement2.getText() : null;
                        if (string == null) {
                            string = "null";
                        }
                        return string;
                    }
                })));
                List attachments2 = CollectionsKt.listOfNotNull((Object[])objectArray);
                Attachment[] attachmentArray = this.$message;
                if (((CharSequence)attachmentArray).length() > 0) {
                    void it;
                    char c = attachmentArray.charAt(0);
                    object2 = new StringBuilder();
                    boolean bl = false;
                    Locale locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                    StringBuilder stringBuilder = ((StringBuilder)object2).append((Object)CharsKt.lowercase((char)it, (Locale)locale));
                    Attachment[] attachmentArray2 = attachmentArray;
                    int n3 = 1;
                    String string7 = attachmentArray2.substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                    object = stringBuilder.append(string7).toString();
                } else {
                    object = attachmentArray;
                }
                Attachment[] decapitalizedMessage = object;
                attachmentArray = new Attachment[]{KotlinExceptionUtils.merge(attachments2)};
                KotlinEvaluatorBuilderKt.getLOG().error("Cannot evaluate a code fragment of type " + this.$codeFragment.getClass() + ": " + (String)decapitalizedMessage, this.$throwable, attachmentArray);
            }
        }));
    }

    static /* synthetic */ void reportError$default(KtCodeFragment ktCodeFragment, SourcePosition sourcePosition2, String string, Throwable throwable, int n, Object object) {
        if ((n & 8) != 0) {
            throwable = null;
        }
        KotlinEvaluatorBuilderKt.reportError(ktCodeFragment, sourcePosition2, string, throwable);
    }

    @NotNull
    public static final CompiledCodeFragmentData createCompiledDataDescriptor(@NotNull CodeFragmentCompiler.CompilationResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Map<CodeFragmentParameter.Dumb, String> localFunctionSuffixes = result2.getLocalFunctionSuffixes();
        ArrayList dumbParameters = new ArrayList(result2.getParameterInfo().getParameters().size());
        for (CodeFragmentParameter.Dumb dumb : result2.getParameterInfo().getParameters()) {
            String suffix2;
            if (dumb.getKind() == CodeFragmentParameter.Kind.LOCAL_FUNCTION && (suffix2 = localFunctionSuffixes.get(dumb)) != null) {
                ((Collection)dumbParameters).add(CodeFragmentParameter.Dumb.copy$default(dumb, null, dumb.getName() + suffix2, null, 5, null));
                continue;
            }
            ((Collection)dumbParameters).add(dumb);
        }
        return new CompiledCodeFragmentData(result2.getClasses(), dumbParameters, result2.getParameterInfo().getCrossingBounds(), result2.getMainMethodSignature());
    }

    @NotNull
    public static final Void evaluationException(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((String)msg);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
        throw (Throwable)evaluateException;
    }

    @NotNull
    public static final Void evaluationException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        EvaluateException evaluateException = EvaluateExceptionUtil.createEvaluateException((Throwable)e);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)evaluateException), (String)"createEvaluateException(...)");
        throw (Throwable)evaluateException;
    }

    @NotNull
    public static final ResolutionFacade getResolutionFacadeForCodeFragment(@NotNull KtCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        List filesToAnalyze = CollectionsKt.listOf((Object)codeFragment);
        Project project2 = codeFragment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        KotlinCacheService kotlinCacheService = KotlinCacheService.Companion.getInstance(project2);
        return kotlinCacheService.getResolutionFacadeWithForcedPlatform(filesToAnalyze, JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform());
    }

    public static final /* synthetic */ boolean access$isSpecialException(Throwable th) {
        return KotlinEvaluatorBuilderKt.isSpecialException(th);
    }

    public static final /* synthetic */ void access$reportError(KtCodeFragment codeFragment, SourcePosition position, String message2, Throwable throwable) {
        KotlinEvaluatorBuilderKt.reportError(codeFragment, position, message2, throwable);
    }

    static {
        Logger logger = Logger.getInstance(KotlinEvaluator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

