/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Range;
import com.intellij.xdebugger.stepping.ForceSmartStepIntoSource;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaExperimentalApi;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.renderer.declarations.KaDeclarationRenderer;
import org.jetbrains.kotlin.analysis.api.renderer.declarations.impl.KaDeclarationRendererForSource;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.idea.debugger.core.JvmNameUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTargetKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTarget;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B=\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\n\u0010\u001c\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0005H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016R\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepTarget;", "Lcom/intellij/xdebugger/stepping/ForceSmartStepIntoSource;", "lines", "Lcom/intellij/util/Range;", "", "highlightElement", "Lcom/intellij/psi/PsiElement;", "label", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "ordinal", "methodInfo", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "(Lcom/intellij/util/Range;Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtDeclaration;ILorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;)V", "declarationPtr", "Lcom/intellij/psi/SmartPsiElementPointer;", "getMethodInfo", "()Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/CallableMemberInfo;", "getOrdinal", "()I", "createMethodFilter", "Lcom/intellij/debugger/engine/MethodFilter;", "equals", "", "other", "", "getClassName", "getDeclaration", "getIcon", "Ljavax/swing/Icon;", "hashCode", "needForceSmartStepInto", "Companion", "kotlin.jvm-debugger.core-fe10"})
public final class KotlinMethodSmartStepTarget
extends KotlinSmartStepTarget
implements ForceSmartStepIntoSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int ordinal;
    @NotNull
    private final CallableMemberInfo methodInfo;
    @Nullable
    private final SmartPsiElementPointer<KtDeclaration> declarationPtr;
    @NotNull
    private static final KaDeclarationRenderer renderer = KaDeclarationRendererForSource.INSTANCE.getWITH_QUALIFIED_NAMES().with((Function1<? super KaDeclarationRenderer.Builder, Unit>)((Function1)Companion.renderer.1.INSTANCE));

    public KotlinMethodSmartStepTarget(@NotNull Range<Integer> lines, @NotNull PsiElement highlightElement, @NotNull String label2, @Nullable KtDeclaration declaration2, int ordinal, @NotNull CallableMemberInfo methodInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)highlightElement, (String)"highlightElement");
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        Intrinsics.checkNotNullParameter((Object)methodInfo, (String)"methodInfo");
        super(label2, highlightElement, false, lines);
        this.ordinal = ordinal;
        this.methodInfo = methodInfo;
        KtDeclaration ktDeclaration = declaration2;
        this.declarationPtr = ktDeclaration != null && (ktDeclaration = KotlinMethodSmartStepTargetKt.access$fetchNavigationElement(ktDeclaration)) != null ? SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)ktDeclaration)) : null;
        boolean bl2 = bl = declaration2 != null || this.methodInfo.isInvoke();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    public final int getOrdinal() {
        return this.ordinal;
    }

    @NotNull
    public final CallableMemberInfo getMethodInfo() {
        return this.methodInfo;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2;
        if (this.methodInfo.isExtension()) {
            Icon icon3 = KotlinIcons.EXTENSION_FUNCTION;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"EXTENSION_FUNCTION");
        } else {
            Icon icon4 = KotlinIcons.FUNCTION;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FUNCTION");
        }
        return icon2;
    }

    @Nullable
    public String getClassName() {
        return (String)ActionsKt.runReadAction((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ KotlinMethodSmartStepTarget this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                SmartPsiElementPointer smartPsiElementPointer = KotlinMethodSmartStepTarget.access$getDeclarationPtr$p(this.this$0);
                return smartPsiElementPointer != null && (smartPsiElementPointer = (KtDeclaration)smartPsiElementPointer.getElement()) != null ? JvmNameUtilKt.getClassName((KtDeclaration)smartPsiElementPointer) : null;
            }
        }));
    }

    public boolean needForceSmartStepInto() {
        return this.methodInfo.isInvoke() && this.methodInfo.isSuspend();
    }

    @Nullable
    public final KtDeclaration getDeclaration() {
        return KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
    }

    @Override
    @NotNull
    public MethodFilter createMethodFilter() {
        KtDeclaration declaration2 = KotlinMethodSmartStepTargetKt.getElementInReadAction(this.declarationPtr);
        return (MethodFilter)new KotlinMethodFilter((PsiElement)declaration2, (Range<Integer>)this.getCallingExpressionLines(), this.methodInfo);
    }

    public boolean equals(@Nullable Object other2) {
        if (this == other2) {
            return true;
        }
        if (other2 == null || !(other2 instanceof KotlinMethodSmartStepTarget)) {
            return false;
        }
        if (this.methodInfo.isInvoke() && ((KotlinMethodSmartStepTarget)((Object)other2)).methodInfo.isInvoke()) {
            return true;
        }
        return this.getHighlightElement() == ((KotlinMethodSmartStepTarget)((Object)other2)).getHighlightElement();
    }

    public int hashCode() {
        if (this.methodInfo.isInvoke()) {
            return 42;
        }
        PsiElement psiElement2 = this.getHighlightElement();
        return psiElement2 != null ? psiElement2.hashCode() : 0;
    }

    public static final /* synthetic */ SmartPsiElementPointer access$getDeclarationPtr$p(KotlinMethodSmartStepTarget $this) {
        return $this.declarationPtr;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nR\u00020\b\u00a2\u0006\u0002\u0010\u000bR\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget$Companion;", "", "()V", "renderer", "Lorg/jetbrains/kotlin/analysis/api/renderer/declarations/KaDeclarationRenderer;", "getRenderer$annotations", "calcLabel", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaDeclarationSymbol;)Ljava/lang/String;", "kotlin.jvm-debugger.core-fe10"})
    public static final class Companion {
        private Companion() {
        }

        @KaExperimentalApi
        private static /* synthetic */ void getRenderer$annotations() {
        }

        @NotNull
        public final String calcLabel(@NotNull KaSession $context_receiver_0, @NotNull KaDeclarationSymbol symbol2) {
            Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
            Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
            return $context_receiver_0.render(symbol2, renderer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

