/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.statistics.DebuggerStatistics;
import com.intellij.debugger.statistics.Engine;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManagerKt;
import org.jetbrains.kotlin.idea.debugger.base.util.DexDebugFacility;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.CallableMemberInfo;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepIntoHandlerKt$getContainingExpression$;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFilterer;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.KotlinSmartStepTargetFiltererAdapter;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitorKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a:\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u001a$\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0010*\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0019\u001a\u00020\bH\u0002\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u001a\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u000f*\u00020\u001cH\u0002\u001a\u0014\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0010*\u00020\u000fH\u0002\u001a\u0012\u0010\u001e\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\b0\u0010H\u0002\u00a8\u0006 "}, d2={"calculateSmartStepTargetsToShow", "", "Lcom/intellij/debugger/actions/SmartStepTarget;", "targets", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "lines", "Lkotlin/ranges/ClosedRange;", "", "filterSmartStepTargets", "Lorg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinMethodSmartStepTarget;", "location", "Lcom/sun/jdi/Location;", "findSmartStepTargets", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lcom/intellij/util/Range;", "fixOrdinalsAfterFiltering", "", "all", "removed", "", "fixOrdinalsAfterTargetRemoval", "removedTarget", "coerceAtLeast", "value", "filterAlreadyExecuted", "getContainingExpression", "Lcom/intellij/debugger/SourcePosition;", "getLines", "toClosedRange", "Lkotlin/ranges/IntRange;", "kotlin.jvm-debugger.core-fe10"})
@SourceDebugExtension(value={"SMAP\nKotlinSmartStepIntoHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSmartStepIntoHandler.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepIntoHandlerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,242:1\n800#2,11:243\n766#2:254\n857#2,2:255\n473#3:257\n*S KotlinDebug\n*F\n+ 1 KotlinSmartStepIntoHandler.kt\norg/jetbrains/kotlin/idea/debugger/stepping/smartStepInto/KotlinSmartStepIntoHandlerKt\n*L\n116#1:243,11\n118#1:254\n118#1:255,2\n180#1:257\n*E\n"})
public final class KotlinSmartStepIntoHandlerKt {
    private static final List<SmartStepTarget> findSmartStepTargets(KtElement element3, Range<Integer> lines) {
        OrderedSet targets = new OrderedSet();
        SmartStepTargetVisitor visitor2 = new SmartStepTargetVisitor(lines, (OrderedSet<SmartStepTarget>)targets);
        element3.accept((KtVisitor)visitor2, null);
        return CollectionsKt.toList((Iterable)((Iterable)targets));
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SmartStepTarget> calculateSmartStepTargetsToShow(List<? extends SmartStepTarget> targets, DebugProcessImpl debugProcess, ClosedRange<Integer> lines) {
        void $this$filterTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = targets;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo22 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinMethodSmartStepTarget)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List methodTargets = (List)destination$iv$iv;
        HashSet notYetExecutedMethodTargets = CollectionsKt.toHashSet((Iterable)KotlinSmartStepIntoHandlerKt.filterAlreadyExecuted(methodTargets, debugProcess, lines));
        Iterable $this$filter$iv = targets;
        boolean $i$f$filter = false;
        Iterable $i$f$filterIsInstanceTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SmartStepTarget it = (SmartStepTarget)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof KotlinMethodSmartStepTarget) || notYetExecutedMethodTargets.contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List targetsToShow = (List)destination$iv$iv2;
        Set removed = SetsKt.minus((Set)CollectionsKt.toHashSet((Iterable)methodTargets), (Iterable)notYetExecutedMethodTargets);
        KotlinSmartStepIntoHandlerKt.fixOrdinalsAfterFiltering(targets, removed);
        return targetsToShow;
    }

    private static final List<KotlinMethodSmartStepTarget> filterAlreadyExecuted(List<KotlinMethodSmartStepTarget> $this$filterAlreadyExecuted, DebugProcessImpl debugProcess, ClosedRange<Integer> lines) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if ($this$filterAlreadyExecuted.isEmpty()) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.SUCCESS);
            return $this$filterAlreadyExecuted;
        }
        if (DexDebugFacility.INSTANCE.isDex((DebugProcess)debugProcess)) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.BYTECODE_NOT_AVAILABLE);
            return $this$filterAlreadyExecuted;
        }
        SuspendContextImpl suspendContextImpl = debugProcess.getSuspendManager().getPausedContext();
        Object frameProxy = suspendContextImpl != null ? suspendContextImpl.getFrameProxy() : null;
        Object object = frameProxy;
        if (object == null || (object = SafeUtilKt.safeLocation((StackFrameProxy)object)) == null) {
            List<KotlinMethodSmartStepTarget> $this$filterAlreadyExecuted_u24lambda_u241 = $this$filterAlreadyExecuted;
            boolean bl = false;
            DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.BYTECODE_NOT_AVAILABLE);
            return $this$filterAlreadyExecuted_u24lambda_u241;
        }
        Object location2 = object;
        return KotlinSmartStepIntoHandlerKt.filterSmartStepTargets((Location)location2, lines, $this$filterAlreadyExecuted, debugProcess);
    }

    private static final void fixOrdinalsAfterFiltering(List<? extends SmartStepTarget> all, Set<KotlinMethodSmartStepTarget> removed) {
        for (KotlinMethodSmartStepTarget removedTarget : removed) {
            KotlinSmartStepIntoHandlerKt.fixOrdinalsAfterTargetRemoval(removedTarget, all);
        }
    }

    private static final void fixOrdinalsAfterTargetRemoval(KotlinMethodSmartStepTarget removedTarget, List<? extends SmartStepTarget> all) {
        int removedOrdinal = removedTarget.getMethodInfo().getOrdinal();
        for (KotlinMethodSmartStepTarget target2 : SmartStepTargetVisitorKt.targetsWithDeclaration((Collection<? extends SmartStepTarget>)all, removedTarget.getDeclaration())) {
            if (target2.getMethodInfo().getOrdinal() <= removedOrdinal) continue;
            CallableMemberInfo callableMemberInfo = target2.getMethodInfo();
            callableMemberInfo.setOrdinal(callableMemberInfo.getOrdinal() - 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final KtElement getContainingExpression(SourcePosition $this$getContainingExpression) {
        void $this$filterIsInstance$iv;
        PsiElement psiElement2 = $this$getContainingExpression.getElementAt();
        if (psiElement2 == null) {
            return null;
        }
        PsiElement element3 = psiElement2;
        PsiElement psiElement3 = KotlinPsiUtils.getTopmostElementAtOffset(element3, element3.getTextRange().getStartOffset());
        KtElement result2 = psiElement3 instanceof KtElement ? (KtElement)psiElement3 : null;
        KtExpression ktExpression = KotlinPositionManagerKt.getContainingBlockOrMethod$default(element3, false, 1, null);
        if (ktExpression == null) {
            return result2;
        }
        KtExpression containingBlock = ktExpression;
        Sequence sequence2 = SequencesKt.takeWhile((Sequence)PsiTreeUtilKt.parents((PsiElement)element3, (boolean)true), (Function1)((Function1)new Function1<PsiElement, Boolean>(containingBlock){
            final /* synthetic */ KtExpression $containingBlock;
            {
                this.$containingBlock = $containingBlock;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return KotlinPositionManagerKt.getContainingBlockOrMethod$default(it, false, 1, null) == this.$containingBlock;
            }
        }));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getContainingExpression$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence3, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        KtExpression ktExpression2 = (KtExpression)SequencesKt.lastOrNull((Sequence)sequence3);
        if (ktExpression2 == null) {
            return result2;
        }
        KtExpression expression2 = ktExpression2;
        return result2 == null || expression2.getTextRange().contains(result2.getTextRange()) ? (KtElement)expression2 : result2;
    }

    private static final Range<Integer> getLines(KtElement $this$getLines) {
        KtFile ktFile2 = $this$getLines.getContainingKtFile();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile2, (String)"getContainingKtFile(...)");
        KtFile file2 = ktFile2;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument((PsiFile)file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        TextRange textRange = $this$getLines.getTextRange();
        return new Range((Comparable)Integer.valueOf(document2.getLineNumber(textRange.getStartOffset())), (Comparable)Integer.valueOf(document2.getLineNumber(textRange.getEndOffset())));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Range<Integer> coerceAtLeast(Range<Integer> $this$coerceAtLeast, int value2) {
        Range range2;
        Comparable comparable = $this$coerceAtLeast.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getFrom(...)");
        if (((Number)((Object)comparable)).intValue() >= value2) {
            Comparable comparable2 = $this$coerceAtLeast.getTo();
            Intrinsics.checkNotNullExpressionValue((Object)comparable2, (String)"getTo(...)");
            if (((Number)((Object)comparable2)).intValue() >= value2) {
                range2 = $this$coerceAtLeast;
                return range2;
            }
        }
        Comparable comparable3 = $this$coerceAtLeast.getFrom();
        Intrinsics.checkNotNullExpressionValue((Object)comparable3, (String)"getFrom(...)");
        int n = ((Number)((Object)comparable3)).intValue();
        Comparable comparable4 = Integer.valueOf(Math.max(value2, n));
        Comparable comparable5 = $this$coerceAtLeast.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable5, (String)"getTo(...)");
        n = ((Number)((Object)comparable5)).intValue();
        Range range3 = new Range(comparable4, (Comparable)Integer.valueOf(Math.max(value2, n)));
        range2 = range3;
        return range2;
    }

    private static final List<KotlinMethodSmartStepTarget> filterSmartStepTargets(Location location2, ClosedRange<Integer> lines, List<KotlinMethodSmartStepTarget> targets, DebugProcessImpl debugProcess) {
        Method method = SafeUtilKt.safeMethod(location2);
        if (method == null) {
            boolean bl = false;
            DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.BYTECODE_NOT_AVAILABLE);
            return targets;
        }
        Method method2 = method;
        KotlinSmartStepTargetFilterer targetFilterer = new KotlinSmartStepTargetFilterer(targets, debugProcess);
        CompoundPositionManager compoundPositionManager = debugProcess.getPositionManager();
        Intrinsics.checkNotNullExpressionValue((Object)compoundPositionManager, (String)"getPositionManager(...)");
        KotlinSmartStepTargetFiltererAdapter targetFiltererAdapter = new KotlinSmartStepTargetFiltererAdapter(lines, location2, (PositionManager)compoundPositionManager, targetFilterer);
        Ref.ObjectRef unvisitedTargets = new Ref.ObjectRef();
        MethodBytecodeUtil.visit((Method)method2, (long)Long.MAX_VALUE, (MethodVisitor)((MethodVisitor)new MethodBytecodeUtil.InstructionOffsetReader(targetFiltererAdapter, location2, (Ref.ObjectRef<List<KotlinMethodSmartStepTarget>>)unvisitedTargets, targetFilterer){
            private boolean stopCollectingVisitedTargets;
            final /* synthetic */ KotlinSmartStepTargetFiltererAdapter $targetFiltererAdapter;
            final /* synthetic */ Location $location;
            final /* synthetic */ Ref.ObjectRef<List<KotlinMethodSmartStepTarget>> $unvisitedTargets;
            final /* synthetic */ KotlinSmartStepTargetFilterer $targetFilterer;
            {
                this.$targetFiltererAdapter = $targetFiltererAdapter;
                this.$location = $location;
                this.$unvisitedTargets = $unvisitedTargets;
                this.$targetFilterer = $targetFilterer;
                super($targetFiltererAdapter);
            }

            public void readBytecodeInstructionOffset(int offset2) {
                if (!this.stopCollectingVisitedTargets && (long)offset2 >= this.$location.codeIndex()) {
                    this.$unvisitedTargets.element = this.$targetFilterer.getUnvisitedTargets();
                    this.stopCollectingVisitedTargets = true;
                }
            }

            protected void reportOpcode(int opcode) {
                ProgressManager.checkCanceled();
                this.$targetFiltererAdapter.reportOpcode(opcode);
            }

            public void visitMethodInsn(int opcode, @NotNull String owner, @NotNull String name2, @NotNull String descriptor2, boolean isInterface) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                this.$targetFiltererAdapter.visitMethodInsn(opcode, owner, name2, descriptor2, isInterface);
            }
        }), (boolean)true);
        if (!((Collection)targetFilterer.getUnvisitedTargets()).isEmpty()) {
            DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.TARGETS_MISMATCH);
            return targets;
        }
        DebuggerStatistics.logSmartStepIntoTargetsDetection((Project)debugProcess.getProject(), (Engine)Engine.KOTLIN, (JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus)JvmSmartStepIntoHandler.SmartStepIntoDetectionStatus.SUCCESS);
        Object object = unvisitedTargets.element;
        Intrinsics.checkNotNull((Object)object);
        return (List)object;
    }

    private static final IntRange toClosedRange(Range<Integer> $this$toClosedRange) {
        int n = ((Number)((Object)$this$toClosedRange.getFrom())).intValue();
        Comparable comparable = $this$toClosedRange.getTo();
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getTo(...)");
        return new IntRange(n, ((Number)((Object)comparable)).intValue());
    }

    public static final /* synthetic */ KtElement access$getContainingExpression(SourcePosition $receiver) {
        return KotlinSmartStepIntoHandlerKt.getContainingExpression($receiver);
    }

    public static final /* synthetic */ Range access$getLines(KtElement $receiver) {
        return KotlinSmartStepIntoHandlerKt.getLines($receiver);
    }

    public static final /* synthetic */ Range access$coerceAtLeast(Range $receiver, int value2) {
        return KotlinSmartStepIntoHandlerKt.coerceAtLeast((Range<Integer>)$receiver, value2);
    }

    public static final /* synthetic */ List access$findSmartStepTargets(KtElement element3, Range lines) {
        return KotlinSmartStepIntoHandlerKt.findSmartStepTargets(element3, (Range<Integer>)lines);
    }

    public static final /* synthetic */ List access$calculateSmartStepTargetsToShow(List targets, DebugProcessImpl debugProcess, ClosedRange lines) {
        return KotlinSmartStepIntoHandlerKt.calculateSmartStepTargetsToShow(targets, debugProcess, (ClosedRange<Integer>)lines);
    }

    public static final /* synthetic */ IntRange access$toClosedRange(Range $receiver) {
        return KotlinSmartStepIntoHandlerKt.toClosedRange((Range<Integer>)$receiver);
    }
}

