/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleCodeInsightCommon;

import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectNotificationAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExternalLibraryDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.util.ProjectStructureUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinBuildSystemDependencyManager;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurationService;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptManipulator;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.GradleBuildScriptSupport;
import org.jetbrains.kotlin.idea.gradleCodeInsightCommon.KotlinGradleCodeInsightUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/gradleCodeInsightCommon/GradleKotlinBuildSystemDependencyManager;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinBuildSystemDependencyManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addDependency", "", "module", "Lcom/intellij/openapi/module/Module;", "libraryDescriptor", "Lcom/intellij/openapi/roots/ExternalLibraryDescriptor;", "getBuildScriptFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isApplicable", "", "isProjectSyncInProgress", "isProjectSyncPending", "startProjectSync", "kotlin.gradle.code-insight-common"})
@ApiStatus.Internal
public final class GradleKotlinBuildSystemDependencyManager
implements KotlinBuildSystemDependencyManager {
    @NotNull
    private final Project project;

    public GradleKotlinBuildSystemDependencyManager(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean isApplicable(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return ProjectStructureUtils.isGradleModule(module2);
    }

    @Override
    public void addDependency(@NotNull Module module2, @NotNull ExternalLibraryDescriptor libraryDescriptor) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryDescriptor, (String)"libraryDescriptor");
        DependencyScope dependencyScope = libraryDescriptor.getPreferredScope();
        if (dependencyScope == null) {
            dependencyScope = DependencyScope.COMPILE;
        }
        DependencyScope dependencyScope2 = dependencyScope;
        Intrinsics.checkNotNull((Object)dependencyScope2);
        DependencyScope scope2 = dependencyScope2;
        PsiFile psiFile2 = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(module2);
        if (psiFile2 == null) {
            return;
        }
        PsiFile buildScriptFile = psiFile2;
        GradleBuildScriptManipulator gradleBuildScriptManipulator = GradleBuildScriptSupport.Companion.findManipulator$default(GradleBuildScriptSupport.Companion, buildScriptFile, false, 2, null);
        if (gradleBuildScriptManipulator != null) {
            gradleBuildScriptManipulator.addKotlinLibraryToModuleBuildScript(module2, scope2, libraryDescriptor);
        }
    }

    @Override
    public boolean isProjectSyncPending() {
        ObservableProperty isNotificationVisible = ExternalSystemProjectNotificationAware.Companion.isNotificationVisibleProperty(this.project, new ProjectSystemId("GRADLE", "Gradle"));
        return (Boolean)isNotificationVisible.get();
    }

    @Override
    @Nullable
    public VirtualFile getBuildScriptFile(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        PsiFile psiFile2 = KotlinGradleCodeInsightUtils.getBuildScriptPsiFile(module2);
        return psiFile2 != null ? psiFile2.getVirtualFile() : null;
    }

    @Override
    public boolean isProjectSyncInProgress() {
        return KotlinProjectConfigurationService.Companion.getInstance(this.project).isSyncInProgress();
    }

    @Override
    public void startProjectSync() {
        KotlinProjectConfigurationService.Companion.getInstance(this.project).queueSync();
    }
}

