/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceWithIgnoreCaseEqualsInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithIgnoreCaseEqualsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ReplaceFix", "kotlin.idea"})
public final class ReplaceWithIgnoreCaseEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.binaryExpressionVisitor((Function1)((Function1)new Function1<KtBinaryExpression, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
                super(1);
            }

            public final void invoke(@NotNull KtBinaryExpression binaryExpression) {
                Intrinsics.checkNotNullParameter((Object)binaryExpression, (String)"binaryExpression");
                if (!Intrinsics.areEqual((Object)binaryExpression.getOperationToken(), (Object)KtTokens.EQEQ)) {
                    return;
                }
                KtExpression ktExpression = binaryExpression.getLeft();
                if (ktExpression == null || (ktExpression = ReplaceWithIgnoreCaseEqualsInspectionKt.access$callInfo(ktExpression)) == null) {
                    return;
                }
                KtExpression ktExpression2 = ktExpression;
                KtCallExpression leftCall = (KtCallExpression)ktExpression2.component1();
                String leftCalleeText = (String)ktExpression2.component2();
                KtExpression ktExpression3 = binaryExpression.getRight();
                if (ktExpression3 == null || (ktExpression3 = ReplaceWithIgnoreCaseEqualsInspectionKt.access$callInfo(ktExpression3)) == null) {
                    return;
                }
                KtExpression ktExpression4 = ktExpression3;
                KtCallExpression rightCall = (KtCallExpression)ktExpression4.component1();
                String rightCalleeText = (String)ktExpression4.component2();
                if (!Intrinsics.areEqual((Object)leftCalleeText, (Object)rightCalleeText)) {
                    return;
                }
                FqName fqName2 = (FqName)ReplaceWithIgnoreCaseEqualsInspectionKt.access$getCaseConversionFunctionFqNames$p().get(leftCalleeText);
                if (fqName2 == null) {
                    return;
                }
                FqName caseConversionFunctionFqName = fqName2;
                BindingContext context2 = ResolutionUtils.analyze((KtElement)binaryExpression, BodyResolveMode.PARTIAL);
                FqName fqName3 = ReplaceWithIgnoreCaseEqualsInspectionKt.access$fqName(leftCall, context2);
                if (fqName3 == null) {
                    return;
                }
                FqName leftCallFqName = fqName3;
                FqName fqName4 = ReplaceWithIgnoreCaseEqualsInspectionKt.access$fqName(rightCall, context2);
                if (fqName4 == null) {
                    return;
                }
                FqName rightCallFqName = fqName4;
                if (!Intrinsics.areEqual((Object)leftCallFqName, (Object)rightCallFqName)) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)leftCallFqName, (Object)caseConversionFunctionFqName)) {
                    return;
                }
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new ReplaceFix()};
                this.$holder.registerProblem((PsiElement)binaryExpression, KotlinBundle.message((String)"inspection.replace.with.ignore.case.equals.display.name", (Object[])new Object[0]), localQuickFixArray);
            }
        }));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithIgnoreCaseEqualsInspection$ReplaceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class ReplaceFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{"equals(..., ignoreCase = true)"};
            return KotlinBundle.message((String)"replace.with.0", (Object[])objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            KtExpression ktExpression;
            KtQualifiedExpression rightReceiver;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtBinaryExpression ktBinaryExpression = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression == null) {
                return;
            }
            KtBinaryExpression binary = ktBinaryExpression;
            KtExpression ktExpression2 = binary.getLeft();
            if (ktExpression2 == null || (ktExpression2 = ReplaceWithIgnoreCaseEqualsInspectionKt.access$callInfo(ktExpression2)) == null) {
                return;
            }
            KtCallExpression leftCall = (KtCallExpression)ktExpression2.component1();
            KtExpression ktExpression3 = binary.getRight();
            if (ktExpression3 == null || (ktExpression3 = ReplaceWithIgnoreCaseEqualsInspectionKt.access$callInfo(ktExpression3)) == null) {
                return;
            }
            KtCallExpression rightCall = (KtCallExpression)ktExpression3.component1();
            KtPsiFactory psiFactory = new KtPsiFactory(project2, false, 2, null);
            KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)leftCall));
            KtExpression leftReceiver = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
            KtQualifiedExpression ktQualifiedExpression2 = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)rightCall));
            if (ktQualifiedExpression2 == null || (ktQualifiedExpression2 = ktQualifiedExpression2.getReceiverExpression()) == null) {
                ktQualifiedExpression2 = rightReceiver = (KtExpression)psiFactory.createThisExpression();
            }
            if (leftReceiver != null) {
                var10_9 = new Object[]{leftReceiver, rightReceiver};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"$0.equals($1, ignoreCase = true)", (Object[])var10_9, (boolean)false, (int)4, null);
            } else {
                var10_9 = new Object[]{rightReceiver};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"equals($0, ignoreCase = true)", (Object[])var10_9, (boolean)false, (int)4, null);
            }
            KtExpression newExpression2 = ktExpression;
            binary.replace((PsiElement)newExpression2);
        }
    }
}

