/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.codeinsight.utils.EditorUtilsKt;
import org.jetbrains.kotlin.idea.inspections.UnusedUnaryOperatorInspection;
import org.jetbrains.kotlin.idea.inspections.UnusedUnaryOperatorInspectionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J#\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createFixes", "", "Lcom/intellij/codeInspection/LocalQuickFix;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)[Lcom/intellij/codeInspection/LocalQuickFix;", "isUsedAsExpression", "prefix", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "parentBinary", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "MoveUnaryOperatorToPreviousLineFix", "RemoveUnaryOperatorFix", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nUnusedUnaryOperatorInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedUnaryOperatorInspection.kt\norg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,141:1\n142#2:142\n37#3,2:143\n*S KotlinDebug\n*F\n+ 1 UnusedUnaryOperatorInspection.kt\norg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection\n*L\n86#1:142\n94#1:143,2\n*E\n"})
public final class UnusedUnaryOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ UnusedUnaryOperatorInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitPrefixExpression(@NotNull KtPrefixExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                buildVisitor.1.check$default(this, expression2, null, 2, null);
            }

            public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                if (expression2.getParent() instanceof KtBinaryExpression) {
                    return;
                }
                KtExpression left = expression2.getLeft();
                while (left instanceof KtBinaryExpression) {
                    left = ((KtBinaryExpression)left).getLeft();
                }
                KtExpression ktExpression = left;
                KtPrefixExpression ktPrefixExpression = ktExpression instanceof KtPrefixExpression ? (KtPrefixExpression)ktExpression : null;
                if (ktPrefixExpression == null) {
                    return;
                }
                KtPrefixExpression prefix2 = ktPrefixExpression;
                this.check(prefix2, expression2);
            }

            private final void check(KtPrefixExpression prefix2, KtBinaryExpression parentBinary) {
                if (prefix2.getBaseExpression() == null) {
                    return;
                }
                IElementType operationToken = prefix2.getOperationToken();
                if (!Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) && !Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS)) {
                    return;
                }
                if (UnusedUnaryOperatorInspectionKt.access$isInAnnotationEntry(prefix2)) {
                    return;
                }
                BindingContext context2 = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)prefix2, null, 1, null);
                if (Intrinsics.areEqual((Object)context2, (Object)BindingContext.EMPTY) || UnusedUnaryOperatorInspection.access$isUsedAsExpression(this.this$0, prefix2, parentBinary, context2)) {
                    return;
                }
                ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)prefix2.getOperationReference()), (BindingContext)context2);
                CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
                DeclarationDescriptor declarationDescriptor = callableDescriptor instanceof DeclarationDescriptor ? (DeclarationDescriptor)callableDescriptor : null;
                if (declarationDescriptor == null) {
                    return;
                }
                DeclarationDescriptor operatorDescriptor = declarationDescriptor;
                if (!KotlinBuiltIns.isUnderKotlinPackage((DeclarationDescriptor)operatorDescriptor)) {
                    return;
                }
                KtBinaryExpression ktBinaryExpression = parentBinary;
                LocalQuickFix[] localQuickFixArray = UnusedUnaryOperatorInspection.access$createFixes(this.this$0, ktBinaryExpression != null ? (KtExpression)ktBinaryExpression : (KtExpression)prefix2, context2);
                this.$holder.registerProblem((PsiElement)prefix2, KotlinBundle.message((String)"unused.unary.operator", (Object[])new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
            }

            static /* synthetic */ void check$default(buildVisitor.1 var0, KtPrefixExpression ktPrefixExpression, KtBinaryExpression ktBinaryExpression, int n, Object object) {
                if ((n & 2) != 0) {
                    ktBinaryExpression = null;
                }
                var0.check(ktPrefixExpression, ktBinaryExpression);
            }
        };
    }

    private final boolean isUsedAsExpression(KtPrefixExpression prefix2, KtBinaryExpression parentBinary, BindingContext context2) {
        PsiElement prev2;
        if (Intrinsics.areEqual((Object)prefix2.getOperationToken(), (Object)KtTokens.PLUS) && (prev2 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments$default((PsiElement)((PsiElement)prefix2), (boolean)false, (int)1, null)) instanceof KtOperationReferenceExpression && ((KtOperationReferenceExpression)prev2).getParent() instanceof KtBinaryExpression) {
            return false;
        }
        KtBinaryExpression ktBinaryExpression = parentBinary;
        return BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)(ktBinaryExpression != null ? (KtExpression)ktBinaryExpression : (KtExpression)prefix2)), (BindingContext)context2);
    }

    private final LocalQuickFix[] createFixes(KtExpression expression2, BindingContext context2) {
        Object[] objectArray = new LocalQuickFix[]{new RemoveUnaryOperatorFix()};
        List fixes2 = CollectionsKt.mutableListOf((Object[])objectArray);
        PsiElement prevLeaf2 = UnusedUnaryOperatorInspectionKt.access$getPrevLeafIgnoringWhitespaceAndComments(expression2);
        if (prevLeaf2 != null) {
            KotlinType prevType;
            KotlinType type2 = CallUtilKt.getType((KtExpression)expression2, (BindingContext)context2);
            PsiElement $this$getStrictParentOfType$iv = prevLeaf2;
            boolean $i$f$getStrictParentOfType = false;
            KtExpression ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtExpression.class, (boolean)true);
            Object object = prevType = ktExpression != null ? CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)context2) : null;
            if (type2 != null && prevType != null && (Intrinsics.areEqual((Object)type2, (Object)prevType) || TypeUtilsKt.isPrimitiveNumberType((KotlinType)type2) && TypeUtilsKt.isPrimitiveNumberType((KotlinType)prevType))) {
                fixes2.add(new MoveUnaryOperatorToPreviousLineFix());
            }
        }
        Collection $this$toTypedArray$iv = fixes2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new LocalQuickFix[0]);
    }

    public static final /* synthetic */ boolean access$isUsedAsExpression(UnusedUnaryOperatorInspection $this, KtPrefixExpression prefix2, KtBinaryExpression parentBinary, BindingContext context2) {
        return $this.isUsedAsExpression(prefix2, parentBinary, context2);
    }

    public static final /* synthetic */ LocalQuickFix[] access$createFixes(UnusedUnaryOperatorInspection $this, KtExpression expression2, BindingContext context2) {
        return $this.createFixes(expression2, context2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection$MoveUnaryOperatorToPreviousLineFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class MoveUnaryOperatorToPreviousLineFix
    implements LocalQuickFix,
    HighPriorityAction {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"move.unary.operator.to.previous.line.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtPrefixExpression ktPrefixExpression = psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            KtExpression ktExpression = prefixExpression.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression baseExpression = ktExpression;
            PsiElement psiElement3 = UnusedUnaryOperatorInspectionKt.access$getPrevLeafIgnoringWhitespaceAndComments((KtExpression)prefixExpression);
            if (psiElement3 == null) {
                return;
            }
            int prevLeafStartOffset = PsiTreeUtilKt.getStartOffset((PsiElement)psiElement3);
            int prefixEndOffset = PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)prefixExpression));
            Editor editor2 = EditorUtilsKt.findExistingEditor((PsiElement)prefixExpression);
            if (editor2 == null) {
                return;
            }
            Editor editor3 = editor2;
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            PsiFile file2 = prefixExpression.getContainingFile();
            prefixExpression.replace((PsiElement)baseExpression);
            documentManager.doPostponedOperationsAndUnblockDocument(document2);
            document2.insertString(prevLeafStartOffset + 1, (CharSequence)(" " + prefixExpression.getOperationReference().getText()));
            documentManager.commitDocument(document2);
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, new TextRange(prevLeafStartOffset, prefixEndOffset));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedUnaryOperatorInspection$RemoveUnaryOperatorFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    private static final class RemoveUnaryOperatorFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message((String)"remove.unary.operator.fix.text", (Object[])new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            KtPrefixExpression ktPrefixExpression = psiElement2 instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement2 : null;
            if (ktPrefixExpression == null) {
                return;
            }
            KtPrefixExpression prefixExpression = ktPrefixExpression;
            KtExpression ktExpression = prefixExpression.getBaseExpression();
            if (ktExpression == null) {
                return;
            }
            KtExpression baseExpression = ktExpression;
            prefixExpression.replace((PsiElement)baseExpression);
        }
    }
}

