/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.suppress;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinBaseCodeInsightBundle;
import org.jetbrains.kotlin.idea.inspections.suppress.AnnotationHostKind;
import org.jetbrains.kotlin.idea.inspections.suppress.CaretBox;
import org.jetbrains.kotlin.idea.inspections.suppress.KotlinSuppressIntentionActionKt;
import org.jetbrains.kotlin.idea.util.AnnotationModificationUtilsKt;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J#\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0096\u0002J\"\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010%\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00052\b\b\u0002\u0010&\u001a\u00020#H\u0002J\u001e\u0010'\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001e\u0010*\u001a\u00020\u000f2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0(2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/suppress/KotlinSuppressIntentionAction;", "Lcom/intellij/codeInspection/SuppressIntentionAction;", "suppressAt", "Lorg/jetbrains/kotlin/psi/KtElement;", "suppressionKey", "", "kind", "Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;", "(Lorg/jetbrains/kotlin/psi/KtElement;Ljava/lang/String;Lorg/jetbrains/kotlin/idea/inspections/suppress/AnnotationHostKind;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "addArgumentToSuppressAnnotation", "", "entry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "id", "findSuppressAnnotation", "annotated", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "annotationList", "Lorg/jetbrains/kotlin/psi/KtFileAnnotationList;", "getFamilyName", "getFileModifierForPreview", "target", "Lcom/intellij/psi/PsiFile;", "getText", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "isLambdaParameter", "suppressAnnotationText", "withAt", "suppressAtAnnotatedExpression", "Lorg/jetbrains/kotlin/idea/inspections/suppress/CaretBox;", "Lorg/jetbrains/kotlin/psi/KtAnnotatedExpression;", "suppressAtExpression", "caretBox", "Lorg/jetbrains/kotlin/psi/KtExpression;", "suppressAtFile", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "kotlin.base.code-insight"})
@SourceDebugExtension(value={"SMAP\nKotlinSuppressIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuppressIntentionAction.kt\norg/jetbrains/kotlin/idea/inspections/suppress/KotlinSuppressIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class KotlinSuppressIntentionAction
extends SuppressIntentionAction {
    @NotNull
    private final String suppressionKey;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final AnnotationHostKind kind;
    @NotNull
    private final SmartPsiElementPointer<KtElement> pointer;
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Project project;

    public KotlinSuppressIntentionAction(@NotNull KtElement suppressAt, @NotNull String suppressionKey, @NotNull AnnotationHostKind kind2) {
        Intrinsics.checkNotNullParameter((Object)suppressAt, (String)"suppressAt");
        Intrinsics.checkNotNullParameter((Object)suppressionKey, (String)"suppressionKey");
        Intrinsics.checkNotNullParameter((Object)kind2, (String)"kind");
        this.suppressionKey = suppressionKey;
        this.kind = kind2;
        this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)suppressAt));
        Project project2 = suppressAt.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBaseCodeInsightBundle.message("intention.suppress.family", new Object[0]);
    }

    @NotNull
    public String getText() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.suppressionKey;
        objectArray[1] = this.kind.getKind();
        String string = this.kind.getName();
        if (string == null) {
            string = "";
        }
        objectArray[2] = string;
        return KotlinBaseCodeInsightBundle.message("intention.suppress.text", objectArray);
    }

    public boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (this.isLambdaParameter(element3)) {
            return false;
        }
        return element3.isValid();
    }

    private final boolean isLambdaParameter(PsiElement element3) {
        KtParameter parentParameter;
        if (!Intrinsics.areEqual((Object)this.kind.getKind(), (Object)KotlinBaseCodeInsightBundle.message("declaration.kind.parameter", new Object[0]))) {
            return false;
        }
        PsiElement psiElement2 = element3.getParent();
        Object object = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
        if (object == null) {
            PsiElement psiElement3 = element3.getParent();
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = psiElement3 instanceof KtDestructuringDeclarationEntry ? (KtDestructuringDeclarationEntry)psiElement3 : null;
            psiElement2 = ktDestructuringDeclarationEntry != null && (ktDestructuringDeclarationEntry = ktDestructuringDeclarationEntry.getParent()) != null ? ktDestructuringDeclarationEntry.getParent() : null;
            object = psiElement2 instanceof KtParameter ? (KtParameter)psiElement2 : null;
        }
        KtParameter ktParameter = parentParameter = object;
        return ktParameter != null ? ktParameter.isLambdaParameter() : false;
    }

    public void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!element3.isValid()) {
            return;
        }
        KtElement ktElement = (KtElement)this.pointer.getElement();
        if (ktElement == null) {
            return;
        }
        KtElement suppressAt = ktElement;
        String suppressionKeyString = "\"" + this.suppressionKey + "\"";
        KtElement ktElement2 = suppressAt;
        if (ktElement2 instanceof KtModifierListOwner) {
            AnnotationModificationUtilsKt.addAnnotation$default((KtModifierListOwner)suppressAt, StandardClassIds.Annotations.INSTANCE.getSuppress(), suppressionKeyString, null, false, this.kind.getNewLineNeeded() ? "\n" : " ", (Function1)new Function1<KtAnnotationEntry, Boolean>(this, suppressionKeyString){
                final /* synthetic */ KotlinSuppressIntentionAction this$0;
                final /* synthetic */ String $suppressionKeyString;
                {
                    this.this$0 = $receiver;
                    this.$suppressionKeyString = $suppressionKeyString;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull KtAnnotationEntry entry) {
                    Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                    KotlinSuppressIntentionAction.access$addArgumentToSuppressAnnotation(this.this$0, entry, this.$suppressionKeyString);
                    return true;
                }
            }, 12, null);
        } else if (ktElement2 instanceof KtAnnotatedExpression) {
            this.suppressAtAnnotatedExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor2), suppressionKeyString);
        } else if (ktElement2 instanceof KtExpression) {
            this.suppressAtExpression(new CaretBox<KtExpression>((KtExpression)suppressAt, editor2), suppressionKeyString);
        } else if (ktElement2 instanceof KtFile) {
            this.suppressAtFile((KtFile)suppressAt, suppressionKeyString);
        }
    }

    @NotNull
    public KotlinSuppressIntentionAction getFileModifierForPreview(@NotNull PsiFile target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        PsiElement psiElement2 = PsiTreeUtil.findSameElementInCopy((PsiElement)this.pointer.getElement(), (PsiFile)target2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"findSameElementInCopy(...)");
        return new KotlinSuppressIntentionAction((KtElement)psiElement2, this.suppressionKey, this.kind);
    }

    private final void suppressAtFile(KtFile ktFile2, String id) {
        KtPsiFactory psiFactory = new KtPsiFactory(this.project, false, 2, null);
        KtFileAnnotationList fileAnnotationList = ktFile2.getFileAnnotationList();
        if (fileAnnotationList == null) {
            KtFileAnnotationList ktFileAnnotationList;
            KtFileAnnotationList newAnnotationList = psiFactory.createFileAnnotationListWithAnnotation(this.suppressAnnotationText(id, false));
            KtPackageDirective packageDirective = ktFile2.getPackageDirective();
            if (packageDirective != null && Intrinsics.areEqual((Object)PsiTreeUtil.skipWhitespacesForward((PsiElement)((PsiElement)packageDirective)), (Object)ktFile2.getImportList())) {
                PsiElement psiElement2 = ktFile2.addBefore((PsiElement)newAnnotationList, (PsiElement)packageDirective);
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFileAnnotationList");
                ktFileAnnotationList = (KtFileAnnotationList)psiElement2;
            } else {
                ktFileAnnotationList = PsiUtilsKt.replaceFileAnnotationList((KtFile)ktFile2, (KtFileAnnotationList)newAnnotationList);
            }
            KtFileAnnotationList createAnnotationList = ktFileAnnotationList;
            ktFile2.addAfter(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind), (PsiElement)createAnnotationList);
            return;
        }
        KtAnnotationEntry suppressAnnotation = this.findSuppressAnnotation(fileAnnotationList);
        if (suppressAnnotation == null) {
            KtAnnotationEntry newSuppressAnnotation = psiFactory.createFileAnnotation(this.suppressAnnotationText(id, false));
            fileAnnotationList.add(KotlinSuppressIntentionActionKt.access$createWhiteSpace(psiFactory, this.kind));
            PsiElement psiElement3 = fileAnnotationList.add((PsiElement)newSuppressAnnotation);
            Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            KtAnnotationEntry cfr_ignored_0 = (KtAnnotationEntry)psiElement3;
            return;
        }
        this.addArgumentToSuppressAnnotation(suppressAnnotation, id);
    }

    private final void suppressAtAnnotatedExpression(CaretBox<? extends KtAnnotatedExpression> suppressAt, String id) {
        KtAnnotationEntry entry = this.findSuppressAnnotation((KtAnnotated)suppressAt.getExpression());
        if (entry != null) {
            this.addArgumentToSuppressAnnotation(entry, id);
        } else {
            this.suppressAtExpression(suppressAt, id);
        }
    }

    private final void suppressAtExpression(CaretBox<? extends KtExpression> caretBox, String id) {
        boolean bl;
        KtExpression suppressAt = caretBox.getExpression();
        boolean bl2 = bl = !(suppressAt instanceof KtDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = false;
            String $i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22 = "Declarations should have been checked for above";
            throw new AssertionError((Object)$i$a$-assert-KotlinSuppressIntentionAction$suppressAtExpression$22);
        }
        String placeholderText = "PLACEHOLDER_ID";
        KtExpression annotatedExpression = new KtPsiFactory(this.project, false, 2, null).createExpression(KotlinSuppressIntentionAction.suppressAnnotationText$default(this, id, false, 2, null) + "\n" + placeholderText);
        PsiElement psiElement2 = suppressAt.copy();
        Intrinsics.checkNotNull((Object)psiElement2);
        PsiElement copy = psiElement2;
        PsiElement psiElement3 = suppressAt.replace((PsiElement)annotatedExpression);
        Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotatedExpression");
        KtAnnotatedExpression afterReplace = (KtAnnotatedExpression)psiElement3;
        PsiElement psiElement4 = afterReplace.findElementAt(afterReplace.getTextLength() - 2);
        Intrinsics.checkNotNull((Object)psiElement4);
        PsiElement toReplace = psiElement4;
        boolean bl3 = Intrinsics.areEqual((Object)toReplace.getText(), (Object)placeholderText);
        if (_Assertions.ENABLED && !bl3) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        PsiElement psiElement5 = toReplace.replace(copy);
        Intrinsics.checkNotNull((Object)psiElement5);
        PsiElement result2 = psiElement5;
        caretBox.positionCaretInCopy(result2);
    }

    private final void addArgumentToSuppressAnnotation(KtAnnotationEntry entry, String id) {
        KtValueArgumentList args = entry.getValueArgumentList();
        KtPsiFactory psiFactory = new KtPsiFactory(this.project, false, 2, null);
        KtValueArgumentList newArgList = psiFactory.createCallArguments("(" + id + ")");
        if (args == null) {
            entry.addAfter((PsiElement)newArgList, entry.getLastChild());
        } else if (args.getArguments().isEmpty()) {
            args.replace((PsiElement)newArgList);
        } else {
            args.addArgument((KtValueArgument)newArgList.getArguments().get(0));
        }
    }

    private final String suppressAnnotationText(String id, boolean withAt) {
        return (withAt ? "@" : "") + StandardNames.FqNames.suppress.shortName() + "(" + id + ")";
    }

    static /* synthetic */ String suppressAnnotationText$default(KotlinSuppressIntentionAction kotlinSuppressIntentionAction, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return kotlinSuppressIntentionAction.suppressAnnotationText(string, bl);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtAnnotated annotated) {
        return AnnotationModificationUtilsKt.findAnnotation$default(annotated, StandardClassIds.Annotations.INSTANCE.getSuppress(), null, false, 6, null);
    }

    private final KtAnnotationEntry findSuppressAnnotation(KtFileAnnotationList annotationList) {
        return AnnotationModificationUtilsKt.findAnnotation$default(annotationList, StandardClassIds.Annotations.INSTANCE.getSuppress(), null, false, 6, null);
    }

    public static final /* synthetic */ void access$addArgumentToSuppressAnnotation(KotlinSuppressIntentionAction $this, KtAnnotationEntry entry, String id) {
        $this.addArgumentToSuppressAnnotation(entry, id);
    }
}

