/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.refactoring.move.processor;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.refactoring.move.MoveMultipleElementsViewDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.base.util.FqNameUtils;
import org.jetbrains.kotlin.idea.core.PackageUtilsKt;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2ChangePackageDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.descriptor.K2MoveDescriptor;
import org.jetbrains.kotlin.idea.k2.refactoring.move.processor.MoveUtilKt$withChildDeclarations$;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a\"\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u001a$\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0007\u001a&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\n0\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\f\u0010\r\u001a\u00020\u0003*\u00020\u000eH\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u000eH\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0016H\u0000\u001a\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018*\u00020\nH\u0000\u00a8\u0006\u0019"}, d2={"createKotlinFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "fileName", "", "targetDir", "Lcom/intellij/psi/PsiDirectory;", "packageName", "getOrCreateKotlinFile", "moveInto", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "", "targetFile", "presentablePkgName", "Lorg/jetbrains/kotlin/name/FqName;", "updatePackageDirective", "", "destination", "pkgName", "usageViewDescriptor", "Lcom/intellij/refactoring/move/MoveMultipleElementsViewDescriptor;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2ChangePackageDescriptor;", "Lorg/jetbrains/kotlin/idea/k2/refactoring/move/descriptor/K2MoveDescriptor;", "withChildDeclarations", "", "kotlin.refactorings.move.k2"})
@SourceDebugExtension(value={"SMAP\nmoveUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 moveUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/MoveUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1855#2,2:80\n309#3,15:82\n229#3,2:97\n241#3:99\n328#3:100\n37#4,2:101\n37#4,2:103\n1#5:105\n*S KotlinDebug\n*F\n+ 1 moveUtil.kt\norg/jetbrains/kotlin/idea/k2/refactoring/move/processor/MoveUtilKt\n*L\n22#1:80,2\n32#1:82,15\n32#1:97,2\n32#1:99\n32#1:100\n35#1:101,2\n39#1:103,2\n*E\n"})
public final class MoveUtilKt {
    @NotNull
    public static final Map<KtNamedDeclaration, KtNamedDeclaration> moveInto(@NotNull Iterable<? extends KtNamedDeclaration> $this$moveInto, @NotNull KtFile targetFile2) {
        Intrinsics.checkNotNullParameter($this$moveInto, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetFile2, (String)"targetFile");
        Map oldToNewMap = new LinkedHashMap();
        Iterable<? extends KtNamedDeclaration> $this$forEach$iv = $this$moveInto;
        boolean $i$f$forEach = false;
        Iterator<? extends KtNamedDeclaration> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            KtNamedDeclaration element$iv;
            KtNamedDeclaration oldMovedDeclaration = element$iv = iterator2.next();
            boolean bl = false;
            PsiElement psiElement2 = targetFile2.add((PsiElement)oldMovedDeclaration);
            Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedDeclaration");
            KtNamedDeclaration newMovedDeclaration = (KtNamedDeclaration)psiElement2;
            for (Pair pair : CollectionsKt.zip((Iterable)MoveUtilKt.withChildDeclarations(oldMovedDeclaration), (Iterable)MoveUtilKt.withChildDeclarations(newMovedDeclaration))) {
                KtNamedDeclaration oldChild = (KtNamedDeclaration)pair.component1();
                KtNamedDeclaration newChild = (KtNamedDeclaration)pair.component2();
                oldToNewMap.put(oldChild, newChild);
            }
        }
        return oldToNewMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtNamedDeclaration> withChildDeclarations(@NotNull KtNamedDeclaration $this$withChildDeclarations) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$withChildDeclarations, (String)"<this>");
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)$this$withChildDeclarations;
        Function1 predicate$iv = withChildDeclarations$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement psiElement2 = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var9_9 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtNamedDeclaration, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement it = element3;
                boolean bl = false;
                super.visitElement(element3);
                if (element3 instanceof KtNamedDeclaration) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
        return CollectionsKt.plus((Collection)CollectionsKt.toList((Iterable)((List)to$iv$iv$iv)), (Object)$this$withChildDeclarations);
    }

    @NotNull
    public static final MoveMultipleElementsViewDescriptor usageViewDescriptor(@NotNull K2ChangePackageDescriptor $this$usageViewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$usageViewDescriptor, (String)"<this>");
        Collection $this$toTypedArray$iv = $this$usageViewDescriptor.getFiles();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new MoveMultipleElementsViewDescriptor((PsiElement[])thisCollection$iv.toArray(new KtFile[0]), MoveUtilKt.presentablePkgName($this$usageViewDescriptor.getTarget()));
    }

    @NotNull
    public static final MoveMultipleElementsViewDescriptor usageViewDescriptor(@NotNull K2MoveDescriptor $this$usageViewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$usageViewDescriptor, (String)"<this>");
        Collection $this$toTypedArray$iv = $this$usageViewDescriptor.getSource().getElements();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new MoveMultipleElementsViewDescriptor(thisCollection$iv.toArray(new PsiElement[0]), MoveUtilKt.presentablePkgName($this$usageViewDescriptor.getTarget().getPkgName()));
    }

    @NotNull
    public static final String presentablePkgName(@NotNull FqName $this$presentablePkgName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$presentablePkgName, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$presentablePkgName.asString(), (Object)"")) {
            String string2 = JavaAnalysisBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = $this$presentablePkgName.asString();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asString(...)");
        }
        return string;
    }

    public static final void updatePackageDirective(@NotNull KtFile $this$updatePackageDirective, @NotNull FqName pkgName) {
        block1: {
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$updatePackageDirective, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)pkgName, (String)"pkgName");
                if (!pkgName.isRoot()) break block0;
                KtPackageDirective ktPackageDirective = $this$updatePackageDirective.getPackageDirective();
                if (ktPackageDirective == null) break block1;
                ktPackageDirective.delete();
                break block1;
            }
            Project project2 = $this$updatePackageDirective.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            KtPackageDirective newPackageDirective = new KtPsiFactory(project2, false, 2, null).createPackageDirective(FqNameUtils.quoteIfNeeded(pkgName));
            KtPackageDirective ktPackageDirective = $this$updatePackageDirective.getPackageDirective();
            if (ktPackageDirective == null) break block1;
            ktPackageDirective.replace((PsiElement)newPackageDirective);
        }
    }

    public static final void updatePackageDirective(@NotNull KtFile $this$updatePackageDirective, @NotNull PsiDirectory destination) {
        Intrinsics.checkNotNullParameter((Object)$this$updatePackageDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        MoveUtilKt.updatePackageDirective($this$updatePackageDirective, PackageUtilsKt.getFqNameWithImplicitPrefixOrRoot(destination));
    }

    @JvmOverloads
    @NotNull
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        PsiFile psiFile2 = targetDir.findFile(fileName);
        if (psiFile2 == null) {
            psiFile2 = (PsiFile)MoveUtilKt.createKotlinFile(fileName, targetDir, packageName);
        }
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return (KtFile)psiFile2;
    }

    public static /* synthetic */ KtFile getOrCreateKotlinFile$default(String string, PsiDirectory psiDirectory, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            FqName fqName2 = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory);
            string2 = fqName2 != null ? fqName2.asString() : null;
        }
        return MoveUtilKt.getOrCreateKotlinFile(string, psiDirectory, string2);
    }

    @NotNull
    public static final KtFile createKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir, @Nullable String packageName) {
        Object object;
        FqName fqName2;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        targetDir.checkCreateFile(fileName);
        String string = packageName;
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            fqName2 = new FqName(p0);
        } else {
            fqName2 = FqName.ROOT;
        }
        FqName packageFqName = fqName2;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)targetDir.getProject());
        FileType fileType = (FileType)KotlinFileType.INSTANCE;
        if (!packageFqName.isRoot()) {
            Intrinsics.checkNotNull((Object)packageFqName);
            object = "package " + FqNameUtils.quoteIfNeeded(packageFqName) + " \n\n";
        } else {
            object = "";
        }
        PsiFile psiFile2 = psiFileFactory.createFileFromText(fileName, fileType, (CharSequence)object);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"createFileFromText(...)");
        PsiFile file2 = psiFile2;
        PsiElement psiElement2 = targetDir.add((PsiElement)file2);
        Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        return (KtFile)psiElement2;
    }

    public static /* synthetic */ KtFile createKotlinFile$default(String string, PsiDirectory psiDirectory, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            FqName fqName2 = PackageUtilsKt.getFqNameWithImplicitPrefix(psiDirectory);
            string2 = fqName2 != null ? fqName2.asString() : null;
        }
        return MoveUtilKt.createKotlinFile(string, psiDirectory, string2);
    }

    @JvmOverloads
    @NotNull
    public static final KtFile getOrCreateKotlinFile(@NotNull String fileName, @NotNull PsiDirectory targetDir) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        return MoveUtilKt.getOrCreateKotlinFile$default(fileName, targetDir, null, 4, null);
    }
}

