/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomGoal;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginExecution;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.idea.base.codeInsight.tooling.IdePlatformKindToolingKt;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.inspections.KotlinMavenPluginPhaseInspectionKt;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.JvmIdePlatformKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\f\r\u000e\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "getStaticDescription", "", "AddExecutionLocalFix", "AddJavaExecutionsLocalFix", "ConfigurePluginExecutionLocalFix", "FixAddStdlibLocalFix", "FixExecutionPhaseLocalFix", "Holder", "kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinMavenPluginPhaseInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenPluginPhaseInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n766#2:272\n857#2,2:273\n1360#2:275\n1446#2,5:276\n1446#2,5:281\n1855#2:286\n288#2,2:287\n1856#2:289\n1855#2:290\n223#2,2:291\n1856#2:293\n1855#2,2:294\n1855#2,2:296\n766#2:298\n857#2:299\n1747#2,3:300\n1747#2,3:303\n858#2:306\n1855#2,2:307\n*S KotlinDebug\n*F\n+ 1 KotlinMavenPluginPhaseInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection\n*L\n54#1:272\n54#1:273,2\n55#1:275\n55#1:276,5\n56#1:281,5\n82#1:286\n84#1:287,2\n82#1:289\n106#1:290\n108#1:291,2\n106#1:293\n145#1:294,2\n157#1:296,2\n167#1:298\n167#1:299\n168#1:300,3\n170#1:303,3\n167#1:306\n173#1:307,2\n*E\n"})
public final class KotlinMavenPluginPhaseInspection
extends DomElementsInspection<MavenDomProjectModel> {
    public KotlinMavenPluginPhaseInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getStaticDescription() {
        return KotlinMavenBundle.message("inspection.description", new Object[0]);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        v0 = domFileElement.getModule();
        if (v0 == null) {
            return;
        }
        module = v0;
        manager = MavenProjectsManager.getInstance((Project)module.getProject());
        v1 = manager.findProject(module);
        if (v1 == null) {
            return;
        }
        mavenProject = v1;
        v2 = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getFile(...)");
        v3 = PomFile.Companion.forFileOrNull(v2);
        if (v3 == null) {
            return;
        }
        pom = v3;
        hasJavaFiles = KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(module);
        v4 = mavenProject.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getPlugins(...)");
        var9_8 = v4;
        $i$f$filter = false;
        var11_12 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$executions$1 = false;
            Intrinsics.checkNotNull((Object)it);
            if (!KotlinMavenPluginPhaseInspectionKt.access$isKotlinMavenPlugin(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (MavenPlugin)element$iv$iv;
            $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = false;
            v5 = it.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getExecutions(...)");
            list$iv$iv = v5;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        executions = (List)destination$iv$iv;
        $i$f$flatMap = executions;
        destination$iv = new HashSet<E>();
        $i$f$flatMapTo = false;
        for (T element$iv : $this$flatMapTo$iv) {
            it = (MavenPlugin.Execution)element$iv;
            $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = false;
            v6 = it.getGoals();
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getGoals(...)");
            list$iv = v6;
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        allGoalsSet = (Set)destination$iv;
        hasJvmExecution = allGoalsSet.contains("compile") != false || allGoalsSet.contains("test-compile") != false;
        hasJsExecution = allGoalsSet.contains("js") != false || allGoalsSet.contains("test-js") != false;
        pomKotlinPlugins = pom.findKotlinPlugins();
        for (MavenDomPlugin kotlinPlugin : pomKotlinPlugins) {
            if (!allGoalsSet.contains("compile") && !allGoalsSet.contains("js")) {
                if (hasJavaFiles) {
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = new AddExecutionLocalFix[1];
                    v7 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getFile(...)");
                    Intrinsics.checkNotNull((Object)kotlinPlugin);
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1[0] = new AddExecutionLocalFix(v7, module, kotlinPlugin, "compile");
                    v8 = $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1;
                } else {
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1 = new AddExecutionLocalFix[2];
                    v9 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getFile(...)");
                    Intrinsics.checkNotNull((Object)kotlinPlugin);
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1[0] = new AddExecutionLocalFix(v9, module, kotlinPlugin, "compile");
                    v10 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getFile(...)");
                    $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1[1] = new AddExecutionLocalFix(v10, module, kotlinPlugin, "js");
                    v8 = $i$a$-flatMapTo-KotlinMavenPluginPhaseInspection$checkFileElement$allGoalsSet$1;
                }
                fixes /* !! */  = v8;
                holder.createProblem(kotlinPlugin.getArtifactId().createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.no.executions", new Object[0]), (LocalQuickFix[])Arrays.copyOf(fixes /* !! */ , fixes /* !! */ .length));
                continue;
            }
            if (hasJavaFiles) {
                Intrinsics.checkNotNull((Object)kotlinPlugin);
                fixes /* !! */  = new String[]{"compile"};
                fixes /* !! */  = KotlinMavenPluginPhaseInspectionKt.access$notAtPhase(pom.findExecutions(kotlinPlugin, fixes /* !! */ ), "process-sources");
                $i$f$forEach = false;
                $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = $this$forEach$iv.iterator();
                while ($i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.hasNext()) {
                    block33: {
                        element$iv = $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.next();
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$1 = false;
                        javacPlugin /* !! */  = mavenProject.findPlugin("org.apache.maven.plugins", "maven-compiler-plugin");
                        v11 = pom.getDomModel().getBuild().getPlugins().getPlugins();
                        Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"getPlugins(...)");
                        $this$firstOrNull$iv = (LocalQuickFix[])v11;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (MavenDomPlugin)element$iv;
                            $i$a$-firstOrNull-KotlinMavenPluginPhaseInspection$checkFileElement$1$existingJavac$1 = false;
                            v12 = Intrinsics.areEqual((Object)it.getGroupId().getStringValue(), (Object)"org.apache.maven.plugins") && Intrinsics.areEqual((Object)it.getArtifactId().getStringValue(), (Object)"maven-compiler-plugin");
                            if (!v12) continue;
                            v13 = element$iv;
                            break block33;
                        }
                        v13 = null;
                    }
                    existingJavac = v13;
                    if (existingJavac != null && pom.isPluginAfter(existingJavac, kotlinPlugin)) {
                        v14 = pom.findExecution(javacPlugin /* !! */ , "default-compile");
                        if (Intrinsics.areEqual((Object)(v14 != null ? v14.getPhase() : null), (Object)"none")) {
                            v15 = pom.findExecution(javacPlugin /* !! */ , "default-testCompile");
                            if (Intrinsics.areEqual((Object)(v15 != null ? v15.getPhase() : null), (Object)"none") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-compile", "compile") && !pom.isPluginExecutionMissing(javacPlugin /* !! */ , "default-testCompile", "testCompile")) continue;
                        }
                    }
                    v16 = badExecution.getPhase().createStableCopy();
                    v17 = KotlinMavenBundle.message("inspection.should.run.before.javac", new Object[0]);
                    $this$firstOrNull$iv = new LocalQuickFix[2];
                    $this$firstOrNull$iv[0] = new FixExecutionPhaseLocalFix(badExecution, "process-sources");
                    v18 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"getFile(...)");
                    $this$firstOrNull$iv[1] = new AddJavaExecutionsLocalFix(module, v18, kotlinPlugin);
                    holder.createProblem(v16, HighlightSeverity.WARNING, v17, $this$firstOrNull$iv);
                }
                $this$forEach$iv = new String[]{"js", "test-js"};
                $this$forEach$iv = pom.findExecutions(kotlinPlugin, (String[])$this$forEach$iv);
                $i$f$forEach = false;
                $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2 = $this$forEach$iv.iterator();
                while ($i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.hasNext()) {
                    block34: {
                        element$iv = $i$a$-flatMap-KotlinMavenPluginPhaseInspection$checkFileElement$executions$2.next();
                        badExecution = (MavenDomPluginExecution)element$iv;
                        $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = false;
                        v19 = badExecution.getGoals().getGoals();
                        Intrinsics.checkNotNullExpressionValue((Object)v19, (String)"getGoals(...)");
                        javacPlugin /* !! */  = v19;
                        $this$firstOrNull$iv = holder;
                        $i$f$first = false;
                        for (T element$iv : $this$first$iv) {
                            it = (MavenDomGoal)element$iv;
                            $i$a$-first-KotlinMavenPluginPhaseInspection$checkFileElement$2$1 = false;
                            Intrinsics.checkNotNull((Object)it);
                            if (!KotlinMavenPluginPhaseInspectionKt.access$isJsGoal((MavenDomGoal)it)) continue;
                            break block34;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    $this$firstOrNull$iv.createProblem(((MavenDomGoal)element$iv).createStableCopy(), HighlightSeverity.WARNING, KotlinMavenBundle.message("inspection.javascript.in.java.module", new Object[0]));
                }
            }
            if (hasJvmExecution && PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null).isEmpty()) {
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib"), (String)"findDependencies(...)");
                if (stdlibDependencies.isEmpty()) {
                    v20 = kotlinPlugin.getArtifactId().createStableCopy();
                    $i$f$forEach = new Object[]{"kotlin-stdlib"};
                    v21 = KotlinMavenBundle.message("inspection.jvm.no.stdlib.dependency", $i$f$forEach);
                    $i$f$forEach = new LocalQuickFix[1];
                    v22 = domFileElement.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"getFile(...)");
                    $i$f$forEach[0] = new FixAddStdlibLocalFix(v22, "kotlin-stdlib", kotlinPlugin.getVersion().getRawText());
                    holder.createProblem(v20, HighlightSeverity.WARNING, v21, (LocalQuickFix[])$i$f$forEach);
                }
            }
            if (!hasJsExecution || !PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null).isEmpty()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)mavenProject.findDependencies("org.jetbrains.kotlin", "kotlin-stdlib-js"), (String)"findDependencies(...)");
            if (!jsDependencies.isEmpty()) continue;
            v23 = kotlinPlugin.getArtifactId().createStableCopy();
            $i$f$forEach = new Object[]{"kotlin-stdlib-js"};
            v24 = KotlinMavenBundle.message("inspection.javascript.no.stdlib.dependency", $i$f$forEach);
            $i$f$forEach = new LocalQuickFix[1];
            v25 = domFileElement.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)v25, (String)"getFile(...)");
            $i$f$forEach[0] = new FixAddStdlibLocalFix(v25, "kotlin-stdlib-js", kotlinPlugin.getVersion().getRawText());
            holder.createProblem(v23, HighlightSeverity.WARNING, v24, (LocalQuickFix[])$i$f$forEach);
        }
        jvmStdlibDependencies = PomFile.findDependencies$default(pom, Holder.INSTANCE.getJVM_STDLIB_IDS(), null, 2, null);
        if (!hasJvmExecution && ((Collection)jvmStdlibDependencies).isEmpty() == false) {
            $this$forEach$iv = jvmStdlibDependencies;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                dep = (MavenDomDependency)element$iv;
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$3 = false;
                v26 = dep.getArtifactId().createStableCopy();
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)dep.getArtifactId(), (String)"getArtifactId(...)");
                v27 = KotlinMavenBundle.message("inspection.configured.no.execution", $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2);
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2 = new LocalQuickFix[1];
                v28 = domFileElement.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)v28, (String)"getFile(...)");
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2[0] = new ConfigurePluginExecutionLocalFix(module, v28, "compile", dep.getVersion().getRawText());
                holder.createProblem(v26, HighlightSeverity.WARNING, v27, (LocalQuickFix[])$i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$2);
            }
        }
        stdlibJsDependencies = PomFile.findDependencies$default(pom, Holder.INSTANCE.getJS_STDLIB_MAVEN_ID(), null, 2, null);
        if (!hasJsExecution && ((Collection)stdlibJsDependencies).isEmpty() == false) {
            $this$forEach$iv = stdlibJsDependencies;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                dep = (MavenDomDependency)element$iv;
                $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$4 = false;
                v29 = dep.getArtifactId().createStableCopy();
                $this$first$iv = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)dep.getArtifactId(), (String)"getArtifactId(...)");
                v30 = KotlinMavenBundle.message("inspection.configured.no.execution", $this$first$iv);
                $this$first$iv = new LocalQuickFix[1];
                v31 = domFileElement.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)v31, (String)"getFile(...)");
                $this$first$iv[0] = new ConfigurePluginExecutionLocalFix(module, v31, "js", dep.getVersion().getRawText());
                holder.createProblem(v29, HighlightSeverity.WARNING, v30, (LocalQuickFix[])$this$first$iv);
            }
        }
        $this$filter$iv = pom.findKotlinExecutions();
        $i$f$filter = false;
        element$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            block36: {
                block35: {
                    it = (MavenDomPluginExecution)element$iv$iv;
                    $i$a$-filter-KotlinMavenPluginPhaseInspection$checkFileElement$5 = false;
                    v32 = it.getGoals().getGoals();
                    Intrinsics.checkNotNullExpressionValue((Object)v32, (String)"getGoals(...)");
                    $this$any$iv = v32;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v33 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            goal = (MavenDomGoal)element$iv;
                            $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$1 = false;
                            if (!(Intrinsics.areEqual((Object)goal.getRawText(), (Object)"compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"js") != false)) continue;
                            v33 = true;
                            break block35;
                        }
                        v33 = false;
                    }
                }
                if (!v33) ** GOTO lbl-1000
                v34 = it.getGoals().getGoals();
                Intrinsics.checkNotNullExpressionValue((Object)v34, (String)"getGoals(...)");
                $this$any$iv = v34;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v35 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        goal = (MavenDomGoal)element$iv;
                        $i$a$-any-KotlinMavenPluginPhaseInspection$checkFileElement$5$2 = false;
                        if (!(Intrinsics.areEqual((Object)goal.getRawText(), (Object)"test-compile") != false || Intrinsics.areEqual((Object)goal.getRawText(), (Object)"test-js") != false)) continue;
                        v35 = true;
                        break block36;
                    }
                    v35 = false;
                }
            }
            if (v35) {
                v36 = true;
            } else lbl-1000:
            // 2 sources

            {
                v36 = false;
            }
            if (!v36) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            badExecution = (MavenDomPluginExecution)element$iv;
            $i$a$-forEach-KotlinMavenPluginPhaseInspection$checkFileElement$6 = false;
            holder.createProblem(badExecution.getGoals().createStableCopy(), HighlightSeverity.WEAK_WARNING, KotlinMavenBundle.message("inspection.same.execution.compile.test", new Object[0]));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "file", "Lcom/intellij/psi/xml/XmlFile;", "module", "Lcom/intellij/openapi/module/Module;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "goal", "", "(Lcom/intellij/psi/xml/XmlFile;Lcom/intellij/openapi/module/Module;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class AddExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final String goal;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public AddExecutionLocalFix(@NotNull XmlFile file2, @NotNull Module module2, @NotNull MavenDomPlugin kotlinPlugin, @NotNull String goal) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
            Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
            this.module = module2;
            this.kotlinPlugin = kotlinPlugin;
            this.goal = goal;
            this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)file2));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.goal};
            return KotlinMavenBundle.message("fix.add.execution.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            XmlFile xmlFile = (XmlFile)this.pointer.getElement();
            if (xmlFile == null) {
                return;
            }
            XmlFile file2 = xmlFile;
            PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
            if (pomFile != null) {
                pomFile.addKotlinExecution(this.module, this.kotlinPlugin, this.goal, PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$AddJavaExecutionsLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/xml/XmlFile;", "kotlinPlugin", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;)V", "getKotlinPlugin", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPlugin;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.maven"})
    private static final class AddJavaExecutionsLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final MavenDomPlugin kotlinPlugin;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public AddJavaExecutionsLocalFix(@NotNull Module module2, @NotNull XmlFile file2, @NotNull MavenDomPlugin kotlinPlugin) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)kotlinPlugin, (String)"kotlinPlugin");
            this.module = module2;
            this.kotlinPlugin = kotlinPlugin;
            this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)file2));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final MavenDomPlugin getKotlinPlugin() {
            return this.kotlinPlugin;
        }

        @NotNull
        public String getName() {
            return KotlinMavenBundle.message("fix.add.java.executions.name", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                pomFile.addJavacExecutions(this.module, this.kotlinPlugin);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$ConfigurePluginExecutionLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "goal", "", "version", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getGoal", "()Ljava/lang/String;", "getModule", "()Lcom/intellij/openapi/module/Module;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class ConfigurePluginExecutionLocalFix
    implements LocalQuickFix {
        @NotNull
        private final Module module;
        @NotNull
        private final String goal;
        @Nullable
        private final String version;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public ConfigurePluginExecutionLocalFix(@NotNull Module module2, @NotNull XmlFile xmlFile, @NotNull String goal, @Nullable String version2) {
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
            Intrinsics.checkNotNullParameter((Object)goal, (String)"goal");
            this.module = module2;
            this.goal = goal;
            this.version = version2;
            this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)xmlFile));
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final String getGoal() {
            return this.goal;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.goal};
            return KotlinMavenBundle.message("fix.configure.plugin.execution.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.configure.plugin.execution.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                PomFile pom2 = pomFile;
                boolean bl = false;
                MavenDomPlugin plugin = pom2.addKotlinPlugin(this.version);
                pom2.addKotlinExecution(this.module, plugin, "compile", PomFile.Companion.getPhase(KotlinMavenPluginPhaseInspectionKt.hasJavaFiles(this.module), false), false, CollectionsKt.listOf((Object)this.goal));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixAddStdlibLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pomFile", "Lcom/intellij/psi/xml/XmlFile;", "id", "", "version", "(Lcom/intellij/psi/xml/XmlFile;Ljava/lang/String;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getVersion", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixAddStdlibLocalFix
    implements LocalQuickFix {
        @NotNull
        private final String id;
        @Nullable
        private final String version;
        @NotNull
        private final SmartPsiElementPointer<XmlFile> pointer;

        public FixAddStdlibLocalFix(@NotNull XmlFile pomFile, @NotNull String id, @Nullable String version2) {
            Intrinsics.checkNotNullParameter((Object)pomFile, (String)"pomFile");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.version = version2;
            this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)pomFile));
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.id};
            return KotlinMavenBundle.message("fix.add.stdlib.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.add.stdlib.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlFile xmlFile = (XmlFile)this.pointer.getElement();
                if (xmlFile == null) {
                    return;
                }
                XmlFile file2 = xmlFile;
                PomFile pomFile = PomFile.Companion.forFileOrNull(file2);
                if (pomFile == null) break block1;
                PomFile.addDependency$default(pomFile, new MavenId("org.jetbrains.kotlin", this.id, this.version), MavenArtifactScope.COMPILE, null, false, null, 28, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$FixExecutionPhaseLocalFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "execution", "Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "newPhase", "", "(Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;Ljava/lang/String;)V", "getExecution", "()Lorg/jetbrains/idea/maven/dom/model/MavenDomPluginExecution;", "getNewPhase", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "kotlin.maven"})
    private static final class FixExecutionPhaseLocalFix
    implements LocalQuickFix {
        @NotNull
        private final MavenDomPluginExecution execution;
        @NotNull
        private final String newPhase;

        public FixExecutionPhaseLocalFix(@NotNull MavenDomPluginExecution execution, @NotNull String newPhase) {
            Intrinsics.checkNotNullParameter((Object)execution, (String)"execution");
            Intrinsics.checkNotNullParameter((Object)newPhase, (String)"newPhase");
            this.execution = execution;
            this.newPhase = newPhase;
        }

        @NotNull
        public final MavenDomPluginExecution getExecution() {
            return this.execution;
        }

        @NotNull
        public final String getNewPhase() {
            return this.newPhase;
        }

        @NotNull
        public String getName() {
            Object[] objectArray = new Object[]{this.newPhase};
            return KotlinMavenBundle.message("fix.execution.phase.name", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return KotlinMavenBundle.message("fix.execution.phase.family", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            this.execution.getPhase().setValue((Object)this.newPhase);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$Holder;", "", "()V", "JS_STDLIB_MAVEN_ID", "Lorg/jetbrains/idea/maven/model/MavenId;", "getJS_STDLIB_MAVEN_ID", "()Lorg/jetbrains/idea/maven/model/MavenId;", "JVM_STDLIB_IDS", "", "getJVM_STDLIB_IDS", "()Ljava/util/List;", "kotlin.maven"})
    @SourceDebugExtension(value={"SMAP\nKotlinMavenPluginPhaseInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenPluginPhaseInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$Holder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1549#2:272\n1620#2,3:273\n*S KotlinDebug\n*F\n+ 1 KotlinMavenPluginPhaseInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/KotlinMavenPluginPhaseInspection$Holder\n*L\n37#1:272\n37#1:273,3\n*E\n"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE;
        @NotNull
        private static final List<MavenId> JVM_STDLIB_IDS;
        @NotNull
        private static final MavenId JS_STDLIB_MAVEN_ID;

        private Holder() {
        }

        @NotNull
        public final List<MavenId> getJVM_STDLIB_IDS() {
            return JVM_STDLIB_IDS;
        }

        @NotNull
        public final MavenId getJS_STDLIB_MAVEN_ID() {
            return JS_STDLIB_MAVEN_ID;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void $this$mapTo$iv$iv;
            INSTANCE = new Holder();
            Iterable $this$map$iv = IdePlatformKindToolingKt.getTooling((IdePlatformKind)JvmIdePlatformKind.INSTANCE).getMavenLibraryIds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new MavenId("org.jetbrains.kotlin", (String)it, null));
            }
            JVM_STDLIB_IDS = (List)var3_3;
            JS_STDLIB_MAVEN_ID = new MavenId("org.jetbrains.kotlin", "kotlin-stdlib-js", null);
        }
    }
}

