/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.projectView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractPsiBasedNode;
import com.intellij.ide.projectView.impl.nodes.FileNodeWithNestedFileNodes;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.projectView.KtDeclarationTreeNode;
import org.jetbrains.kotlin.idea.projectView.KtFileTreeNodeKt;
import org.jetbrains.kotlin.idea.projectView.ProjectViewProvidersKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B!\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB1\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u000fH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0014J\u0012\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/projectView/KtClassOrObjectTreeNode;", "Lcom/intellij/ide/projectView/impl/nodes/AbstractPsiBasedNode;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "Lcom/intellij/ide/projectView/impl/nodes/FileNodeWithNestedFileNodes;", "project", "Lcom/intellij/openapi/project/Project;", "ktClassOrObject", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/ide/projectView/ViewSettings;)V", "nestedFileNodes", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lcom/intellij/ide/projectView/ViewSettings;Ljava/util/Collection;)V", "canRepresent", "", "element", "", "canRepresentPsiElement", "expandOnDoubleClick", "extractPsiFromValue", "Lcom/intellij/psi/PsiElement;", "getChildrenImpl", "getNestedFileNodes", "getWeight", "", "isDeprecated", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "kotlin.base.project-structure"})
public final class KtClassOrObjectTreeNode
extends AbstractPsiBasedNode<KtClassOrObject>
implements FileNodeWithNestedFileNodes {
    @NotNull
    private final Collection<AbstractTreeNode<?>> nestedFileNodes;

    public KtClassOrObjectTreeNode(@Nullable Project project2, @NotNull KtClassOrObject ktClassOrObject, @NotNull ViewSettings viewSettings, @NotNull Collection<? extends AbstractTreeNode<?>> nestedFileNodes) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter(nestedFileNodes, (String)"nestedFileNodes");
        super(project2, (Object)ktClassOrObject, viewSettings);
        this.nestedFileNodes = nestedFileNodes;
    }

    public KtClassOrObjectTreeNode(@Nullable Project project2, @NotNull KtClassOrObject ktClassOrObject, @NotNull ViewSettings viewSettings) {
        Intrinsics.checkNotNullParameter((Object)ktClassOrObject, (String)"ktClassOrObject");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        this(project2, ktClassOrObject, viewSettings, CollectionsKt.emptyList());
    }

    @Nullable
    protected PsiElement extractPsiFromValue() {
        return (PsiElement)this.getValue();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getNestedFileNodes() {
        return this.nestedFileNodes;
    }

    @NotNull
    protected Collection<AbstractTreeNode<?>> getChildrenImpl() {
        Collection collection;
        if (this.getValue() != null && this.getSettings().isShowMembers()) {
            Object object = this.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            Collection collection2 = ProjectViewProvidersKt.getStructureDeclarations((KtClassOrObject)object);
            ViewSettings viewSettings = this.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings, (String)"getSettings(...)");
            collection = CollectionsKt.plus(this.nestedFileNodes, (Iterable)KtFileTreeNodeKt.toNodes(collection2, viewSettings));
        } else {
            collection = this.nestedFileNodes;
        }
        return collection;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            KtClassOrObject ktClassOrObject = (KtClassOrObject)this.getValue();
            if (ktClassOrObject == null) break block0;
            KtClassOrObject it = ktClassOrObject;
            boolean bl = false;
            data.setPresentableText(KtDeclarationTreeNode.Companion.tryGetRepresentableText$default(KtDeclarationTreeNode.Companion, (KtDeclaration)it, false, false, false, 14, null));
        }
    }

    protected boolean isDeprecated() {
        return KtPsiUtil.isDeprecated((KtModifierListOwner)((KtModifierListOwner)this.getValue()));
    }

    public boolean canRepresent(@Nullable Object element3) {
        if (!this.isValid()) {
            return false;
        }
        return super.canRepresent(element3) || this.canRepresentPsiElement(element3);
    }

    private final boolean canRepresentPsiElement(Object element3) {
        if (this.getValue() == null || !((KtClassOrObject)this.getValue()).isValid()) {
            return false;
        }
        if (this.getValue() == element3) {
            return true;
        }
        PsiFile psiFile2 = ((KtClassOrObject)this.getValue()).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
        PsiFile file2 = psiFile2;
        Object object = element3;
        return Intrinsics.areEqual((Object)object, (Object)file2) ? true : (object instanceof VirtualFile ? Intrinsics.areEqual((Object)element3, (Object)file2.getVirtualFile()) : (object instanceof PsiElement ? !this.getSettings().isShowMembers() && Intrinsics.areEqual((Object)file2, (Object)((PsiElement)element3).getContainingFile()) : false));
    }

    public boolean expandOnDoubleClick() {
        return false;
    }

    public int getWeight() {
        return 20;
    }
}

