/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.quickfix.ArrayAccessorImportFix;
import org.jetbrains.kotlin.idea.quickfix.ImportFixBase;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ImportForMissingOperatorFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase$Factory;", "()V", "createImportAction", "Lorg/jetbrains/kotlin/idea/quickfix/ImportFixBase;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class ImportForMissingOperatorFactory
extends ImportFixBase.Factory {
    @NotNull
    public static final ImportForMissingOperatorFactory INSTANCE = new ImportForMissingOperatorFactory();

    private ImportForMissingOperatorFactory() {
    }

    @Override
    @Nullable
    public ImportFixBase<?> createImportAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        KtExpression ktExpression = psiElement2 instanceof KtExpression ? (KtExpression)psiElement2 : null;
        if (ktExpression == null) {
            return null;
        }
        KtExpression element3 = ktExpression;
        Object object = ((DiagnosticWithParameters2)Errors.OPERATOR_MODIFIER_REQUIRED.cast((UnboundDiagnostic)diagnostic)).getA();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
        FunctionDescriptor operatorDescriptor = (FunctionDescriptor)object;
        Name name2 = operatorDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        Name name3 = name2;
        if ((Intrinsics.areEqual((Object)name3, (Object)OperatorNameConventions.GET) ? true : Intrinsics.areEqual((Object)name3, (Object)OperatorNameConventions.SET)) && element3 instanceof KtArrayAccessExpression) {
            List list2 = CollectionsKt.listOf((Object)name3);
            return new ArrayAccessorImportFix(element3, list2){
                @NotNull
                private final Set<DiagnosticFactory2<PsiElement, FunctionDescriptor, String>> supportedErrors;
                {
                    this.supportedErrors = SetsKt.setOf((Object)Errors.OPERATOR_MODIFIER_REQUIRED);
                }

                @NotNull
                protected Set<DiagnosticFactory2<PsiElement, FunctionDescriptor, String>> getSupportedErrors() {
                    return this.supportedErrors;
                }
            };
        }
        return null;
    }
}

