/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.quickfixes.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.SurroundWithNullCheckUtils;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.KtReferenceKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0003\u0014\u0015\u0016B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J#\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0094\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/quickfixes/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "expression", "nullableExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "nullableExpressionPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "IteratorOnNullableFactory", "TypeMismatchFactory", "kotlin.idea"})
public final class SurroundWithNullCheckFix
extends KotlinQuickFixAction<KtExpression>
implements HighPriorityAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SmartPsiElementPointer<KtExpression> nullableExpressionPointer;

    public SurroundWithNullCheckFix(@NotNull KtExpression expression2, @NotNull KtExpression nullableExpression) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)nullableExpression, (String)"nullableExpression");
        super((PsiElement)expression2);
        this.nullableExpressionPointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)nullableExpression));
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message((String)"surround.with.null.check", (Object[])new Object[0]);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtExpression ktExpression = (KtExpression)this.getElement();
        if (ktExpression == null) {
            return;
        }
        KtExpression element3 = ktExpression;
        KtExpression ktExpression2 = (KtExpression)this.nullableExpressionPointer.getElement();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression nullableExpression = ktExpression2;
        SurroundWithNullCheckUtils.INSTANCE.applyTo(project2, element3, nullableExpression);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nSurroundWithNullCheckFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SurroundWithNullCheckFix.kt\norg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$Companion\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,121:1\n125#2:122\n*S KotlinDebug\n*F\n+ 1 SurroundWithNullCheckFix.kt\norg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$Companion\n*L\n52#1:122\n*E\n"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            LexicalScope lexicalScope;
            DeclarationDescriptor declaration2;
            KtExpression expressionTarget2;
            KtReferenceExpression nullableExpression;
            block11: {
                block10: {
                    void $this$getParentOfType$iv;
                    PsiElement element3;
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    PsiElement psiElement2 = element3 = diagnostic.getPsiElement();
                    boolean strict$iv = element3 instanceof KtOperationReferenceExpression;
                    boolean $i$f$getParentOfType = false;
                    KtExpression ktExpression = (KtExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtExpression.class, (boolean)strict$iv);
                    if (ktExpression == null) {
                        return null;
                    }
                    KtExpression expressionParent = ktExpression;
                    BindingContext context2 = ResolutionUtils.analyze((KtElement)expressionParent, BodyResolveMode.PARTIAL_WITH_CFA);
                    KtReferenceExpression ktReferenceExpression = SurroundWithNullCheckUtils.INSTANCE.getNullableExpressionIfApplicable(element3);
                    if (ktReferenceExpression == null) {
                        return null;
                    }
                    nullableExpression = ktReferenceExpression;
                    if (!IfThenUtilsKt.isStableSimpleExpression((KtExpression)nullableExpression, context2)) {
                        return null;
                    }
                    Class[] classArray = new Class[]{KtExpression.class};
                    KtExpression ktExpression2 = (KtExpression)PsiUtilsKt.getParentOfTypesAndPredicate((PsiElement)((PsiElement)expressionParent), (boolean)false, (Class[])classArray, (Function1)((Function1)new Function1<KtExpression, Boolean>(context2){
                        final /* synthetic */ BindingContext $context;
                        {
                            this.$context = $context;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull KtExpression it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return !BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)it), (BindingContext)this.$context) && SurroundWithNullCheckUtils.INSTANCE.hasAcceptableParent(it);
                        }
                    }));
                    if (ktExpression2 == null) {
                        return null;
                    }
                    expressionTarget2 = ktExpression2;
                    if (expressionTarget2 instanceof KtDeclaration) {
                        return null;
                    }
                    DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)KtReferenceKt.resolveToDescriptors(ReferenceUtilsKt.getMainReference((KtReferenceExpression)nullableExpression), context2));
                    if (declarationDescriptor == null) {
                        return null;
                    }
                    declaration2 = declarationDescriptor;
                    lexicalScope = ScopeUtils.getResolutionScope((PsiElement)expressionTarget2, context2);
                    if (lexicalScope == null) break block10;
                    HierarchicalScope hierarchicalScope = (HierarchicalScope)lexicalScope;
                    Name name2 = declaration2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    lexicalScope = ScopeUtilsKt.findVariable$default((HierarchicalScope)hierarchicalScope, (Name)name2, (LookupLocation)((LookupLocation)NoLookupLocation.FROM_IDE), null, (int)4, null);
                    if (lexicalScope != null) break block11;
                }
                return null;
            }
            LexicalScope variable2 = lexicalScope;
            if (!Intrinsics.areEqual((Object)declaration2, (Object)variable2)) {
                return null;
            }
            return new SurroundWithNullCheckFix(expressionTarget2, (KtExpression)nullableExpression);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$IteratorOnNullableFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class IteratorOnNullableFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final IteratorOnNullableFactory INSTANCE = new IteratorOnNullableFactory();

        private IteratorOnNullableFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtReferenceExpression ktReferenceExpression = psiElement2 instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement2 : null;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            KtForExpression ktForExpression = SurroundWithNullCheckUtils.INSTANCE.getForExpressionIfApplicable(nullableExpression);
            if (ktForExpression == null) {
                return null;
            }
            KtForExpression forExpression = ktForExpression;
            if (!IfThenUtilsKt.isStableSimpleExpression$default((KtExpression)nullableExpression, null, 1, null)) {
                return null;
            }
            return new SurroundWithNullCheckFix((KtExpression)forExpression, (KtExpression)nullableExpression);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SurroundWithNullCheckFix$TypeMismatchFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class TypeMismatchFactory
    extends KotlinSingleIntentionActionFactory {
        @NotNull
        public static final TypeMismatchFactory INSTANCE = new TypeMismatchFactory();

        private TypeMismatchFactory() {
        }

        @Override
        @Nullable
        protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            KtReferenceExpression ktReferenceExpression = psiElement2 instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement2 : null;
            if (ktReferenceExpression == null) {
                return null;
            }
            KtReferenceExpression nullableExpression = ktReferenceExpression;
            KotlinType expectedType = null;
            KotlinType actualType = null;
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH)) {
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH.cast((UnboundDiagnostic)diagnostic);
                Object object = diagnosticWithParameters.getA();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
                expectedType = (KotlinType)object;
                Object object2 = diagnosticWithParameters.getB();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"<get-b>(...)");
                actualType = (KotlinType)object2;
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)Errors.TYPE_MISMATCH_WARNING)) {
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)Errors.TYPE_MISMATCH_WARNING.cast((UnboundDiagnostic)diagnostic);
                Object object = diagnosticWithParameters.getA();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
                expectedType = (KotlinType)object;
                Object object3 = diagnosticWithParameters.getB();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"<get-b>(...)");
                actualType = (KotlinType)object3;
            } else if (Intrinsics.areEqual((Object)diagnosticFactory, (Object)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS)) {
                DiagnosticWithParameters2 diagnosticWithParameters = (DiagnosticWithParameters2)ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.cast((UnboundDiagnostic)diagnostic);
                Object object = diagnosticWithParameters.getA();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-a>(...)");
                expectedType = (KotlinType)object;
                Object object4 = diagnosticWithParameters.getB();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"<get-b>(...)");
                actualType = (KotlinType)object4;
            } else {
                return null;
            }
            KtExpression ktExpression = SurroundWithNullCheckUtils.INSTANCE.getRootExpressionIfApplicable(nullableExpression);
            if (ktExpression == null) {
                return null;
            }
            KtExpression root = ktExpression;
            if (!TypeUtilsKt.isNullabilityMismatch((KotlinType)expectedType, (KotlinType)actualType)) {
                return null;
            }
            if (!IfThenUtilsKt.isStableSimpleExpression$default((KtExpression)nullableExpression, null, 1, null)) {
                return null;
            }
            return new SurroundWithNullCheckFix(root, (KtExpression)nullableExpression);
        }
    }
}

