/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.lang.Language;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.OverrideMethodsProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.searching.usages.ReferencesSearchScopeHelper;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinDeclarationInlineProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlineNamedDeclarationProcessorKt;
import org.jetbrains.kotlin.idea.refactoring.inline.OverrideUsageInfo;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.UsageReplacementStrategy;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.UsageReplacementStrategyKt;
import org.jetbrains.kotlin.idea.search.KotlinSearchUsagesSupport;
import org.jetbrains.kotlin.idea.search.declarationsSearch.OverridersSearchKt;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 5*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00015B9\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ1\u0010\u0017\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dH\u0016\u00a2\u0006\u0002\u0010 J\n\u0010!\u001a\u0004\u0018\u00010\"H&J\u0013\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0004\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0&2\u0006\u0010'\u001a\u00020(H\u0014J\u001d\u0010)\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0014\u00a2\u0006\u0002\u0010*J\b\u0010+\u001a\u00020\u0018H\u0016J\b\u0010,\u001a\u00020\u0018H\u0002J\b\u0010-\u001a\u00020\u0018H\u0016J\u001c\u0010.\u001a\u00020\b2\u0012\u0010/\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a00H\u0004J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H&R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineNamedDeclarationProcessor;", "TDeclaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinDeclarationInlineProcessor;", "declaration", "reference", "Lcom/intellij/psi/PsiReference;", "inlineThisOnly", "", "deleteAfter", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lcom/intellij/psi/PsiReference;ZZLcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "inliners", "", "Lcom/intellij/lang/Language;", "Lcom/intellij/lang/refactoring/InlineHandler$Inliner;", "isWritable", "()Z", "shouldDeleteAfter", "getShouldDeleteAfter", "additionalPreprocessUsages", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "conflicts", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/psi/PsiElement;", "", "([Lcom/intellij/usageView/UsageInfo;Lcom/intellij/util/containers/MultiMap;)V", "createReplacementStrategy", "Lorg/jetbrains/kotlin/idea/refactoring/inline/codeInliner/UsageReplacementStrategy;", "findUsages", "()[Lcom/intellij/usageView/UsageInfo;", "getElementsToWrite", "", "descriptor", "Lcom/intellij/usageView/UsageViewDescriptor;", "performRefactoring", "([Lcom/intellij/usageView/UsageInfo;)V", "postAction", "postActions", "postDeleteAction", "preprocessUsages", "refUsages", "Lcom/intellij/openapi/util/Ref;", "unwrapSpecialUsage", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "usage", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "Companion", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinInlineNamedDeclarationProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinInlineNamedDeclarationProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineNamedDeclarationProcessor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,199:1\n22765#2,10:200\n1603#3,9:210\n1855#3:219\n1856#3:221\n1612#3:222\n1#4:220\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinInlineNamedDeclarationProcessor.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineNamedDeclarationProcessor\n*L\n148#1:200,10\n162#1:210,9\n162#1:219\n162#1:221\n162#1:222\n162#1:220\n*E\n"})
public abstract class AbstractKotlinInlineNamedDeclarationProcessor<TDeclaration extends KtNamedDeclaration>
extends AbstractKotlinDeclarationInlineProcessor<TDeclaration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiReference reference;
    private final boolean inlineThisOnly;
    private final boolean deleteAfter;
    private Map<Language, ? extends InlineHandler.Inliner> inliners;
    @NotNull
    private static final Logger LOG;

    public AbstractKotlinInlineNamedDeclarationProcessor(@NotNull TDeclaration declaration2, @Nullable PsiReference reference2, boolean inlineThisOnly, boolean deleteAfter, @Nullable Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        super((KtDeclaration)declaration2, editor2, project2);
        this.reference = reference2;
        this.inlineThisOnly = inlineThisOnly;
        this.deleteAfter = deleteAfter;
    }

    @Nullable
    public abstract UsageReplacementStrategy createReplacementStrategy();

    @Nullable
    public abstract KtSimpleNameExpression unwrapSpecialUsage(@NotNull KtReferenceExpression var1);

    public void postAction() {
    }

    public void postDeleteAction() {
    }

    @NotNull
    protected final UsageInfo[] findUsages() {
        if (this.inlineThisOnly && this.reference != null) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.reference)};
            return usageInfoArray;
        }
        HashSet<UsageInfo> usages2 = new HashSet<UsageInfo>();
        for (PsiReference usage : ReferencesSearchScopeHelper.INSTANCE.search((KtDeclaration)this.getDeclaration(), this.myRefactoringScope)) {
            ((Collection)usages2).add(new UsageInfo(usage));
        }
        if (this.getShouldDeleteAfter()) {
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)this.getDeclaration();
            SearchScope searchScope2 = this.myRefactoringScope;
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"myRefactoringScope");
            OverridersSearchKt.forEachOverridingElement$default(ktNamedDeclaration, searchScope2, false, (Function2)new Function2<PsiElement, PsiElement, Boolean>(this, usages2){
                final /* synthetic */ AbstractKotlinInlineNamedDeclarationProcessor<TDeclaration> this$0;
                final /* synthetic */ HashSet<UsageInfo> $usages;
                {
                    this.this$0 = $receiver;
                    this.$usages = $usages;
                    super(2);
                }

                @NotNull
                public final Boolean invoke(@NotNull PsiElement psiElement2, @NotNull PsiElement overridingMember) {
                    Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)overridingMember, (String)"overridingMember");
                    List<PsiElement> superMethods = KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findSuperMethodsNoWrapping(overridingMember);
                    PsiElement psiElement3 = (PsiElement)CollectionsKt.singleOrNull(superMethods);
                    if (Intrinsics.areEqual((Object)(psiElement3 != null ? LightClassUtilsKt.getUnwrapped((PsiElement)psiElement3) : null), this.this$0.getDeclaration())) {
                        ((Collection)this.$usages).add(new OverrideUsageInfo(overridingMember));
                        return true;
                    }
                    return true;
                }
            }, 2, null);
        }
        UsageInfo[] usageInfoArray = usages2.toArray(UsageInfo.EMPTY_ARRAY);
        Intrinsics.checkNotNullExpressionValue((Object)usageInfoArray, (String)"toArray(...)");
        return usageInfoArray;
    }

    public void additionalPreprocessUsages(@NotNull UsageInfo[] usages2, @NotNull MultiMap<PsiElement, String> conflicts2) {
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        Intrinsics.checkNotNullParameter(conflicts2, (String)"conflicts");
    }

    protected final boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        Intrinsics.checkNotNullParameter(refUsages, (String)"refUsages");
        Object[] usagesInfo = (UsageInfo[])refUsages.get();
        if (this.inlineThisOnly) {
            PsiElement element3;
            Intrinsics.checkNotNull((Object)usagesInfo);
            UsageInfo usageInfo = (UsageInfo)ArraysKt.singleOrNull((Object[])usagesInfo);
            Object object = element3 = usageInfo != null ? usageInfo.getElement() : null;
            if (element3 != null && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)element3)) {
                return false;
            }
        }
        Project project2 = ((KtNamedDeclaration)this.getDeclaration()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        String string = RefactoringBundle.message((String)"detecting.possible.conflicts");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        MultiMap conflicts2 = (MultiMap)ActionUtil.underModalProgress((Project)project2, (String)string, () -> AbstractKotlinInlineNamedDeclarationProcessor.preprocessUsages$lambda$1(this, (UsageInfo[])usagesInfo));
        return this.showConflicts(conflicts2, (UsageInfo[])usagesInfo);
    }

    private final boolean getShouldDeleteAfter() {
        return this.deleteAfter && this.isWritable();
    }

    private final void postActions() {
        if (this.getShouldDeleteAfter()) {
            KotlinCommonRefactoringUtilKt.deleteWithCompanion((KtNamedDeclaration)this.getDeclaration());
            this.postDeleteAction();
        }
        this.postAction();
    }

    /*
     * WARNING - void declaration
     */
    protected void performRefactoring(@NotNull UsageInfo[] usages2) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
        if (usages2.length == 0) {
            if (!this.getShouldDeleteAfter()) {
                Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.getKind()), String.valueOf(((KtNamedDeclaration)this.getDeclaration()).getName())};
                String message2 = KotlinBundle.message((String)"0.1.is.never.used", (Object[])objectArray);
                CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.getEditor(), (String)message2, (String)this.getCommandName(), null);
            } else {
                this.postActions();
            }
            return;
        }
        UsageReplacementStrategy usageReplacementStrategy = this.createReplacementStrategy();
        if (usageReplacementStrategy == null) {
            return;
        }
        UsageReplacementStrategy replacementStrategy = usageReplacementStrategy;
        UsageInfo[] $this$partition$iv = usages2;
        boolean $i$f$partition = false;
        Object first$iv = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> second$iv = new ArrayList<UsageInfo>();
        int n = $this$partition$iv.length;
        for (int j = 0; j < n; ++j) {
            UsageInfo element$iv;
            UsageInfo it = element$iv = $this$partition$iv[j];
            boolean bl = false;
            if (!(it instanceof OverrideUsageInfo) && it.getElement() instanceof KtReferenceExpression) {
                ((ArrayList)first$iv).add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List kotlinReferenceUsages = (List)pair.component1();
        List nonKotlinReferenceUsages = (List)pair.component2();
        for (UsageInfo usage : nonKotlinReferenceUsages) {
            PsiElement element3;
            if (usage.getElement() == null) continue;
            if (usage instanceof OverrideUsageInfo) {
                OverrideMethodsProcessor processor2;
                Iterator iterator2 = OverrideMethodsProcessor.EP_NAME.getExtensionList().iterator();
                while (iterator2.hasNext() && !(processor2 = (OverrideMethodsProcessor)iterator2.next()).removeOverrideAttribute(element3)) {
                }
                continue;
            }
            if (Intrinsics.areEqual((Object)element3.getLanguage(), (Object)KotlinLanguage.INSTANCE)) {
                LOG.error("Found unexpected Kotlin usage " + element3);
                continue;
            }
            PsiElement psiElement2 = (PsiElement)this.getDeclaration();
            Map<Language, ? extends InlineHandler.Inliner> map2 = this.inliners;
            if (map2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"inliners");
                map2 = null;
            }
            GenericInlineHandler.inlineReference((UsageInfo)usage, (PsiElement)psiElement2, map2);
        }
        first$iv = kotlinReferenceUsages;
        UsageReplacementStrategy usageReplacementStrategy2 = replacementStrategy;
        boolean $i$f$mapNotNull = false;
        void element3 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            KtReferenceExpression it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl = false;
            UsageInfo it = (UsageInfo)element$iv$iv;
            boolean bl2 = false;
            PsiElement psiElement3 = it.getElement();
            if ((psiElement3 instanceof KtReferenceExpression ? (KtReferenceExpression)psiElement3 : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        UsageReplacementStrategyKt.replaceUsages(usageReplacementStrategy2, (List)destination$iv$iv, true, (Function1<? super KtReferenceExpression, ? extends KtSimpleNameExpression>)((Function1)new Function1<KtReferenceExpression, KtSimpleNameExpression>((Object)this){

            @Nullable
            public final KtSimpleNameExpression invoke(@NotNull KtReferenceExpression p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((AbstractKotlinInlineNamedDeclarationProcessor)((Object)this.receiver)).unwrapSpecialUsage(p0);
            }
        }));
        this.postActions();
    }

    private final boolean isWritable() {
        return ((KtNamedDeclaration)this.getDeclaration()).isWritable();
    }

    @NotNull
    protected Collection<PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.inlineThisOnly) {
            PsiReference psiReference = this.reference;
            collection = CollectionsKt.listOfNotNull((Object)(psiReference != null ? psiReference.getElement() : null));
        } else if (this.isWritable()) {
            Object[] objectArray = new PsiElement[2];
            PsiReference psiReference = this.reference;
            objectArray[0] = psiReference != null ? psiReference.getElement() : null;
            objectArray[1] = this.getDeclaration();
            collection = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }

    private static final boolean preprocessUsages$lambda$1$lambda$0(AbstractKotlinInlineNamedDeclarationProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return this$0.inlineThisOnly;
    }

    private static final MultiMap preprocessUsages$lambda$1(AbstractKotlinInlineNamedDeclarationProcessor this$0, UsageInfo[] $usagesInfo) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MultiMap conflicts2 = new MultiMap();
        Intrinsics.checkNotNull((Object)$usagesInfo);
        this$0.additionalPreprocessUsages($usagesInfo, (MultiMap<PsiElement, String>)conflicts2);
        for (UsageInfo usage : $usagesInfo) {
            String callableConflict;
            PsiElement element3;
            if (usage.getElement() == null || AbstractKotlinInlineNamedDeclarationProcessorKt.findCallableConflictForUsage(element3) == null) continue;
            conflicts2.putValue((Object)element3, (Object)callableConflict);
        }
        if (this$0.getShouldDeleteAfter()) {
            for (PsiElement superDeclaration : KotlinSearchUsagesSupport.SearchUtils.INSTANCE.findSuperMethodsNoWrapping((PsiElement)this$0.getDeclaration())) {
                UsageInfo usage;
                Object object = JavaPsiUtils.getKotlinFqName(superDeclaration);
                if (object == null || (object = object.asString()) == null) {
                    object = KotlinBundle.message((String)"fix.change.signature.error", (Object[])new Object[0]);
                }
                usage = object;
                Intrinsics.checkNotNull((Object)usage);
                UsageInfo fqName2 = usage;
                Object[] objectArray = new Object[]{this$0.getKind(), fqName2};
                String message2 = KotlinBundle.message((String)"text.inlined.0.overrides.0.1", (Object[])objectArray);
                conflicts2.putValue((Object)superDeclaration, (Object)message2);
            }
        }
        Language[] languageArray = new Language[]{KotlinLanguage.INSTANCE};
        Map map2 = GenericInlineHandler.initInliners((PsiElement)((PsiElement)this$0.getDeclaration()), (UsageInfo[])$usagesInfo, () -> AbstractKotlinInlineNamedDeclarationProcessor.preprocessUsages$lambda$1$lambda$0(this$0), (MultiMap)conflicts2, (Language[])languageArray);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"initInliners(...)");
        this$0.inliners = map2;
        return conflicts2;
    }

    static {
        Logger logger = Logger.getInstance(AbstractKotlinInlineNamedDeclarationProcessor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlineNamedDeclarationProcessor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.refactorings.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

